/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.workbenchutilities.actions;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

public abstract class AbstractActionOnIResources
implements IObjectActionDelegate {
    private IResource[] actionResources;
    protected IWorkbenchPart part;

    public IResource[] getActionResources() {
        return this.actionResources;
    }

    public void dispose() {
        this.actionResources = null;
        this.part = null;
    }

    public abstract void run(IAction var1);

    public void selectionChanged(IAction action, ISelection selection) {
        IStructuredSelection structuredSelection = (IStructuredSelection)selection;
        this.actionResources = null;
        Iterator iterator = structuredSelection.iterator();
        ArrayList<Object> resources = new ArrayList<Object>();
        while (iterator.hasNext()) {
            Object obj = iterator.next();
            if (obj != null && obj instanceof IResource) {
                resources.add((IResource)obj);
            }
            if (obj != null && obj instanceof ICompilationUnit) {
                resources.add(((ICompilationUnit)obj).getResource());
            }
            if (obj != null && obj instanceof IProject) {
                resources.add((IProject)obj);
            }
            if (obj == null || !(obj instanceof IJavaProject)) continue;
            resources.add(((IJavaProject)obj).getProject());
        }
        this.actionResources = resources.toArray(new IResource[resources.size()]);
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.part = targetPart;
    }
}

