/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.eomodeler.actions;

import java.util.Arrays;
import java.util.HashSet;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.AbstractOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.objectstyle.wolips.eomodeler.core.model.EOModelException;
import org.objectstyle.wolips.eomodeler.core.model.EOModelObject;
import org.objectstyle.wolips.eomodeler.core.model.EOModelVerificationFailure;
import org.objectstyle.wolips.eomodeler.core.utils.EOModelUtils;

public class AddOperation
extends AbstractOperation {
    private EOModelObject _parent;
    private EOModelObject _child;

    public AddOperation(EOModelObject parent, EOModelObject child) {
        super(EOModelUtils.getOperationLabel("Add", Arrays.asList(child)));
        this._parent = parent;
        this._child = child;
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        try {
            HashSet<EOModelVerificationFailure> failures = new HashSet<EOModelVerificationFailure>();
            this._child._addToModelParent(this._parent, true, failures);
            return Status.OK_STATUS;
        }
        catch (EOModelException e) {
            throw new ExecutionException("Failed to add object.", (Throwable)e);
        }
    }

    public IStatus redo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        return this.execute(monitor, info);
    }

    public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        try {
            HashSet<EOModelVerificationFailure> failures = new HashSet<EOModelVerificationFailure>();
            this._child._removeFromModelParent(failures);
            return Status.OK_STATUS;
        }
        catch (EOModelException e) {
            throw new ExecutionException("Failed to remove object.", (Throwable)e);
        }
    }
}

