/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.eomodeler.actions;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.objectstyle.wolips.eomodeler.actions.CutItemOperation;
import org.objectstyle.wolips.eomodeler.actions.SimpleCompositeOperation;
import org.objectstyle.wolips.eomodeler.core.model.EOModelObject;
import org.objectstyle.wolips.eomodeler.core.utils.EOModelUtils;

public class CutOperation
extends SimpleCompositeOperation {
    private List<EOModelObject> _clipboardObjects = new LinkedList<EOModelObject>();
    private ISelection _previousSelection;
    private long _previousSelectionTime;

    public CutOperation(Object[] objects) {
        super(EOModelUtils.getOperationLabel("Cut", Arrays.asList(objects)));
        for (Object obj : objects) {
            if (!(obj instanceof EOModelObject)) continue;
            EOModelObject eoModelObject = (EOModelObject)obj;
            CutItemOperation operation = new CutItemOperation(eoModelObject);
            this.add((IUndoableOperation)operation);
            this._clipboardObjects.add(eoModelObject._cloneModelObject());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        IStatus status;
        this._previousSelection = LocalSelectionTransfer.getTransfer().getSelection();
        this._previousSelectionTime = LocalSelectionTransfer.getTransfer().getSelectionSetTime();
        boolean succeeded = false;
        try {
            status = super.execute(monitor, info);
            if (status.getSeverity() == 0) {
                succeeded = true;
            }
        }
        finally {
            if (succeeded) {
                LocalSelectionTransfer.getTransfer().setSelection((ISelection)new StructuredSelection(this._clipboardObjects));
                LocalSelectionTransfer.getTransfer().setSelectionSetTime(System.currentTimeMillis());
            }
        }
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        IStatus status;
        boolean succeeded = false;
        try {
            status = super.undo(monitor, info);
            if (status.getSeverity() == 0) {
                succeeded = true;
            }
        }
        finally {
            if (succeeded) {
                LocalSelectionTransfer.getTransfer().setSelection(this._previousSelection);
                LocalSelectionTransfer.getTransfer().setSelectionSetTime(this._previousSelectionTime);
            }
        }
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IStatus redo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        IStatus status;
        this._previousSelection = LocalSelectionTransfer.getTransfer().getSelection();
        this._previousSelectionTime = LocalSelectionTransfer.getTransfer().getSelectionSetTime();
        boolean succeeded = false;
        try {
            status = super.redo(monitor, info);
            if (status.getSeverity() == 0) {
                succeeded = true;
            }
        }
        finally {
            if (succeeded) {
                LocalSelectionTransfer.getTransfer().setSelection((ISelection)new StructuredSelection(this._clipboardObjects));
                LocalSelectionTransfer.getTransfer().setSelectionSetTime(System.currentTimeMillis());
            }
        }
        return status;
    }
}

