/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.eomodeler.factories;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.objectstyle.woenvironment.env.WOEnvironment;
import org.objectstyle.woenvironment.plist.ParserDataStructureFactory;
import org.objectstyle.woenvironment.plist.PropertyListParserException;
import org.objectstyle.woenvironment.plist.SimpleParserDataStructureFactory;
import org.objectstyle.woenvironment.plist.WOLPropertyListSerialization;
import org.objectstyle.wolips.baseforplugins.util.StringUtils;
import org.objectstyle.wolips.baseforplugins.util.URLUtils;
import org.objectstyle.wolips.eomodeler.core.model.AbstractManifestEOModelGroupFactory;
import org.objectstyle.wolips.eomodeler.core.model.ManifestSearchFolder;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class EclipseProjectEOModelGroupFactory
extends AbstractManifestEOModelGroupFactory {
    @Override
    public List<ManifestSearchFolder> getSearchFolders(File selectedModelFolder) throws IOException {
        LinkedList<ManifestSearchFolder> searchFolders = null;
        LinkedList<File> eclipseProjectFolders = new LinkedList<File>();
        try {
            this.findEclipseProjectFolders(selectedModelFolder, eclipseProjectFolders);
        }
        catch (PropertyListParserException e) {
            e.printStackTrace();
            throw new IOException("Failed to parse '.EntityModeler.plist'. " + StringUtils.getErrorMessage((Throwable)e));
        }
        if (!eclipseProjectFolders.isEmpty()) {
            searchFolders = new LinkedList<ManifestSearchFolder>();
            for (File eclipseProjectFolder : eclipseProjectFolders) {
                HashSet<File> visitedProjectFolders = new HashSet<File>();
                try {
                    this.processEclipseProject(eclipseProjectFolder, searchFolders, visitedProjectFolders, new WOEnvironment());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return searchFolders;
    }

    protected File getWorkspaceFolder(File projectFolder) {
        File workspaceFolder;
        String workspaceFolderPath = System.getProperty("workspaceFolder");
        if (workspaceFolderPath != null) {
            workspaceFolder = new File(workspaceFolderPath);
        } else {
            workspaceFolder = null;
            File searchingFolder = projectFolder;
            while (searchingFolder != null && workspaceFolder == null) {
                File tempFolder = new File(searchingFolder, ".metadata");
                if (tempFolder.exists() && tempFolder.isDirectory()) {
                    workspaceFolder = searchingFolder;
                    continue;
                }
                searchingFolder = searchingFolder.getParentFile();
            }
        }
        if (workspaceFolder == null) {
            workspaceFolder = projectFolder.getParentFile();
        }
        return workspaceFolder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected File getProjectFolder(File workspaceFolder, String projectName) {
        File projectFolder = null;
        File projectLocationFile = new File(workspaceFolder, ".metadata/.plugins/org.eclipse.core.resources/.projects/" + projectName + "/.location");
        if (projectLocationFile.exists()) {
            try (FileInputStream fis = new FileInputStream(projectLocationFile);){
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                byte[] buffer = new byte[2048];
                while (fis.available() > 0) {
                    int bytesRead = fis.read(buffer);
                    baos.write(buffer, 0, bytesRead);
                }
                String locationContents = baos.toString();
                int fileIndex = locationContents.indexOf("file:");
                if (fileIndex != -1) {
                    int zeroIndex = locationContents.indexOf(0, fileIndex);
                    String projectPath = locationContents.substring(fileIndex, zeroIndex);
                    projectFolder = URLUtils.cheatAndTurnIntoFile((URL)new URL(projectPath));
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        if (projectFolder == null) {
            projectFolder = new File(workspaceFolder, projectName);
        }
        return projectFolder;
    }

    protected void processEclipseProject(File eclipseProjectFolder, List<ManifestSearchFolder> searchFolders, Set<File> visitedProjects, WOEnvironment env) throws IOException, XPathExpressionException, SAXException, ParserConfigurationException {
        String[] buildFolderNames;
        if (eclipseProjectFolder == null || !eclipseProjectFolder.exists() || visitedProjects.contains(eclipseProjectFolder)) {
            return;
        }
        for (String buildFolderName : buildFolderNames = new String[]{"build", "dist"}) {
            File woaResourcesFolder;
            File buildFolder = new File(eclipseProjectFolder, buildFolderName);
            if (!buildFolder.exists()) continue;
            File frameworkResourcesFolder = new File(buildFolder, eclipseProjectFolder.getName() + ".framework" + File.separator + "Resources");
            File buildResourcesFolder = frameworkResourcesFolder.exists() ? frameworkResourcesFolder : ((woaResourcesFolder = new File(buildFolder, eclipseProjectFolder.getName() + ".woa" + File.separator + "Contents" + File.separator + "Resources")).exists() ? woaResourcesFolder : buildFolder);
            searchFolders.add(0, new ManifestSearchFolder(buildResourcesFolder));
            break;
        }
        visitedProjects.add(eclipseProjectFolder);
        File workspaceFolder = null;
        File eclipseClasspathFile = new File(eclipseProjectFolder, ".classpath");
        if (eclipseClasspathFile.exists()) {
            XPathExpression eclipseClasspathEntryExpression = XPathFactory.newInstance().newXPath().compile("//classpath/classpathentry");
            Document eclipseClasspathDocument = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(eclipseClasspathFile);
            NodeList eclipseClasspathEntryNodes = (NodeList)eclipseClasspathEntryExpression.evaluate(eclipseClasspathDocument, XPathConstants.NODESET);
            for (int eclipseClasspathEntryNum = 0; eclipseClasspathEntryNum < eclipseClasspathEntryNodes.getLength(); ++eclipseClasspathEntryNum) {
                File referencedProjectFolder;
                Element eclipseClasspathEntryElement = (Element)eclipseClasspathEntryNodes.item(eclipseClasspathEntryNum);
                String kind = eclipseClasspathEntryElement.getAttribute("kind");
                String path = eclipseClasspathEntryElement.getAttribute("path");
                if ("src".equals(kind) && path != null && path.startsWith("/")) {
                    if (workspaceFolder == null) {
                        workspaceFolder = this.getWorkspaceFolder(eclipseProjectFolder);
                    }
                    File referencedProjectFolder2 = this.getProjectFolder(workspaceFolder, path).getCanonicalFile();
                    this.processEclipseProject(referencedProjectFolder2, searchFolders, visitedProjects, env);
                    continue;
                }
                if ("con".equals(kind) && path != null && path.startsWith("org.objectstyle.wolips.ContainerInitializer/")) {
                    String[] strs = path.split("/");
                    LinkedList<String> frameworkNames = new LinkedList<String>();
                    for (int i = 3; i < strs.length; i += 11) {
                        frameworkNames.add(strs[i]);
                    }
                    this.loadFrameworks(frameworkNames.toArray(new String[frameworkNames.size()]), searchFolders, visitedProjects, env);
                    continue;
                }
                if ("con".equals(kind) && path != null && path.startsWith("org.objectstyle.wolips.WO_CLASSPATH/")) {
                    String[] frameworkNames = path.split("/");
                    this.loadFrameworks(frameworkNames, searchFolders, visitedProjects, env);
                    continue;
                }
                if (!"con".equals(kind) || path == null || !path.startsWith("WOFramework/")) continue;
                String frameworkName = path.substring(path.indexOf("/") + 1);
                if (workspaceFolder == null) {
                    workspaceFolder = this.getWorkspaceFolder(eclipseProjectFolder);
                }
                if ((referencedProjectFolder = this.getProjectFolder(workspaceFolder, frameworkName).getCanonicalFile()).exists()) {
                    this.processEclipseProject(referencedProjectFolder, searchFolders, visitedProjects, env);
                    continue;
                }
                this.loadFrameworks(new String[]{frameworkName}, searchFolders, visitedProjects, env);
            }
        }
    }

    protected void loadFrameworks(String[] frameworkNames, List<ManifestSearchFolder> searchFolders, Set<File> visitedProjects, WOEnvironment env) throws IOException {
        File userFrameworksFolder = new File(env.getWOVariables().userFrameworkPath());
        File localFrameworksFolder = new File(env.getWOVariables().localFrameworkPath());
        File systemFrameworksFolder = new File(env.getWOVariables().systemFrameworkPath());
        for (int frameworkNum = 1; frameworkNum < frameworkNames.length; ++frameworkNum) {
            String frameworkFolderName = frameworkNames[frameworkNum] + ".framework";
            File matchingFrameworkFolder = null;
            File userFrameworkFolder = new File(userFrameworksFolder, frameworkFolderName);
            if (userFrameworkFolder.exists()) {
                matchingFrameworkFolder = userFrameworkFolder.getCanonicalFile();
            } else {
                File localFrameworkFolder = new File(localFrameworksFolder, frameworkFolderName);
                if (localFrameworkFolder.exists()) {
                    matchingFrameworkFolder = localFrameworkFolder.getCanonicalFile();
                } else {
                    File systemFrameworkFolder = new File(systemFrameworksFolder, frameworkFolderName);
                    if (systemFrameworkFolder.exists()) {
                        matchingFrameworkFolder = systemFrameworkFolder.getCanonicalFile();
                    }
                }
            }
            if (matchingFrameworkFolder == null || visitedProjects.contains(matchingFrameworkFolder)) continue;
            ManifestSearchFolder searchFolder = new ManifestSearchFolder(new File(matchingFrameworkFolder, "Resources"));
            if (!searchFolders.contains(searchFolder)) {
                searchFolders.add(searchFolder);
            }
            visitedProjects.add(matchingFrameworkFolder);
        }
    }

    protected void findEclipseProjectFolders(File folder, List<File> eclipseProjectFolders) throws IOException, PropertyListParserException {
        if (folder != null) {
            boolean foundProjectFolders = false;
            if (folder.isDirectory()) {
                File projectLocator = new File(folder, ".EntityModeler.plist");
                if (projectLocator.exists()) {
                    List projectFilePaths;
                    Map projectProperties = (Map)WOLPropertyListSerialization.propertyListWithContentsOfFile((String)projectLocator.getCanonicalPath(), (ParserDataStructureFactory)new SimpleParserDataStructureFactory());
                    Map dependencies = (Map)projectProperties.get("Dependencies");
                    if (dependencies != null && (projectFilePaths = (List)dependencies.get("Eclipse")) != null) {
                        for (String projectFilePath : projectFilePaths) {
                            File projectFolder = new File(projectFilePath);
                            if (!projectFolder.exists()) {
                                projectFolder = new File(folder, projectFilePath);
                            }
                            if (!projectFolder.exists() || !this.isEclipseProjectFolder(projectFolder = projectFolder.getCanonicalFile())) continue;
                            eclipseProjectFolders.add(projectFolder);
                            foundProjectFolders = true;
                        }
                    }
                } else if (this.isEclipseProjectFolder(folder)) {
                    File eclipseProjectFolder = folder.getCanonicalFile();
                    eclipseProjectFolders.add(eclipseProjectFolder);
                    foundProjectFolders = true;
                }
            }
            if (!foundProjectFolders) {
                File parentFolder = folder.getParentFile();
                this.findEclipseProjectFolders(parentFolder, eclipseProjectFolders);
            }
        }
    }

    public boolean isEclipseProjectFolder(File folder) {
        return new File(folder, ".project").exists() && new File(folder, ".classpath").exists();
    }
}

