/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.componenteditor.inspector;

import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.objectstyle.wolips.bindings.wod.BindingValueKey;
import org.objectstyle.wolips.componenteditor.inspector.WOBrowserColumn;

public class BindingsDragHandler
implements DragSourceListener,
PaintListener,
DropTargetListener {
    private static final int endpointSize = 3;
    private WOBrowserColumn _browserColumn;
    private Point _startingPoint;
    private Point _currentPoint;
    private Canvas _lineCanvas;

    public BindingsDragHandler(WOBrowserColumn browserColumn) {
        this._browserColumn = browserColumn;
        this._browserColumn.getViewer().addDragSupport(1, new Transfer[]{LocalSelectionTransfer.getTransfer()}, (DragSourceListener)this);
    }

    public Shell getShell() {
        return this._browserColumn.getShell();
    }

    public void createCanvas() {
        Shell shell = this.getShell();
        if (this._lineCanvas == null) {
            this._lineCanvas = new Canvas((Composite)shell, 262144);
            this._lineCanvas.setLocation(0, 0);
            this._lineCanvas.setSize(shell.getSize());
            this._lineCanvas.moveAbove(null);
            this._lineCanvas.addPaintListener((PaintListener)this);
            this._lineCanvas.setCapture(false);
            this._lineCanvas.setEnabled(false);
            DropTarget dropTarget = new DropTarget((Control)this._lineCanvas, 7);
            LocalSelectionTransfer transfer = LocalSelectionTransfer.getTransfer();
            transfer.setSelection((ISelection)new StructuredSelection((Object)"Test"));
            dropTarget.setTransfer(new Transfer[]{transfer});
            dropTarget.addDropListener((DropTargetListener)this);
        }
    }

    public void disposeCanvas() {
        if (this._lineCanvas != null) {
            if (!this._lineCanvas.isDisposed()) {
                this._lineCanvas.removePaintListener((PaintListener)this);
                this._lineCanvas.dispose();
            }
            this._lineCanvas = null;
        }
    }

    public void paintControl(PaintEvent e) {
        if (this._startingPoint != null && this._currentPoint != null) {
            Point startingPoint = this.getShell().toControl(this._startingPoint);
            Point currentPoint = this.getShell().toControl(this._currentPoint);
            e.gc.setForeground(e.widget.getDisplay().getSystemColor(2));
            e.gc.setBackground(e.widget.getDisplay().getSystemColor(2));
            e.gc.setLineWidth(2);
            e.gc.setLineJoin(2);
            e.gc.drawOval(currentPoint.x - 3, currentPoint.y - 3, 6, 6);
            e.gc.drawLine(startingPoint.x, startingPoint.y, currentPoint.x, startingPoint.y);
            e.gc.drawLine(currentPoint.x, startingPoint.y, currentPoint.x, currentPoint.y);
            e.gc.fillRectangle(startingPoint.x - 3, startingPoint.y - 3, 6, 6);
        }
    }

    public void dispose() {
        this.disposeCanvas();
    }

    public void dragEnter(DropTargetEvent event) {
        event.detail = 1;
    }

    public void dragLeave(DropTargetEvent event) {
    }

    public void dragOperationChanged(DropTargetEvent event) {
        event.detail = 1;
    }

    public void dragOver(DropTargetEvent event) {
        Point lastPoint = this._currentPoint;
        this._currentPoint = new Point(event.x, event.y);
        Point startingPoint = this.getShell().toControl(this._startingPoint);
        Point currentPoint = this.getShell().toControl(this._currentPoint);
        int redrawX1 = Math.min(startingPoint.x, currentPoint.x);
        int redrawY1 = Math.min(startingPoint.y, currentPoint.y);
        int redrawX2 = Math.max(startingPoint.x, currentPoint.x);
        int redrawY2 = Math.max(startingPoint.y, currentPoint.y);
        if (lastPoint != null) {
            lastPoint = this.getShell().toControl(lastPoint);
            redrawX1 = Math.min(redrawX1, lastPoint.x);
            redrawY1 = Math.min(redrawY1, lastPoint.y);
            redrawX2 = Math.max(redrawX2, lastPoint.x);
            redrawY2 = Math.max(redrawY2, lastPoint.y);
        }
        int slop = 8;
        this._lineCanvas.redraw(redrawX1 -= slop, redrawY1 -= slop, (redrawX2 += slop) - redrawX1, (redrawY2 += slop) - redrawY1, true);
        event.detail = 1;
        if (this._browserColumn.getDelegate() != null) {
            this._browserColumn.getDelegate().bindingDragging(this._browserColumn, this._currentPoint);
        }
    }

    public void drop(DropTargetEvent event) {
        this._currentPoint = new Point(event.x, event.y);
    }

    public void dropAccept(DropTargetEvent event) {
        event.detail = 1;
    }

    public void dragFinished(boolean dropPerformed) {
        this.disposeCanvas();
    }

    public void drop() {
    }

    public Cursor getCursor() {
        return null;
    }

    public Rectangle getSnapRectangle() {
        return null;
    }

    public void bindingDropFinished() {
        this.disposeCanvas();
    }

    public void dragFinished(DragSourceEvent event) {
        if (this._browserColumn.getDelegate() != null) {
            if (event.doit) {
                boolean dropFinished = this._browserColumn.getDelegate().bindingDropped(this._browserColumn, this._currentPoint, this);
                if (dropFinished) {
                    this.disposeCanvas();
                }
            } else {
                this.disposeCanvas();
                this._browserColumn.getDelegate().bindingDragCanceled(this._browserColumn);
            }
        } else {
            this.disposeCanvas();
        }
    }

    public void dragSetData(DragSourceEvent event) {
        event.data = this._browserColumn.getSelection();
    }

    public void dragStart(DragSourceEvent event) {
        Object obj;
        DragSource dragSource = (DragSource)event.getSource();
        Control control = dragSource.getControl();
        this._startingPoint = null;
        this._currentPoint = null;
        event.detail = 1;
        event.doit = false;
        ISelection selection = this._browserColumn.getSelection();
        if (selection instanceof IStructuredSelection && (obj = ((IStructuredSelection)selection).getFirstElement()) instanceof BindingValueKey) {
            Control listControl = this._browserColumn.getViewer().getControl();
            Rectangle listBounds = listControl.getBounds();
            TableItem itemControl = (TableItem)this._browserColumn.getViewer().testFindItem(obj);
            Rectangle itemBounds = itemControl.getBounds();
            int magicRightMarginOnMac = 27;
            this._startingPoint = control.toDisplay(new Point(listBounds.x + listBounds.width - magicRightMarginOnMac, itemBounds.y + itemBounds.height / 2));
            event.doit = true;
        }
        if (event.doit) {
            this.createCanvas();
        }
    }
}

