/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.componenteditor.inspector;

import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.objectstyle.wolips.bindings.api.IApiBinding;
import org.objectstyle.wolips.componenteditor.inspector.AbstractBindingsDropHandler;
import org.objectstyle.wolips.componenteditor.inspector.BindingsDragHandler;
import org.objectstyle.wolips.componenteditor.inspector.BindingsInspector;
import org.objectstyle.wolips.componenteditor.inspector.IAutoscroller;
import org.objectstyle.wolips.componenteditor.inspector.NoOpAutoscroller;
import org.objectstyle.wolips.componenteditor.inspector.WOBrowserColumn;
import org.objectstyle.wolips.wodclipse.core.refactoring.RefactoringWodElement;

public class BindingsInspectorDropHandler
extends AbstractBindingsDropHandler<BindingsInspector, TableItem, Object, Table> {
    private BindingsInspector _inspector;

    public BindingsInspectorDropHandler(BindingsInspector inspector) {
        super(inspector.getBindingsTableViewer().getTable());
        this._inspector = inspector;
    }

    @Override
    protected Object _addHoverAnnotation(TableItem selectedItem) {
        return selectedItem;
    }

    @Override
    protected void _removeHoverAnnotation(Object annotation) {
    }

    @Override
    protected IAutoscroller createAutoscroller(Table editorControl) {
        return new NoOpAutoscroller();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean dropFromColumnAtPoint(WOBrowserColumn column, Point dropPoint, BindingsDragHandler dragHandler) throws Exception {
        boolean dropFinished = true;
        try {
            IApiBinding binding;
            Point controlDropPoint = ((Table)this.getEditorControl()).toControl(dropPoint);
            TableItem selectedItem = this.getSelectedItemAtPoint(this._inspector, controlDropPoint);
            if (selectedItem != null && (binding = this.getBindingForItem(selectedItem)) != null) {
                String droppedKeyPath = column.getSelectedKeyPath();
                RefactoringWodElement element = this._inspector.getRefactoringElement();
                if (element != null) {
                    try {
                        element.setValueForBinding(droppedKeyPath, binding.getName());
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        finally {
            this.removeHoverAnnotation();
        }
        return dropFinished;
    }

    @Override
    protected BindingsInspector getSelectedContainerAtPoint(Point point, boolean forDrop) throws Exception {
        return this._inspector;
    }

    @Override
    protected TableItem getSelectedItemAtPoint(BindingsInspector container, Point point) {
        TableViewer tableViewer = container.getBindingsTableViewer();
        Table table = tableViewer.getTable();
        TableItem item = table.getItem(point);
        return item;
    }

    @Override
    protected Rectangle getSelectionRectangle(TableItem item) {
        TableViewer tableViewer = this._inspector.getBindingsTableViewer();
        Table table = tableViewer.getTable();
        Rectangle rowBounds = item.getBounds();
        Rectangle bounds = new Rectangle(5, rowBounds.y, table.getBounds().width - 25, rowBounds.height);
        return bounds;
    }

    @Override
    protected boolean isSelectedItemChanged(TableItem oldItem, TableItem newItem) {
        return oldItem == null || newItem == null || !this.getBindingForItem(oldItem).getName().equals(this.getBindingForItem(newItem).getName());
    }

    protected IApiBinding getBindingForItem(TableItem item) {
        TableViewer tableViewer;
        Table table;
        int index;
        IApiBinding binding = item == null ? null : ((index = (table = (tableViewer = this._inspector.getBindingsTableViewer()).getTable()).indexOf(item)) == -1 ? null : (IApiBinding)tableViewer.getElementAt(index));
        return binding;
    }
}

