/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.builder.internal;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.runtime.CoreException;
import org.objectstyle.wolips.builder.internal.DefaultDeltaVisitor;
import org.objectstyle.wolips.core.resources.types.project.IProjectPatternsets;

final class BuildResourceValidator
extends DefaultDeltaVisitor {
    private boolean buildRequired = false;
    private IProjectPatternsets projectPatternsets;

    public void reset() {
        this.buildRequired = false;
    }

    @Override
    public final boolean visit(IResourceDelta delta) throws CoreException {
        if (this.buildRequired) {
            return false;
        }
        if (!super.visit(delta)) {
            return false;
        }
        IResource resource = delta.getResource();
        return this.examineResource(resource, delta.getKind());
    }

    private final boolean examineResource(IResource resource, int kindOfChange) {
        if (this.buildRequired) {
            return false;
        }
        if (!resource.isAccessible() && kindOfChange != 2) {
            return false;
        }
        if (resource.isDerived()) {
            return false;
        }
        switch (resource.getType()) {
            case 8: {
                return true;
            }
            case 4: {
                this.projectPatternsets = (IProjectPatternsets)resource.getAdapter(IProjectPatternsets.class);
                return true;
            }
            case 2: {
                String extension = resource.getFileExtension();
                if (extension != null && (extension.equals("framework") || extension.equals("woa") || extension.equals("xcode") || extension.equals("xcodeproj"))) {
                    return false;
                }
                if (resource.getName().equals("build") || resource.getName().equals("dist") || resource.getName().equals("target")) {
                    return false;
                }
                if (resource.getName().equals(".svn") || resource.getName().equals("CVS")) {
                    return false;
                }
                if (resource.getName().endsWith("~")) {
                    return false;
                }
                if (this.projectPatternsets.matchesResourcesPattern(resource) || this.projectPatternsets.matchesWOAppResourcesPattern(resource) || this.projectPatternsets.matchesClassesPattern(resource)) {
                    this.buildRequired = true;
                    return false;
                }
                return true;
            }
            case 1: {
                if (!this.needsUpdate(kindOfChange)) break;
                if (".project".equals(resource.getName()) || "PB.project".equals(resource.getName()) || ".classpath".equals(resource.getName()) || "Makefile".equals(resource.getName()) || resource.getName().startsWith("ant.")) {
                    return false;
                }
                if (resource.getName().equals("build.properties")) {
                    this.buildRequired = true;
                    return false;
                }
                if (resource.getName().equals("pom.xml")) {
                    this.buildRequired = true;
                    return false;
                }
                if (!resource.getName().endsWith(".java") && !this.projectPatternsets.matchesResourcesPattern(resource) && !this.projectPatternsets.matchesWOAppResourcesPattern(resource) && !this.projectPatternsets.matchesClassesPattern(resource)) break;
                this.buildRequired = true;
                return false;
            }
        }
        return false;
    }

    private final boolean needsUpdate(int kindOfChange) {
        return 1 == kindOfChange || 2 == kindOfChange || 4 == kindOfChange;
    }

    public boolean isBuildRequired() {
        return this.buildRequired;
    }
}

