/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.builder.internal;

import java.io.File;
import java.util.HashMap;
import org.eclipse.core.internal.resources.ResourceException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.objectstyle.wolips.baseforplugins.util.FileUtilities;

public class ResourceUtilities {
    private static int _uniqifier = 1;

    public static void createFolder(IFolder f, IProgressMonitor m) throws CoreException {
        if (f.exists()) {
            return;
        }
        IContainer parent = f.getParent();
        if (!f.getParent().exists() && parent instanceof IFolder) {
            ResourceUtilities.createFolder((IFolder)parent, m);
        }
        f.create(true, true, m);
    }

    public static boolean checkDir(IPath path, IProgressMonitor m) throws CoreException {
        return ResourceUtilities.checkDir(path, m, false);
    }

    public static boolean checkDerivedDir(IPath path, IProgressMonitor m) throws CoreException {
        return ResourceUtilities.checkDir(path, m, true);
    }

    public static boolean checkDir(IPath path, IProgressMonitor m, boolean derived) throws CoreException {
        boolean result = true;
        IFolder f = ResourceUtilities.getWorkspaceRoot().getFolder(path);
        if (!f.exists()) {
            ResourceUtilities.createFolder(f, m);
            if (derived) {
                f.setDerived(true);
            }
            result = false;
        }
        return result;
    }

    public static IResource checkDestination(IPath path, IProgressMonitor m, boolean deleteIfExists) throws CoreException {
        return ResourceUtilities.checkDestination(path, m, false, deleteIfExists);
    }

    public static IResource checkDerivedDestination(IPath path, IProgressMonitor m, boolean deleteIfExists) throws CoreException {
        return ResourceUtilities.checkDestination(path, m, true, deleteIfExists);
    }

    public static IResource checkDestination(IPath path, IProgressMonitor m, boolean derived, boolean deleteIfExists) throws CoreException {
        if (ResourceUtilities.checkDir(path.removeLastSegments(1), m, derived)) {
            IResource res = ResourceUtilities.getWorkspaceRoot().findMember(path);
            if (null != res && res.exists()) {
                if (deleteIfExists) {
                    try {
                        File f = res.getLocation().toFile();
                        if (f.exists()) {
                            FileUtilities.deleteRecursively((File)f);
                        } else {
                            res.delete(true, m);
                        }
                    }
                    catch (CoreException ce) {
                        ce.printStackTrace();
                        IPath trashFolder = res.getProject().getFullPath().append("build/.trash");
                        IPath trashPath = trashFolder.append(res.getName() + ResourceUtilities._getUniqifier());
                        ResourceUtilities.checkDir(trashFolder, m);
                        res.move(trashPath, true, null);
                    }
                }
                res.refreshLocal(1, m);
            }
            return res;
        }
        return null;
    }

    private static synchronized int _getUniqifier() {
        return _uniqifier++;
    }

    public static void copyDerivedOld(IResource res, IPath dest, IProgressMonitor m) throws CoreException {
        if (res.isTeamPrivateMember() || res.getName().equals(".svn")) {
            return;
        }
        IResource rdest = ResourceUtilities.checkDestination(dest, m, true);
        res.copy(dest, true, null);
        if (null != rdest) {
            rdest.setDerived(true);
        }
    }

    public static void copyDerived(IResource res, IPath dest, IProgressMonitor m) throws CoreException {
        if (res.isTeamPrivateMember() || res.getName().equals(".svn")) {
            return;
        }
        if (res instanceof IFolder) {
            IResource[] members = ((IFolder)res).members();
            boolean deleteDestination = !res.getName().equals("Nonlocalized.lproj");
            IResource rdest = ResourceUtilities.checkDerivedDestination(dest, m, deleteDestination);
            for (int i = 0; i < members.length; ++i) {
                IResource thisOne = members[i];
                if (members[i].isTeamPrivateMember()) continue;
                IPath thisDest = dest.append(thisOne.getName());
                ResourceUtilities.copyDerived(thisOne, thisDest, m);
            }
            if (null != rdest) {
                rdest.setDerived(true);
            }
        } else {
            IResource rdest = ResourceUtilities.checkDestination(dest, m, true);
            res.copy(dest, true, m);
            if (null != rdest) {
                rdest.setDerived(true);
            }
        }
    }

    public static IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    public static IWorkspaceRoot getWorkspaceRoot() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    protected ResourceUtilities() {
    }

    public static void unmarkResource(IResource res, String markerId) throws CoreException {
        if (res.exists()) {
            res.deleteMarkers(markerId, true, 0);
        }
    }

    public static IMarker markResource(IResource res, String markerId, int severity, String message, String location) throws CoreException {
        IMarker newMarker;
        if (!res.exists()) {
            newMarker = null;
        } else {
            try {
                IMarker[] marker = res.findMarkers(markerId, true, 0);
                if (marker.length != 1) {
                    if (marker.length > 1) {
                        res.deleteMarkers(markerId, false, 0);
                    }
                    marker = new IMarker[]{res.createMarker(markerId)};
                }
                if (!marker[0].exists()) {
                    marker[0] = res.createMarker(markerId);
                }
                HashMap<String, Object> attr = new HashMap<String, Object>();
                attr.put("priority", 2);
                attr.put("severity", severity);
                attr.put("message", message);
                attr.put("location", location);
                marker[0].setAttributes(attr);
                newMarker = marker[0];
            }
            catch (ResourceException e) {
                e.printStackTrace();
                newMarker = null;
            }
        }
        return newMarker;
    }
}

