/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.ui.preferences;

import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.objectstyle.wolips.preferences.Preferences;
import org.objectstyle.wolips.ui.preferences.WOLipsDirectoryFieldEditor;
import org.objectstyle.wolips.variables.ProjectVariables;
import org.objectstyle.wolips.variables.VariablesPlugin;

public class WOLipsPropertiesPreferencesPage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private StringFieldEditor _wolipsPropertiesFieldEditor;

    public WOLipsPropertiesPreferencesPage() {
        super(1);
        this.setDescription("The following folders define the locations of your frameworks, javadoc, and install locations that are required to successfully build WebObjects applications with WOLips.");
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getSource() instanceof FieldEditor && "org.objectstyle.wolips.wolipsPropertiesFile".equals(((FieldEditor)event.getSource()).getPreferenceName())) {
            this.setPreferenceStore(this.doGetPreferenceStore());
            this.initialize();
            this.checkState();
        }
        super.propertyChange(event);
    }

    protected IPreferenceStore doGetPreferenceStore() {
        String wolipsPropertiesName = this._wolipsPropertiesFieldEditor.getStringValue();
        if (wolipsPropertiesName == null || wolipsPropertiesName.length() == 0) {
            wolipsPropertiesName = Preferences.getPreferenceStore().getString("org.objectstyle.wolips.wolipsPropertiesFile");
        }
        ProjectVariables preferenceStore = VariablesPlugin.getDefault().getGlobalVariables(wolipsPropertiesName);
        preferenceStore.setValue("wolips.properties", wolipsPropertiesName);
        return preferenceStore;
    }

    public void createFieldEditors() {
        int widthInChars = 50;
        this._wolipsPropertiesFieldEditor = new StringFieldEditor("org.objectstyle.wolips.wolipsPropertiesFile", "WOLips Properties File", widthInChars, 1, this.getFieldEditorParent()){

            public void setPreferenceStore(IPreferenceStore store) {
                super.setPreferenceStore(store == null ? null : Preferences.getPreferenceStore());
            }

            public void loadDefault() {
                super.loadDefault();
                this.getTextControl().setText(this.getPreferenceStore().getDefaultString(this.getPreferenceName()));
            }
        };
        this.addField((FieldEditor)this._wolipsPropertiesFieldEditor);
        this.addField((FieldEditor)new WOLipsDirectoryFieldEditor("wo.network.frameworks", "Network Frameworks", widthInChars, this.getFieldEditorParent()));
        this.addField((FieldEditor)new WOLipsDirectoryFieldEditor("wo.system.frameworks", "System Frameworks", widthInChars, this.getFieldEditorParent()));
        this.addField((FieldEditor)new WOLipsDirectoryFieldEditor("wo.local.frameworks", "Local Frameworks", widthInChars, this.getFieldEditorParent()));
        this.addField((FieldEditor)new WOLipsDirectoryFieldEditor("wo.user.frameworks", "User Frameworks", widthInChars, this.getFieldEditorParent()));
        this.addField((FieldEditor)new WOLipsDirectoryFieldEditor("wo.network.root", "Network Root", widthInChars, this.getFieldEditorParent()));
        this.addField((FieldEditor)new WOLipsDirectoryFieldEditor("wo.system.root", "System Root", widthInChars, this.getFieldEditorParent()));
        this.addField((FieldEditor)new WOLipsDirectoryFieldEditor("wo.local.root", "Local Root", widthInChars, this.getFieldEditorParent()));
        this.addField((FieldEditor)new WOLipsDirectoryFieldEditor("wo.user.root", "User Root", widthInChars, this.getFieldEditorParent()));
        this.addField((FieldEditor)new WOLipsDirectoryFieldEditor("wo.extensions", "WebObjects Extensions", widthInChars, this.getFieldEditorParent()));
        this.addField((FieldEditor)new WOLipsDirectoryFieldEditor("wo.apps.root", "Installed Applications", widthInChars, this.getFieldEditorParent()));
        this.addField((FieldEditor)new WOLipsDirectoryFieldEditor("wo.api.root", "WebObjects Javadoc", widthInChars, this.getFieldEditorParent()));
    }

    public boolean isValid() {
        return true;
    }

    public boolean okToLeave() {
        return true;
    }

    public void init(IWorkbench workbench) {
    }
}

