/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.eomodeler.core.kvc;

import org.objectstyle.wolips.eomodeler.core.kvc.IKey;
import org.objectstyle.wolips.eomodeler.core.kvc.Key;
import org.objectstyle.wolips.eomodeler.core.kvc.ResolvedKeyPath;

public class KeyPath
implements IKey {
    private String[] myKeyNames;
    private Key[] myKeys;

    public KeyPath(String _keyPath) {
        this(_keyPath.split("\\."));
    }

    public KeyPath(String[] _keyNames) {
        this.myKeyNames = _keyNames;
    }

    public KeyPath(Key[] _keys) {
        this.myKeys = _keys;
        this.myKeyNames = new String[_keys.length];
        for (int keyNum = 0; keyNum < _keys.length; ++keyNum) {
            this.myKeyNames[keyNum] = _keys[keyNum].getName();
        }
    }

    public String toKeyPath() {
        StringBuffer sb = new StringBuffer();
        for (int keyNum = 0; keyNum < this.myKeyNames.length; ++keyNum) {
            sb.append(this.myKeyNames[keyNum]);
            sb.append(".");
        }
        if (this.myKeyNames.length > 0) {
            sb.setLength(sb.length() - 1);
        }
        return sb.toString();
    }

    public ResolvedKeyPath toResolvedKey(Class _declaringClass) {
        return new ResolvedKeyPath(_declaringClass, this.myKeyNames);
    }

    protected Key[] getKeys() {
        if (this.myKeys == null) {
            Key key = null;
            this.myKeys = new Key[this.myKeyNames.length];
            for (int keyNum = 0; keyNum < this.myKeys.length; ++keyNum) {
                this.myKeys[keyNum] = key = this.createKey(key, this.myKeyNames[keyNum]);
            }
        }
        return this.myKeys;
    }

    protected Key createKey(Key _previousKey, String _keyName) {
        return new Key(_keyName);
    }

    @Override
    public Class getType(Object _instance) {
        Class type = null;
        Key[] keys = this.getKeys();
        if (keys.length > 0) {
            type = keys[keys.length - 1].getType(_instance);
        }
        return type;
    }

    @Override
    public void setValue(Object _instance, Object _value) {
        Key[] keys = this.getKeys();
        Object instance = _instance;
        for (int keyNum = 0; instance != null && keyNum < keys.length - 1; ++keyNum) {
            Key key = keys[keyNum];
            instance = key.getValue(instance);
        }
        if (instance != null) {
            keys[keys.length - 1].setValue(instance, _value);
        }
    }

    @Override
    public Object getValue(Object _instance) {
        Key[] keys = this.getKeys();
        Object instance = _instance;
        for (int keyNum = 0; instance != null && keyNum < keys.length; ++keyNum) {
            Key key = keys[keyNum];
            instance = key.getValue(instance);
        }
        return instance;
    }

    public String toString() {
        return "[KeyPath: " + this.toKeyPath() + "]";
    }

    public static Object getValue(Object _instance, String _keyPath) {
        Object value;
        if (_instance == null) {
            value = null;
        } else {
            ResolvedKeyPath keyPath = new ResolvedKeyPath(_instance.getClass(), _keyPath);
            value = keyPath.getValue(_instance);
        }
        return value;
    }
}

