/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.jdt.classpath;

import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.objectstyle.wolips.jdt.JdtPlugin;
import org.objectstyle.wolips.jdt.ProjectFrameworkAdapter;
import org.objectstyle.wolips.jdt.classpath.model.EclipseProjectFramework;

public class WOFrameworkResourceListener
implements IResourceChangeListener {
    protected synchronized void woFrameworkChanged(String frameworkName) throws CoreException {
        JdtPlugin.getDefault().invalidateFrameworkModel();
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        ArrayList<IJavaProject> javaProjects = new ArrayList<IJavaProject>(projects.length);
        for (int i = 0; i < projects.length; ++i) {
            if (!projects[i].isAccessible()) continue;
            javaProjects.add(JavaCore.create((IProject)projects[i]));
        }
        IClasspathContainer[] containers = new IClasspathContainer[javaProjects.size()];
        IJavaProject[] javaProjectsArray = javaProjects.toArray(new IJavaProject[javaProjects.size()]);
        Path containerPath = new Path(JavaCore.getClasspathContainerInitializer((String)"WOFramework") + "/" + frameworkName);
        JavaCore.setClasspathContainer((IPath)containerPath, (IJavaProject[])javaProjectsArray, (IClasspathContainer[])containers, null);
    }

    public void resourceChanged(IResourceChangeEvent event) {
        IResourceDelta delta = event.getDelta();
        if (delta != null) {
            IResourceDelta[] resourceDeltas = delta.getAffectedChildren(7);
            for (int i = 0; i < resourceDeltas.length; ++i) {
                IProject project;
                IResourceDelta resourceDelta = resourceDeltas[i];
                IResource resource = resourceDelta.getResource();
                if (!(resource instanceof IProject)) continue;
                if ((resourceDelta.getFlags() & 0x4000) != 0) {
                    ProjectFrameworkAdapter projectFrameworkAdapter;
                    project = (IProject)resource;
                    if (project.isOpen() && (projectFrameworkAdapter = (ProjectFrameworkAdapter)project.getAdapter(ProjectFrameworkAdapter.class)) != null) {
                        new WorkspaceJob("Initialize WOLips Project"){

                            public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                                projectFrameworkAdapter.initializeProject();
                                return Status.OK_STATUS;
                            }
                        }.schedule();
                    }
                    try {
                        this.woFrameworkChanged(EclipseProjectFramework.frameworkNameForProject(project));
                    }
                    catch (CoreException e) {
                        e.printStackTrace();
                    }
                    continue;
                }
                if (resourceDelta.getKind() == 2) {
                    project = (IProject)resource;
                    try {
                        this.woFrameworkChanged(EclipseProjectFramework.frameworkNameForProject(project));
                    }
                    catch (CoreException e) {
                        e.printStackTrace();
                    }
                    continue;
                }
                if (resourceDelta.getKind() != 1) continue;
                project = (IProject)resource;
                try {
                    this.woFrameworkChanged(EclipseProjectFramework.frameworkNameForProject(project));
                    continue;
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

