/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.jdt.ui;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.internal.ui.packageview.WorkingSetAwareContentProvider;
import org.eclipse.jdt.internal.ui.workingsets.WorkingSetModel;
import org.objectstyle.wolips.jdt.ui.WOPackageExplorerContentProvider;
import org.objectstyle.wolips.jdt.ui.WOPackageExplorerPart;
import org.objectstyle.wolips.jdt.ui.tags.ITaggedComponentsContentProvider;
import org.objectstyle.wolips.jdt.ui.tags.TaggedComponentsContentProvider;
import org.objectstyle.wolips.jdt.ui.tags.WOTagLibResourceChangeListener;

public class WOWorkingSetAwareContentProvider
extends WorkingSetAwareContentProvider {
    private IResourceChangeListener resourceChangeListener;
    WOPackageExplorerPart woPackageExplorerPart;
    Map<IProject, TaggedComponentsContentProvider> taggedComponentsContentProviders = new HashMap<IProject, TaggedComponentsContentProvider>();

    public WOWorkingSetAwareContentProvider(boolean provideMembers, WorkingSetModel model, WOPackageExplorerPart woPackageExplorerPart) {
        super(provideMembers, model);
        this.woPackageExplorerPart = woPackageExplorerPart;
        this.resourceChangeListener = new WOTagLibResourceChangeListener(){

            @Override
            public void update(IProject project) {
                TaggedComponentsContentProvider taggedComponentsContentProvider = WOWorkingSetAwareContentProvider.this.taggedComponentsContentProviders.get(project);
                if (taggedComponentsContentProvider != null) {
                    taggedComponentsContentProvider.forgetTagLib();
                    WOWorkingSetAwareContentProvider.this.woPackageExplorerPart.getTreeViewer().refresh((Object)taggedComponentsContentProvider);
                }
            }
        };
        ResourcesPlugin.getWorkspace().addResourceChangeListener(this.resourceChangeListener, 1);
    }

    protected Object[] getFolderContent(IFolder folder) throws CoreException {
        Object[] contents = WOPackageExplorerContentProvider.isBundle(folder) ? NO_CHILDREN : super.getFolderContent(folder);
        return contents;
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof ITaggedComponentsContentProvider) {
            ITaggedComponentsContentProvider taggedComponentsContentProvider = (ITaggedComponentsContentProvider)parentElement;
            return taggedComponentsContentProvider.getChildren();
        }
        Object[] children = super.getChildren(parentElement);
        if (parentElement instanceof IJavaProject && children.length > 2) {
            IJavaProject javaProject = (IJavaProject)parentElement;
            IProject project = javaProject.getProject();
            TaggedComponentsContentProvider taggedComponentsContentProvider = new TaggedComponentsContentProvider(project);
            this.taggedComponentsContentProviders.put(project, taggedComponentsContentProvider);
            Object[] tags = taggedComponentsContentProvider.getChildren();
            if (tags != null && tags.length > 0) {
                Object[] newChildren = new Object[children.length + 1];
                newChildren[children.length] = taggedComponentsContentProvider;
                for (int i = 0; i < children.length; ++i) {
                    Object object;
                    newChildren[i] = object = children[i];
                }
                return newChildren;
            }
        }
        return children;
    }

    public boolean hasChildren(Object element) {
        if (element instanceof ITaggedComponentsContentProvider) {
            ITaggedComponentsContentProvider taggedComponentsContentProvider = (ITaggedComponentsContentProvider)element;
            return taggedComponentsContentProvider.hasChildren();
        }
        return super.hasChildren(element);
    }

    public void dispose() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener(this.resourceChangeListener);
        super.dispose();
    }
}

