/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.wizards;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.HashSet;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Display;
import org.objectstyle.woenvironment.plist.PropertyListParserException;
import org.objectstyle.wolips.eogenerator.core.model.EOGeneratorModel;
import org.objectstyle.wolips.eogenerator.core.model.EOModelReference;
import org.objectstyle.wolips.eogenerator.jdt.EOGeneratorCreator;
import org.objectstyle.wolips.eomodeler.core.model.EODatabaseConfig;
import org.objectstyle.wolips.eomodeler.core.model.EOEntity;
import org.objectstyle.wolips.eomodeler.core.model.EOModel;
import org.objectstyle.wolips.eomodeler.core.model.EOModelException;
import org.objectstyle.wolips.eomodeler.core.model.EOModelGroup;
import org.objectstyle.wolips.eomodeler.core.model.EOModelVerificationFailure;
import org.objectstyle.wolips.eomodeler.core.model.IEOModelGroupFactory;
import org.objectstyle.wolips.eomodeler.editors.EOModelErrorDialog;
import org.objectstyle.wolips.jdt.ProjectFrameworkAdapter;
import org.objectstyle.wolips.jdt.classpath.model.IEclipseFramework;
import org.objectstyle.wolips.wizards.EOGeneratorWizard;
import org.objectstyle.wolips.wizards.EOModelCreationPage;

public class EOModelCreator
implements IRunnableWithProgress {
    private String _modelName;
    private String _adaptorName;
    private String _pluginName;
    private IResource _parentResource;
    private boolean _createEOGeneratorFile;
    private EOModelCreationPage _page;

    public EOModelCreator(IResource parentResource, String modelName, String adaptorName, String pluginName, boolean createEOGeneratorFile, EOModelCreationPage page) {
        this._parentResource = parentResource;
        this._modelName = modelName;
        this._adaptorName = adaptorName;
        this._pluginName = pluginName;
        this._page = page;
        this._createEOGeneratorFile = createEOGeneratorFile;
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException {
        try {
            this.createEOModel(monitor);
        }
        catch (Exception e) {
            throw new InvocationTargetException(e);
        }
    }

    public void createEOModel(IProgressMonitor monitor) throws CoreException, IOException, EOModelException, InvocationTargetException, PropertyListParserException {
        HashSet<EOModelVerificationFailure> failures = new HashSet<EOModelVerificationFailure>();
        IContainer parentContainer = (IContainer)this._parentResource;
        IFolder existingModelFolder = parentContainer.getFolder((IPath)new Path(this._modelName + ".eomodeld"));
        if (existingModelFolder.exists()) {
            failures.add(new EOModelVerificationFailure(null, "There's already a model in " + existingModelFolder.getLocation().toOSString() + ".", true, null));
            EOModelErrorDialog errors = new EOModelErrorDialog(Display.getDefault().getActiveShell(), failures);
            errors.open();
            return;
        }
        boolean createModelGroup = false;
        EOModelGroup modelGroup = new EOModelGroup();
        try {
            IEOModelGroupFactory.Utility.loadModelGroup((Object)this._parentResource, (EOModelGroup)modelGroup, failures, (boolean)true, (URL)existingModelFolder.getLocation().toFile().toURL(), (IProgressMonitor)new NullProgressMonitor());
        }
        catch (Exception e) {
            failures.clear();
            failures.add(new EOModelVerificationFailure(null, "Creating empty EOModelGroup for this model because " + e.getMessage(), true, (Throwable)e));
            modelGroup = new EOModelGroup();
            createModelGroup = true;
            EOModelErrorDialog errors = new EOModelErrorDialog(Display.getDefault().getActiveShell(), failures);
            errors.open();
        }
        EOModel model = new EOModel(this._modelName);
        EODatabaseConfig databaseConfig = new EODatabaseConfig("Default");
        databaseConfig.setAdaptorName(this._adaptorName);
        model.addDatabaseConfig(databaseConfig);
        modelGroup.addModel(model);
        modelGroup.setEditingModelName(this._modelName);
        ProjectFrameworkAdapter frameworkAdapter = (ProjectFrameworkAdapter)this._parentResource.getProject().getAdapter(ProjectFrameworkAdapter.class);
        if (!"None".equals(this._adaptorName) && !"".equals(this._adaptorName)) {
            frameworkAdapter.addFrameworks(new IEclipseFramework[]{(IEclipseFramework)frameworkAdapter.getAdaptorFrameworks().get(this._adaptorName)});
        }
        if (!"None".equals(this._pluginName) && !"".equals(this._pluginName)) {
            EODatabaseConfig activeConfig;
            IEclipseFramework pluginFramework = (IEclipseFramework)frameworkAdapter.getPluginFrameworks().get(this._pluginName);
            frameworkAdapter.addFrameworks(new IEclipseFramework[]{pluginFramework});
            String selectedPrototypeEntityName = "EO" + this._adaptorName + this._pluginName + "Prototypes";
            EOEntity selectedPrototypeEntity = modelGroup.getEntityNamed(selectedPrototypeEntityName);
            if (selectedPrototypeEntity != null && (activeConfig = model.getActiveDatabaseConfig()) != null) {
                activeConfig.setPrototype(selectedPrototypeEntity);
            }
        }
        File modelFolderFile = model.saveToFolder(parentContainer.getLocation().toFile());
        IFolder modelFolder = parentContainer.getFolder((IPath)new Path(modelFolderFile.getName()));
        String baseName = model.getName();
        if (this._createEOGeneratorFile) {
            EOGeneratorModel eogenModel = EOGeneratorWizard.createEOGeneratorModel(parentContainer, model, false);
            IFile eogenFile = parentContainer.getFile((IPath)new Path(baseName + ".eogen"));
            if (eogenFile.exists()) {
                int dupeNum = 1;
                while (!eogenFile.exists()) {
                    eogenFile = parentContainer.getFile((IPath)new Path(baseName + dupeNum + ".eogen"));
                    ++dupeNum;
                }
            }
            eogenModel.writeToFile(eogenFile, monitor);
        }
        parentContainer.refreshLocal(2, monitor);
        if (createModelGroup) {
            EOGeneratorModel modelGroupModel = EOGeneratorCreator.createDefaultModel((IProject)this._parentResource.getProject());
            if (modelFolder != null) {
                Path modelPath = new Path(modelFolderFile.getAbsolutePath());
                EOModelReference modelReference = new EOModelReference((IPath)modelPath);
                modelGroupModel.addModel(modelReference);
            }
            IFile modelGroupFile = parentContainer.getFile((IPath)new Path(baseName + ".eomodelgroup"));
            modelGroupModel.writeToFile(modelGroupFile, monitor);
            this._page.setResourceToReveal((IResource)modelGroupFile);
        } else {
            this._page.setResourceToReveal(modelFolder.findMember("index.eomodeld"));
        }
    }
}

