/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.launching.ui;

import java.util.StringTokenizer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.objectstyle.wolips.launching.LaunchingMessages;
import org.objectstyle.wolips.launching.LaunchingPlugin;
import org.objectstyle.wolips.launching.ui.AbstractWOArgumentsTab;
import org.objectstyle.wolips.preferences.Preferences;
import org.objectstyle.wolips.preferences.PreferencesMessages;

public class LogTab
extends AbstractWOArgumentsTab {
    private Table debugGroupsTable;
    private Button addButton;
    private Button removeButton;
    private Button renameButton;
    protected static final String EMPTY_STRING = "";

    public void createControl(Composite parentComposite) {
        Composite parent = new Composite(parentComposite, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 2;
        parent.setLayout((Layout)layout);
        GridData data = new GridData();
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        parent.setLayoutData((Object)data);
        Label l1 = new Label(parent, 0);
        l1.setText(PreferencesMessages.getString((String)"LaunchPreferencesPage.label"));
        data = new GridData(2);
        data.horizontalSpan = 3;
        l1.setLayoutData((Object)data);
        this.debugGroupsTable = new Table(parent, 2080);
        GridData gd2 = new GridData(768);
        gd2.widthHint = 150;
        gd2.heightHint = 250;
        this.debugGroupsTable.setLayoutData((Object)gd2);
        this.debugGroupsTable.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                LogTab.this.handleSelection();
                LogTab.this.updateLaunchConfigurationDialog();
            }
        });
        Composite buttons = new Composite(parent, 0);
        buttons.setLayoutData((Object)new GridData(2));
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        buttons.setLayout((Layout)layout);
        this.addButton = new Button(buttons, 8);
        this.addButton.setText(PreferencesMessages.getString((String)"LaunchPreferencesPage.add"));
        data = new GridData();
        data.horizontalAlignment = 4;
        data.heightHint = 20;
        data.heightHint = Math.max(data.heightHint, this.addButton.computeSize((int)-1, (int)-1, (boolean)true).y);
        int widthHint = 100;
        data.widthHint = Math.max(widthHint, this.addButton.computeSize((int)-1, (int)-1, (boolean)true).x);
        this.addButton.setLayoutData((Object)data);
        this.addButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                LogTab.this.addLaunchGroup();
            }
        });
        this.removeButton = new Button(buttons, 8);
        this.removeButton.setText(PreferencesMessages.getString((String)"LaunchPreferencesPage.remove"));
        data = new GridData();
        data.horizontalAlignment = 4;
        data.heightHint = 20;
        data.heightHint = Math.max(data.heightHint, this.removeButton.computeSize((int)-1, (int)-1, (boolean)true).y);
        widthHint = 100;
        data.widthHint = Math.max(widthHint, this.removeButton.computeSize((int)-1, (int)-1, (boolean)true).x);
        this.removeButton.setLayoutData((Object)data);
        this.removeButton.setEnabled(false);
        this.removeButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                LogTab.this.removeLaunchGroup();
            }
        });
        this.renameButton = new Button(buttons, 8);
        this.renameButton.setText(PreferencesMessages.getString((String)"LaunchPreferencesPage.change"));
        data = new GridData();
        data.horizontalAlignment = 4;
        data.heightHint = 20;
        data.heightHint = Math.max(data.heightHint, this.renameButton.computeSize((int)-1, (int)-1, (boolean)true).y);
        widthHint = 100;
        data.widthHint = Math.max(widthHint, this.renameButton.computeSize((int)-1, (int)-1, (boolean)true).x);
        this.renameButton.setLayoutData((Object)data);
        this.renameButton.setEnabled(false);
        this.renameButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                LogTab.this.renameLaunchGroup();
            }
        });
        Dialog.applyDialogFont((Control)parent);
        this.setControl((Control)parent);
    }

    protected void removeLaunchGroup() {
        int[] selection = this.debugGroupsTable.getSelectionIndices();
        this.debugGroupsTable.remove(selection);
        if (selection == null) {
            return;
        }
        this.setDirty(true);
        this.updateLaunchConfigurationDialog();
    }

    protected void renameLaunchGroup() {
        int[] selection = this.debugGroupsTable.getSelectionIndices();
        if (selection.length != 1) {
            return;
        }
        int index = selection[0];
        TableItem item = this.debugGroupsTable.getItem(index);
        String oldValue = item.getText();
        InputDialog launchGroupDialog = new InputDialog(this.getShell(), oldValue + " " + PreferencesMessages.getString((String)"LaunchPreferencesPage.enterArgumentShort"), Preferences.getString((String)"IgnorePreferencePage.enterPatternLong"), oldValue, null);
        launchGroupDialog.open();
        if (launchGroupDialog.getReturnCode() != 0) {
            return;
        }
        String newValue = launchGroupDialog.getValue();
        if (this.itemExist(newValue)) {
            return;
        }
        item.setText(newValue);
        this.setDirty(true);
        this.updateLaunchConfigurationDialog();
    }

    protected void addLaunchGroup() {
        InputDialog parameterDialog = new InputDialog(this.getShell(), PreferencesMessages.getString((String)"LaunchPreferencesPage.enterParameterShort"), Preferences.getString((String)"IgnorePreferencePage.enterPatternLong"), null, null);
        parameterDialog.open();
        if (parameterDialog.getReturnCode() != 0) {
            return;
        }
        String parameter = parameterDialog.getValue();
        if (parameter.equals(EMPTY_STRING)) {
            return;
        }
        if (this.itemExist(parameter)) {
            return;
        }
        TableItem item = new TableItem(this.debugGroupsTable, 0);
        item.setText(parameter);
        item.setChecked(true);
        this.setDirty(true);
        this.updateLaunchConfigurationDialog();
    }

    private boolean itemExist(String item) {
        TableItem[] items = this.debugGroupsTable.getItems();
        for (int i = 0; i < items.length; ++i) {
            if (!items[i].getText().equals(item)) continue;
            MessageDialog.openWarning((Shell)this.getShell(), (String)PreferencesMessages.getString((String)"LaunchPreferencesPage.parameterExistsShort"), (String)Preferences.getString((String)"IgnorePreferencePage.patternExistsLong"));
            return true;
        }
        return false;
    }

    private void fillDebugGroupsTable(String aString) {
        String debugGroups = LaunchingMessages.getString("WOJavaLocalApplicationLaunchConfigurationDelegate.NSDebugGroups");
        StringTokenizer stringTokenizer = new StringTokenizer(debugGroups, ",");
        this.debugGroupsTable.removeAll();
        while (stringTokenizer.hasMoreTokens()) {
            TableItem item = new TableItem(this.debugGroupsTable, 0);
            String token = stringTokenizer.nextToken();
            item.setText(token);
            item.setChecked(aString != null && aString.indexOf(token) >= 0);
        }
    }

    @Override
    public void dispose() {
        super.dispose();
    }

    @Override
    public boolean isValid(ILaunchConfiguration config) {
        return true;
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy config) {
        config.setAttribute("WOJavaLocalApplicationLaunchConfigurationDelegate.NSDebugGroups", EMPTY_STRING);
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            this.fillDebugGroupsTable(configuration.getAttribute("WOJavaLocalApplicationLaunchConfigurationDelegate.NSDebugGroups", EMPTY_STRING));
        }
        catch (CoreException e) {
            this.setErrorMessage(LaunchingMessages.getString("WOArgumentsTab.Exception_occurred_reading_configuration___15") + e.getStatus().getMessage());
            LaunchingPlugin.getDefault().log(e);
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        Object aString = EMPTY_STRING;
        TableItem[] debugGrouspItems = this.debugGroupsTable.getItems();
        for (int i = 0; i < debugGrouspItems.length; ++i) {
            if (!debugGrouspItems[i].getChecked()) continue;
            if (((String)aString).length() > 0) {
                aString = (String)aString + ",";
            }
            aString = (String)aString + debugGrouspItems[i].getText();
        }
        configuration.setAttribute("WOJavaLocalApplicationLaunchConfigurationDelegate.NSDebugGroups", (String)aString);
    }

    public String getName() {
        return LaunchingMessages.getString("LoggingTab.Name");
    }

    @Override
    public Image getImage() {
        return LaunchingPlugin.getImageDescriptor("icons/launching/logging-tab.gif").createImage();
    }

    @Override
    protected void updateLaunchConfigurationDialog() {
        super.updateLaunchConfigurationDialog();
        this.getControl().update();
    }

    protected void handleSelection() {
        if (this.debugGroupsTable.getSelectionCount() > 0) {
            this.removeButton.setEnabled(true);
            this.renameButton.setEnabled(true);
        } else {
            this.removeButton.setEnabled(false);
            this.renameButton.setEnabled(false);
        }
    }
}

