/*
 * Decompiled with CFR 0.152.
 */
package jp.aonir.fuzzyxml.internal;

import jp.aonir.fuzzyxml.FuzzyXMLAttribute;
import jp.aonir.fuzzyxml.FuzzyXMLElement;
import jp.aonir.fuzzyxml.FuzzyXMLNode;
import jp.aonir.fuzzyxml.internal.AbstractFuzzyXMLNode;
import jp.aonir.fuzzyxml.internal.FuzzyXMLDocumentImpl;
import jp.aonir.fuzzyxml.internal.FuzzyXMLUtil;
import jp.aonir.fuzzyxml.internal.RenderContext;
import org.objectstyle.wolips.wodclipse.core.util.WodHtmlUtils;

public class FuzzyXMLAttributeImpl
extends AbstractFuzzyXMLNode
implements FuzzyXMLAttribute {
    private char _quote = (char)34;
    private boolean _escape = true;
    private String _namespace;
    private String _name;
    private String _value;
    private String _rawValue;
    private int _valueOffset;
    private boolean _hasNestedTag;

    public FuzzyXMLAttributeImpl(String namespace, String name) {
        this(null, namespace, name, null, null, -1, -1, -1);
    }

    public FuzzyXMLAttributeImpl(String namespace, String name, String value, String rawValue) {
        this(null, namespace, name, value, rawValue, -1, -1, -1);
        this.setValue(value);
        this._rawValue = rawValue;
    }

    public FuzzyXMLAttributeImpl(FuzzyXMLNode parent, String namespace, String name, String value, String rawValue, int offset, int length, int valueOffset) {
        super(parent, offset, length);
        this._namespace = namespace;
        this._name = name;
        this._value = value;
        this._rawValue = rawValue;
        this._valueOffset = valueOffset;
    }

    @Override
    public void setHasNestedTag(boolean hasNestedTag) {
        this._hasNestedTag = hasNestedTag;
    }

    @Override
    public boolean hasNestedTag() {
        return this._hasNestedTag;
    }

    @Override
    public String getRawValue() {
        return this._rawValue;
    }

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public String getNamespace() {
        return this._namespace;
    }

    @Override
    public int getNamespaceOffset() {
        return this.getOffset() + 1;
    }

    @Override
    public int getNamespaceLength() {
        return this._namespace != null ? this._namespace.length() : 0;
    }

    @Override
    public int getNameOffset() {
        int nameOffset = this._namespace == null ? this.getOffset() + 1 : this.getNamespaceOffset() + this.getNamespaceLength() + 1;
        return nameOffset;
    }

    @Override
    public int getNameLength() {
        return this._name != null ? this._name.length() : 0;
    }

    @Override
    public int getValueOffset() {
        return this._valueOffset;
    }

    @Override
    public int getValueLength() {
        return this._value != null ? this._value.length() : 0;
    }

    @Override
    public int getValueDataOffset() {
        int offset = 0;
        if (this._value != null) {
            offset = this.getValueOffset();
            if (this.isQuoted()) {
                ++offset;
            }
        }
        return offset;
    }

    @Override
    public int getValueDataLength() {
        int length = 0;
        if (this._value != null) {
            length = this.getValueLength();
        }
        return length;
    }

    @Override
    public void setValue(String value) {
        if (this._value == null) {
            this._value = "";
        }
        int length = this._value.length();
        this._rawValue = this._value = value == null ? "" : value;
        FuzzyXMLDocumentImpl document = this.getDocument();
        boolean html = document == null ? true : document.isHTML();
        this.fireModifyEvent(this.toXMLString(new RenderContext(html)), this.getOffset(), this.getLength());
        this.appendOffset((FuzzyXMLElement)this.getParentNode(), this.getOffset(), this._value.length() - length);
    }

    @Override
    public String getValue() {
        return this._value;
    }

    @Override
    public boolean isQuoted() {
        return this._quote != '\u0000';
    }

    @Override
    public char getQuoteCharacter() {
        return this._quote;
    }

    @Override
    public void setQuoteCharacter(char c) {
        this._quote = c;
    }

    @Override
    public void setEscape(boolean escape) {
        this._escape = escape;
    }

    @Override
    public boolean isEscape() {
        return this._escape;
    }

    @Override
    public String getNamespaceName() {
        Object attributeName = this.getName();
        String namespace = this.getNamespace();
        if (namespace != null && namespace.length() > 0) {
            attributeName = namespace + ":" + (String)attributeName;
        }
        return attributeName;
    }

    @Override
    public String toDebugString() {
        StringBuffer sb = new StringBuffer();
        this.toDebugString(sb, 0);
        return sb.toString();
    }

    @Override
    public void toDebugString(StringBuffer buffer, int indent) {
        for (int i = 0; i < indent; ++i) {
            buffer.append("  ");
        }
        buffer.append(this.getName() + "=" + this.getValue());
    }

    @Override
    public void toXMLString(RenderContext renderContext, StringBuffer xmlBuffer) {
        boolean isHTML = renderContext.isHtml();
        xmlBuffer.append(" ");
        Object attributeName = FuzzyXMLUtil.escape(this.getName(), isHTML);
        String namespace = this.getNamespace();
        if (namespace != null && namespace.length() > 0) {
            attributeName = namespace + ":" + (String)attributeName;
        }
        if (renderContext.isLowercaseAttributes()) {
            boolean inlineTag;
            FuzzyXMLNode parentNode = this.getParentNode();
            boolean bl = inlineTag = parentNode instanceof FuzzyXMLElement && WodHtmlUtils.isInline((String)((FuzzyXMLElement)parentNode).getName());
            if (!inlineTag && FuzzyXMLUtil.isAllUppercase((String)attributeName)) {
                attributeName = ((String)attributeName).toLowerCase();
            }
        }
        xmlBuffer.append((String)attributeName);
        if (renderContext.isSpacesAroundEquals()) {
            xmlBuffer.append(" ");
        }
        xmlBuffer.append("=");
        if (renderContext.isSpacesAroundEquals()) {
            xmlBuffer.append(" ");
        }
        char quote = this._quote;
        if (renderContext.isAddMissingQuotes()) {
            quote = '\"';
        }
        if (quote != '\u0000') {
            xmlBuffer.append(quote);
        }
        boolean hasNestedTag = this.hasNestedTag();
        if (this._escape && hasNestedTag) {
            xmlBuffer.append(FuzzyXMLUtil.escape(this._value, false));
        } else {
            boolean inNestedTag = false;
            String value = this.getValue();
            for (int i = 0; i < value.length(); ++i) {
                char c = value.charAt(i);
                if (hasNestedTag && c == '<') {
                    inNestedTag = true;
                } else if (c == '>') {
                    inNestedTag = false;
                } else if (!inNestedTag && this._quote == c) {
                    xmlBuffer.append('\\');
                }
                xmlBuffer.append(c);
            }
        }
        if (quote != '\u0000') {
            xmlBuffer.append(quote);
        }
    }

    public String toString() {
        return "attr: " + this.getName() + "=" + this.getValue();
    }
}

