/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.templateeditor;

import java.util.LinkedList;
import jp.aonir.fuzzyxml.FuzzyXMLDocument;
import jp.aonir.fuzzyxml.FuzzyXMLElement;
import jp.aonir.fuzzyxml.FuzzyXMLNode;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.editors.text.TextEditor;
import org.objectstyle.wolips.bindings.wod.IWodElement;
import org.objectstyle.wolips.templateeditor.TemplateSourceEditor;
import org.objectstyle.wolips.variables.BuildProperties;
import org.objectstyle.wolips.wodclipse.core.completion.WodParserCache;
import org.objectstyle.wolips.wodclipse.core.document.WodElementTypeHyperlink;
import org.objectstyle.wolips.wodclipse.core.util.ICursorPositionListener;
import org.objectstyle.wolips.wodclipse.core.util.WodHtmlUtils;

public class TemplateBreadcrumb
extends Composite
implements ICursorPositionListener,
MouseListener {
    private TemplateSourceEditor _editor;

    public TemplateBreadcrumb(TemplateSourceEditor editor, Composite parent, int style) {
        super(parent, style);
        this.setBackground(parent.getBackground());
        RowLayout breadcrumbLayout = new RowLayout();
        breadcrumbLayout.wrap = false;
        breadcrumbLayout.pack = true;
        breadcrumbLayout.justify = false;
        breadcrumbLayout.type = 256;
        breadcrumbLayout.marginLeft = 5;
        breadcrumbLayout.marginTop = 3;
        breadcrumbLayout.marginRight = 5;
        breadcrumbLayout.marginBottom = 3;
        breadcrumbLayout.spacing = 5;
        this.setLayout((Layout)breadcrumbLayout);
        this._editor = editor;
        this._editor.addCursorPositionListener(this);
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                GC gc = e.gc;
                Color separatorColor = new Color(gc.getDevice(), 205, 205, 205);
                gc.setForeground(separatorColor);
                gc.drawLine(0, 0, TemplateBreadcrumb.this.getBounds().width, 0);
                separatorColor.dispose();
            }
        });
        this.updateBreadcrumb();
    }

    public void cursorPositionChanged(TextEditor editor, Point selectionRange) {
        this.updateBreadcrumb();
    }

    public void updateBreadcrumb() {
        try {
            WodParserCache cache = this._editor.getParserCache();
            Point selectionRange = this._editor.getSelectedRange();
            FuzzyXMLElement element = null;
            FuzzyXMLDocument document = (FuzzyXMLDocument)cache.getHtmlEntry().getModel();
            if (document != null) {
                element = document.getElementByOffset(selectionRange.x);
            }
            Control[] children = this.getChildren();
            for (int i = children.length - 1; i >= 0; --i) {
                children[i].dispose();
            }
            boolean emptyBreadcrumb = true;
            if (element != null) {
                LinkedList<FuzzyXMLElement> elementStack = new LinkedList<FuzzyXMLElement>();
                FuzzyXMLNode currentNode = element;
                do {
                    elementStack.add((FuzzyXMLElement)currentNode);
                } while ((currentNode = currentNode.getParentNode()) != null);
                for (int i = elementStack.size() - 2; i >= 0; --i) {
                    FuzzyXMLNode stackNode = (FuzzyXMLNode)elementStack.get(i);
                    if (stackNode instanceof FuzzyXMLElement) {
                        FuzzyXMLElementWithWodElement data;
                        emptyBreadcrumb = false;
                        FuzzyXMLElement stackElement = (FuzzyXMLElement)stackNode;
                        String tagName = stackElement.getName();
                        boolean isWOTag = WodHtmlUtils.isWOTag((String)tagName);
                        String displayName = null;
                        if (isWOTag) {
                            BuildProperties buildProperties = (BuildProperties)cache.getProject().getAdapter(BuildProperties.class);
                            IWodElement wodElement = WodHtmlUtils.getWodElement((FuzzyXMLElement)stackElement, (BuildProperties)buildProperties, (boolean)true, (WodParserCache)cache);
                            if (wodElement != null) {
                                displayName = wodElement.getElementType();
                            }
                            data = new FuzzyXMLElementWithWodElement(stackElement, wodElement);
                        } else {
                            displayName = tagName;
                            data = new FuzzyXMLElementWithWodElement(stackElement, null);
                        }
                        if (displayName == null) {
                            displayName = "<unknown>";
                        }
                        Label nodeButton = new Label((Composite)this, 0);
                        nodeButton.setData((Object)data);
                        nodeButton.setBackground(this.getBackground());
                        nodeButton.setText(displayName);
                        nodeButton.addMouseListener((MouseListener)this);
                        nodeButton.setCursor(this.getDisplay().getSystemCursor(21));
                        if (!isWOTag) {
                            nodeButton.setForeground(this.getDisplay().getSystemColor(16));
                        }
                    }
                    if (i <= 0) continue;
                    Label arrowLabel = new Label((Composite)this, 0);
                    arrowLabel.setBackground(this.getBackground());
                    arrowLabel.setForeground(this.getDisplay().getSystemColor(15));
                    arrowLabel.setText(">");
                }
                if (emptyBreadcrumb) {
                    Label emptyLabel = new Label((Composite)this, 0);
                    emptyLabel.setBackground(this.getBackground());
                    emptyLabel.setForeground(this.getDisplay().getSystemColor(15));
                    emptyLabel.setText("...");
                }
                this.layout();
                this.getParent().layout();
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public void mouseDoubleClick(MouseEvent event) {
        Label label = (Label)event.getSource();
        FuzzyXMLElementWithWodElement data = (FuzzyXMLElementWithWodElement)label.getData();
        if (data != null && data.getWodElement() != null) {
            try {
                WodElementTypeHyperlink.toElementTypeHyperlink((IWodElement)data.getWodElement(), (WodParserCache)this._editor.getParserCache()).open();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void mouseDown(MouseEvent event) {
        Label label = (Label)event.getSource();
        FuzzyXMLElementWithWodElement data = (FuzzyXMLElementWithWodElement)label.getData();
        if (data != null && data.getElement() != null) {
            FuzzyXMLElement element = data.getElement();
            int offset = element.getOffset();
            int length = element.getLength();
            this._editor.selectAndReveal(offset, length);
        }
    }

    public void mouseUp(MouseEvent event) {
    }

    public static class FuzzyXMLElementWithWodElement {
        private FuzzyXMLElement _element;
        private IWodElement _wodElement;

        public FuzzyXMLElementWithWodElement(FuzzyXMLElement element, IWodElement wodElement) {
            this._element = element;
            this._wodElement = wodElement;
        }

        public FuzzyXMLElement getElement() {
            return this._element;
        }

        public IWodElement getWodElement() {
            return this._wodElement;
        }
    }
}

