/*
 * Decompiled with CFR 0.152.
 */
package tk.eclipse.plugin.htmleditor;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.Properties;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.QualifiedName;
import tk.eclipse.plugin.htmleditor.HTMLPlugin;

public class HTMLProjectParams {
    private String _root = "/";
    private boolean _useDTD = true;
    private boolean _validateXML = true;
    private boolean _validateHTML = true;
    private boolean _validateJSP = true;
    private boolean _validateDTD = true;
    private boolean _validateJS = true;
    private boolean _removeMarkers = false;
    private boolean _detectTaskTag = false;
    private String[] _javaScripts = new String[0];
    public static final String P_ROOT = "root";
    public static final String P_USE_DTD = "useDTD";
    public static final String P_VALIDATE_XML = "validateXML";
    public static final String P_VALIDATE_HTML = "validateHTML";
    public static final String P_VALIDATE_JSP = "validateJSP";
    public static final String P_VALIDATE_DTD = "validateDTD";
    public static final String P_VALIDATE_JS = "validateJS";
    public static final String P_REMOVE_MARKERS = "removeMarkers";
    public static final String P_JAVA_SCRIPTS = "javaScripts";

    public HTMLProjectParams() {
    }

    public HTMLProjectParams(IProject project) throws Exception {
        this.load(project);
    }

    public String getRoot() {
        return this._root;
    }

    public void setRoot(String webAppRoot) {
        this._root = webAppRoot;
    }

    public void setUseDTD(boolean useDTD) {
        this._useDTD = useDTD;
    }

    public boolean getUseDTD() {
        return this._useDTD;
    }

    public void setValidateHTML(boolean validateHTML) {
        this._validateHTML = validateHTML;
    }

    public boolean getValidateHTML() {
        return this._validateHTML;
    }

    public void setValidateJSP(boolean validateJSP) {
        this._validateJSP = validateJSP;
    }

    public boolean getValidateJSP() {
        return this._validateJSP;
    }

    public void setValidateDTD(boolean validateDTD) {
        this._validateDTD = validateDTD;
    }

    public boolean getValidateDTD() {
        return this._validateDTD;
    }

    public void setValidateJavaScript(boolean validateJS) {
        this._validateJS = validateJS;
    }

    public boolean getValidateJavaScript() {
        return this._validateJS;
    }

    public void setValidateXML(boolean validateXML) {
        this._validateXML = validateXML;
    }

    public boolean getValidateXML() {
        return this._validateXML;
    }

    public void setRemoveMarkers(boolean removeMarkers) {
        this._removeMarkers = removeMarkers;
    }

    public boolean getRemoveMarkers() {
        return this._removeMarkers;
    }

    public void setDetectTaskTag(boolean detectTaskTag) {
        this._detectTaskTag = detectTaskTag;
    }

    public boolean getDetectTaskTag() {
        return this._detectTaskTag;
    }

    public void setJavaScripts(String[] javaScripts) {
        this._javaScripts = javaScripts;
    }

    public String[] getJavaScripts() {
        return this._javaScripts;
    }

    public void save(IProject project) throws Exception {
        IFile configFile = project.getFile(".amateras");
        Properties props = new Properties();
        props.put(P_ROOT, this._root);
        props.put(P_USE_DTD, String.valueOf(this._useDTD));
        props.put(P_VALIDATE_XML, String.valueOf(this._validateXML));
        props.put(P_VALIDATE_HTML, String.valueOf(this._validateHTML));
        props.put(P_VALIDATE_JSP, String.valueOf(this._validateJSP));
        props.put(P_VALIDATE_DTD, String.valueOf(this._validateDTD));
        props.put(P_VALIDATE_JS, String.valueOf(this._validateJS));
        props.put(P_REMOVE_MARKERS, String.valueOf(this._removeMarkers));
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this._javaScripts.length; ++i) {
            if (i != 0) {
                sb.append("\n");
            }
            sb.append(this._javaScripts[i]);
        }
        props.put(P_JAVA_SCRIPTS, sb.toString());
        File file = configFile.getLocation().makeAbsolute().toFile();
        if (!file.exists()) {
            file.createNewFile();
        }
        props.store(new FileOutputStream(file), "EclipseHTMLEditor configuration file");
        if (this._detectTaskTag) {
            this.addNature(project);
        } else {
            this.removeNature(project);
        }
        project.refreshLocal(1, (IProgressMonitor)new NullProgressMonitor());
    }

    private void addNature(IProject project) throws CoreException {
        IProjectDescription description = project.getDescription();
        String[] natures = description.getNatureIds();
        for (int i = 0; i < natures.length; ++i) {
            if (!natures[i].equals("tk.eclipse.plugin.htmleditor.HTMLProjectNature")) continue;
            return;
        }
        String[] newNatures = new String[natures.length + 1];
        System.arraycopy(natures, 0, newNatures, 0, natures.length);
        newNatures[natures.length] = "tk.eclipse.plugin.htmleditor.HTMLProjectNature";
        description.setNatureIds(newNatures);
        project.setDescription(description, null);
    }

    private void removeNature(IProject project) throws CoreException {
        IProjectDescription description = project.getDescription();
        String[] natures = description.getNatureIds();
        ArrayList<String> newNatures = new ArrayList<String>();
        for (int i = 0; i < natures.length; ++i) {
            if (natures[i].equals("tk.eclipse.plugin.htmleditor.HTMLProjectNature")) continue;
            newNatures.add(natures[i]);
        }
        description.setNatureIds(newNatures.toArray(new String[newNatures.size()]));
        project.setDescription(description, null);
    }

    public void load(IProject project) throws Exception {
        IFile configFile = project.getFile(".amateras");
        String useDTD = null;
        String validateXML = null;
        String validateHTML = null;
        String validateJSP = null;
        String validateDTD = null;
        String validateJS = null;
        String removeMarkers = null;
        String javaScripts = "";
        if (configFile.exists()) {
            File file = configFile.getLocation().makeAbsolute().toFile();
            Properties props = new Properties();
            props.load(new FileInputStream(file));
            this._root = props.getProperty(P_ROOT);
            useDTD = props.getProperty(P_USE_DTD);
            validateXML = props.getProperty(P_VALIDATE_XML);
            validateHTML = props.getProperty(P_VALIDATE_HTML);
            validateJSP = props.getProperty(P_VALIDATE_JSP);
            validateDTD = props.getProperty(P_VALIDATE_DTD);
            validateJS = props.getProperty(P_VALIDATE_JS);
            removeMarkers = props.getProperty(P_REMOVE_MARKERS);
            javaScripts = props.getProperty(P_JAVA_SCRIPTS);
            if (javaScripts == null) {
                javaScripts = "";
            }
        } else if (project.isOpen()) {
            this._root = project.getPersistentProperty(new QualifiedName(HTMLPlugin.getDefault().getPluginId(), P_ROOT));
            useDTD = project.getPersistentProperty(new QualifiedName(HTMLPlugin.getDefault().getPluginId(), P_USE_DTD));
            validateHTML = project.getPersistentProperty(new QualifiedName(HTMLPlugin.getDefault().getPluginId(), P_VALIDATE_HTML));
        }
        if (this._root == null) {
            this._root = "/";
        }
        this._useDTD = this.getBooleanValue(useDTD, true);
        this._validateXML = this.getBooleanValue(validateXML, true);
        this._validateHTML = this.getBooleanValue(validateHTML, true);
        this._validateJSP = this.getBooleanValue(validateJSP, true);
        this._validateDTD = this.getBooleanValue(validateDTD, true);
        this._validateJS = this.getBooleanValue(validateJS, true);
        this._removeMarkers = this.getBooleanValue(removeMarkers, false);
        this._detectTaskTag = project.hasNature("tk.eclipse.plugin.htmleditor.HTMLProjectNature");
        String[] dim = javaScripts.split("\n");
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < dim.length; ++i) {
            if (dim[i].trim().length() == 0) continue;
            list.add(dim[i]);
        }
        this._javaScripts = list.toArray(new String[list.size()]);
    }

    private boolean getBooleanValue(String value, boolean defaultValue) {
        if (value != null) {
            if (value.equals("true")) {
                return true;
            }
            if (value.equals("false")) {
                return false;
            }
        }
        return defaultValue;
    }
}

