/*
 * Decompiled with CFR 0.152.
 */
package tk.eclipse.plugin.htmleditor.assist;

import java.util.ArrayList;
import java.util.List;
import tk.eclipse.plugin.htmleditor.assist.AttributeInfo;

public class TagInfo {
    private String tagName;
    private boolean hasBody;
    private boolean emptyTag;
    private String description;
    private List<AttributeInfo> attributes = new ArrayList<AttributeInfo>();
    private List<String> children = new ArrayList<String>();
    private boolean _requiresAttributes;
    public static final int NONE = 0;
    public static final int EVENT = 1;
    public static final int FORM = 2;

    public TagInfo(String tagName, boolean hasBody) {
        this(tagName, hasBody, false);
    }

    public TagInfo(String tagName, boolean hasBody, boolean emptyTag) {
        this.tagName = tagName;
        this.hasBody = hasBody;
        this.emptyTag = emptyTag;
    }

    public String getTagName() {
        return this.tagName;
    }

    public boolean hasBody() {
        return this.hasBody;
    }

    public boolean isEmptyTag() {
        return this.emptyTag;
    }

    public void setRequiresAttributes(boolean requiresAttributes) {
        this._requiresAttributes = requiresAttributes;
    }

    public boolean requiresAttributes() {
        boolean requiresAttributes = this._requiresAttributes;
        if (!requiresAttributes) {
            ArrayList list = new ArrayList();
            for (int i = 0; !requiresAttributes && i < this.attributes.size(); ++i) {
                AttributeInfo info = this.attributes.get(i);
                if (!info.isRequired()) continue;
                requiresAttributes = true;
            }
        }
        return requiresAttributes;
    }

    public void addAttributeInfo(AttributeInfo attribute) {
        AttributeInfo info;
        int i;
        for (i = 0; i < this.attributes.size() && (info = this.attributes.get(i)).getAttributeName().compareTo(attribute.getAttributeName()) <= 0; ++i) {
        }
        this.attributes.add(i, attribute);
    }

    public AttributeInfo[] getAttributeInfo() {
        return this.attributes.toArray(new AttributeInfo[this.attributes.size()]);
    }

    public AttributeInfo[] getRequiredAttributeInfo() {
        ArrayList<AttributeInfo> list = new ArrayList<AttributeInfo>();
        for (int i = 0; i < this.attributes.size(); ++i) {
            AttributeInfo info = this.attributes.get(i);
            if (!info.isRequired()) continue;
            list.add(info);
        }
        return list.toArray(new AttributeInfo[list.size()]);
    }

    public AttributeInfo getAttributeInfo(String name) {
        for (int i = 0; i < this.attributes.size(); ++i) {
            AttributeInfo info = this.attributes.get(i);
            if (!info.getAttributeName().equals(name)) continue;
            return info;
        }
        return null;
    }

    public void addChildTagName(String name) {
        this.children.add(name);
    }

    public String[] getChildTagNames() {
        return this.children.toArray(new String[this.children.size()]);
    }

    public boolean equals(Object obj) {
        TagInfo tagInfo;
        return obj instanceof TagInfo && (tagInfo = (TagInfo)obj).getTagName().equals(this.getTagName());
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }
}

