/*
 * Decompiled with CFR 0.152.
 */
package tk.eclipse.plugin.htmleditor.editors;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.EditorPart;
import tk.eclipse.plugin.htmleditor.HTMLPlugin;
import tk.eclipse.plugin.htmleditor.editors.HTMLConfiguration;
import tk.eclipse.plugin.htmleditor.editors.HTMLEditorPart;
import tk.eclipse.plugin.htmleditor.editors.HTMLSourceEditor;
import tk.eclipse.plugin.htmleditor.editors.MultiPageHTMLEditor;
import tk.eclipse.plugin.htmleditor.editors.SplitPageHTMLEditor;
import tk.eclipse.plugin.htmleditor.views.IPaletteTarget;

public class HTMLEditor
extends EditorPart
implements IPaletteTarget {
    protected EditorPart _editor;
    protected File _prevTempFile = null;

    public HTMLEditor() {
        IPreferenceStore store = HTMLPlugin.getDefault().getPreferenceStore();
        String type = store.getString("_pref_editor_type");
        if (type.equals("horizontal")) {
            this._editor = new SplitPageHTMLEditor(this, true, this.createHTMLSourceEditor(this.getSourceViewerConfiguration()));
        } else if (type.equals("vertical")) {
            this._editor = new SplitPageHTMLEditor(this, false, this.createHTMLSourceEditor(this.getSourceViewerConfiguration()));
        } else if (type.equals("tab")) {
            this._editor = new MultiPageHTMLEditor(this, this.createHTMLSourceEditor(this.getSourceViewerConfiguration()));
        } else {
            this._editor = this.createHTMLSourceEditor(this.getSourceViewerConfiguration());
            this._editor.addPropertyListener(new IPropertyListener(){

                public void propertyChanged(Object source, int propertyId) {
                    HTMLEditor.this.firePropertyChange(propertyId);
                }
            });
        }
    }

    protected HTMLConfiguration getSourceViewerConfiguration() {
        return new HTMLConfiguration(HTMLPlugin.getDefault().getColorProvider());
    }

    protected HTMLSourceEditor createHTMLSourceEditor(HTMLConfiguration config) {
        return new HTMLSourceEditor(config);
    }

    @Override
    public HTMLSourceEditor getPaletteTarget() {
        if (this._editor instanceof HTMLSourceEditor) {
            return (HTMLSourceEditor)this._editor;
        }
        return ((HTMLEditorPart)this._editor).getSourceEditor();
    }

    public void updatePreview() {
        if (!(this._editor instanceof HTMLEditorPart)) {
            return;
        }
        try {
            if (!((HTMLEditorPart)this._editor).isFileEditorInput()) {
                return;
            }
            HTMLEditorPart editor = (HTMLEditorPart)this._editor;
            IFileEditorInput input = (IFileEditorInput)this._editor.getEditorInput();
            String charset = input.getFile().getCharset();
            String html = editor.getSourceEditor().getDocumentProvider().getDocument((Object)input).get();
            File tmpFile = editor.getSourceEditor().getTempFile();
            FileOutputStream out = new FileOutputStream(tmpFile);
            PrintWriter pw = new PrintWriter((Writer)new OutputStreamWriter((OutputStream)out, charset), true);
            pw.write(html);
            pw.close();
            if (this._prevTempFile != null && this._prevTempFile.equals(tmpFile)) {
                editor.getBrowser().refresh();
            } else {
                if (this._prevTempFile != null) {
                    this._prevTempFile.delete();
                }
                this._prevTempFile = tmpFile;
                editor.getBrowser().setUrl("file://" + tmpFile.getAbsolutePath());
            }
        }
        catch (Exception ex) {
            HTMLPlugin.logException(ex);
        }
    }

    public void createPartControl(Composite parent) {
        this._editor.createPartControl(parent);
    }

    public void dispose() {
        this._editor.dispose();
        super.dispose();
    }

    public void doSave(IProgressMonitor monitor) {
        this._editor.doSave(monitor);
    }

    public void doSaveAs() {
        this._editor.doSaveAs();
    }

    public Object getAdapter(Class adapter) {
        return this._editor.getAdapter(adapter);
    }

    public String getContentDescription() {
        return this._editor.getContentDescription();
    }

    public IEditorInput getEditorInput() {
        return this._editor.getEditorInput();
    }

    public IEditorSite getEditorSite() {
        return this._editor.getEditorSite();
    }

    public String getPartName() {
        return this._editor.getPartName();
    }

    public IWorkbenchPartSite getSite() {
        return this._editor.getSite();
    }

    public String getTitle() {
        return this._editor.getTitle();
    }

    public Image getTitleImage() {
        return this._editor.getTitleImage();
    }

    public String getTitleToolTip() {
        return this._editor.getTitleToolTip();
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this._editor.init(site, input);
    }

    public boolean isDirty() {
        return this._editor.isDirty();
    }

    public boolean isSaveAsAllowed() {
        return this._editor.isSaveAsAllowed();
    }

    public boolean isSaveOnCloseNeeded() {
        return this._editor.isSaveOnCloseNeeded();
    }

    public void setFocus() {
        this._editor.setFocus();
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) {
        this._editor.setInitializationData(config, propertyName, data);
    }

    public void showBusy(boolean busy) {
        this._editor.showBusy(busy);
    }

    public void setOffset(int offset) {
        if (this._editor instanceof SplitPageHTMLEditor) {
            ((SplitPageHTMLEditor)this._editor).setOffset(offset);
        } else if (this._editor instanceof MultiPageHTMLEditor) {
            ((MultiPageHTMLEditor)this._editor).setOffset(offset);
        } else if (this._editor instanceof HTMLSourceEditor) {
            ((HTMLSourceEditor)this._editor).selectAndReveal(offset, 0);
        }
    }

    public void firePropertyChange2(int propertyId) {
        super.firePropertyChange(propertyId);
    }
}

