/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.wodclipse.core.parser;

import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IPredicateRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.Token;

public class SingleWordRule
implements IPredicateRule {
    private IToken _token;
    private char[] _acceptableCharacters;
    private char _unacceptablePrefixCharacter;
    private char _stopCharacter;
    private char _stopCharacter2;

    public SingleWordRule(IToken token, char[] acceptableCharacters, char stopCharacter) {
        this(token, '\u0000', acceptableCharacters, stopCharacter);
    }

    public SingleWordRule(IToken token, char unacceptablePrefixCharacter, char[] acceptableCharacters, char stopCharacter) {
        this(token, unacceptablePrefixCharacter, acceptableCharacters, stopCharacter, '\u0000');
    }

    public SingleWordRule(IToken token, char unacceptablePrefixCharacter, char[] acceptableCharacters, char stopCharacter, char stopCharacter2) {
        this._token = token;
        this._unacceptablePrefixCharacter = unacceptablePrefixCharacter;
        this._acceptableCharacters = acceptableCharacters;
        this._stopCharacter = stopCharacter;
        this._stopCharacter2 = stopCharacter2;
    }

    public IToken getSuccessToken() {
        return this._token;
    }

    public IToken evaluate(ICharacterScanner scanner) {
        return this.evaluate(scanner, false);
    }

    public IToken evaluate(ICharacterScanner scanner, boolean resume) {
        int ch;
        IToken token = Token.UNDEFINED;
        boolean acceptable = true;
        int whitespaceCount = 0;
        int unreadCount = 0;
        int wordCount = 0;
        if (this._unacceptablePrefixCharacter != '\u0000' && scanner.getColumn() > 0) {
            ch = 0;
            int readCount = 0;
            while (scanner.getColumn() > 0 && ch != -1) {
                scanner.unread();
                ch = scanner.read();
                if (!Character.isWhitespace(ch)) break;
                scanner.unread();
                ++readCount;
            }
            for (int i = 0; i < readCount; ++i) {
                scanner.read();
            }
            if (ch == this._unacceptablePrefixCharacter) {
                acceptable = false;
            }
        }
        if (acceptable) {
            while ((ch = scanner.read()) != -1) {
                ++unreadCount;
                if (ch == this._stopCharacter || this._stopCharacter2 != '\u0000' && ch == this._stopCharacter2) {
                    token = this._token;
                    scanner.unread();
                    break;
                }
                if (Character.isWhitespace((char)ch)) {
                    ++whitespaceCount;
                    continue;
                }
                if (!this.isAcceptableCharacter((char)ch, unreadCount - whitespaceCount) || (wordCount == 0 || whitespaceCount > 0) && ++wordCount >= 2 && !this.isMultiWordAllowed()) break;
                whitespaceCount = 0;
            }
            if (token == this._token) {
                unreadCount = whitespaceCount;
            }
            if (ch == -1) {
                ++unreadCount;
            }
            for (int i = 0; i < unreadCount; ++i) {
                scanner.unread();
            }
        }
        return token;
    }

    protected boolean isMultiWordAllowed() {
        return false;
    }

    protected boolean isAcceptableCharacter(char ch, int index) {
        boolean acceptableCharacter = Character.isJavaIdentifierPart(ch);
        for (int i = 0; !acceptableCharacter && i < this._acceptableCharacters.length; ++i) {
            acceptableCharacter = this._acceptableCharacters[i] == ch;
        }
        return acceptableCharacter;
    }
}

