/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.wodclipse.core.util;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.objectstyle.wolips.eomodeler.core.model.EOModelGroup;
import org.objectstyle.wolips.eomodeler.core.model.IEOModelGroupFactory;

public class EOModelGroupCache {
    private Map<IProject, EOModelGroup> _modelGroupCache = new HashMap<IProject, EOModelGroup>();

    public synchronized EOModelGroup getModelGroup(IProject project) {
        EOModelGroup modelGroup;
        if (project == null) {
            modelGroup = new EOModelGroup();
        } else {
            modelGroup = this._modelGroupCache.get(project);
            if (modelGroup == null) {
                modelGroup = new EOModelGroup();
                HashSet failures = new HashSet();
                try {
                    IEOModelGroupFactory.Utility.loadModelGroup((Object)project, (EOModelGroup)modelGroup, failures, (boolean)true, null, (IProgressMonitor)new NullProgressMonitor());
                    this._modelGroupCache.put(project, modelGroup);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return modelGroup;
    }

    public synchronized void clearCacheForProject(IProject project) {
        this.clearCacheForProject(project, new HashSet<IProject>());
    }

    public synchronized void clearCacheForProject(IProject project, Set<IProject> visitedProjects) {
        visitedProjects.add(project);
        this._modelGroupCache.remove(project);
        for (IProject referencingProject : project.getReferencingProjects()) {
            if (visitedProjects.contains(referencingProject)) continue;
            this.clearCacheForProject(referencingProject, visitedProjects);
        }
    }

    public synchronized void clearCache() {
        this._modelGroupCache.clear();
    }
}

