/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.wodclipse.core.validation;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import jp.aonir.fuzzyxml.FuzzyXMLDocument;
import jp.aonir.fuzzyxml.FuzzyXMLElement;
import jp.aonir.fuzzyxml.FuzzyXMLNode;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.JavaModelException;
import org.objectstyle.wolips.bindings.Activator;
import org.objectstyle.wolips.bindings.api.IApiBinding;
import org.objectstyle.wolips.bindings.wod.HtmlElementName;
import org.objectstyle.wolips.bindings.wod.IWodElement;
import org.objectstyle.wolips.bindings.wod.IWodModel;
import org.objectstyle.wolips.bindings.wod.SimpleWodBinding;
import org.objectstyle.wolips.bindings.wod.WodBindingValueProblem;
import org.objectstyle.wolips.bindings.wod.WodProblem;
import org.objectstyle.wolips.locate.LocateException;
import org.objectstyle.wolips.variables.BuildProperties;
import org.objectstyle.wolips.wodclipse.core.completion.HtmlCacheEntry;
import org.objectstyle.wolips.wodclipse.core.completion.WodCacheEntry;
import org.objectstyle.wolips.wodclipse.core.completion.WodParserCache;
import org.objectstyle.wolips.wodclipse.core.util.FuzzyXMLWodElement;
import org.objectstyle.wolips.wodclipse.core.util.WodHtmlUtils;
import org.objectstyle.wolips.wodclipse.core.validation.InlineWodProblem;

public class TemplateValidator {
    private BuildProperties _buildProperties;
    private WodParserCache _cache;
    private Set<FuzzyXMLElement> _woElements;

    public TemplateValidator(WodParserCache cache) {
        this._cache = cache;
        this._buildProperties = (BuildProperties)cache.getProject().getAdapter(BuildProperties.class);
    }

    public void validate(FuzzyXMLDocument doc) throws Exception {
        this.visitDocument(doc, true);
    }

    public void visitDocument(FuzzyXMLDocument doc, boolean validate) throws Exception {
        if (doc != null) {
            this._woElements = new HashSet<FuzzyXMLElement>();
            LinkedList<InlineWodProblem> inlineProblems = new LinkedList<InlineWodProblem>();
            FuzzyXMLElement rootElement = doc.getDocumentElement();
            this.visitElement(rootElement, inlineProblems, validate);
            if (validate) {
                HtmlCacheEntry htmlCacheEntry = this._cache.getHtmlEntry();
                htmlCacheEntry.getHtmlElementCache().clearCache();
                WodCacheEntry wodCacheEntry = this._cache.getWodEntry();
                IFile wodFile = wodCacheEntry.getFile();
                IWodModel wodModel = (IWodModel)wodCacheEntry.getModel();
                for (FuzzyXMLElement woElement : this._woElements) {
                    IWodElement wodElement;
                    String woElementName = woElement.getAttributeValue("name");
                    int startOffset = woElement.getOffset() + woElement.getNameOffset() + 1;
                    int endOffset = startOffset + woElement.getNameLength() - 1;
                    HtmlElementName elementName = new HtmlElementName(htmlCacheEntry.getFile(), woElementName, startOffset, endOffset);
                    htmlCacheEntry.getHtmlElementCache().addHtmlElement(elementName);
                    if (wodModel == null || (wodElement = wodModel.getElementNamed(woElementName)) != null) continue;
                    WodBindingValueProblem undefinedElement = new WodBindingValueProblem(wodElement, (IApiBinding)new SimpleWodBinding(null, "name", null), "name", "The element '" + woElementName + "' is not defined in " + wodFile.getName(), null, -1, false);
                    inlineProblems.add(new InlineWodProblem(woElement, (WodProblem)undefinedElement, this._cache));
                }
                for (InlineWodProblem wodProblem : inlineProblems) {
                    wodProblem.createProblemMarkers();
                }
            }
        }
    }

    private void visitElement(FuzzyXMLElement element, List<InlineWodProblem> inlineProblems, boolean validate) throws CoreException {
        if (element == null) {
            return;
        }
        String elementName = element.getName();
        if (WodHtmlUtils.isInline(elementName)) {
            FuzzyXMLWodElement wodElement;
            if (validate && (wodElement = new FuzzyXMLWodElement(element, this._buildProperties)) != null) {
                boolean validateBindingValues = Activator.getDefault().getPluginPreferences().getBoolean("CheckBindingValues");
                LinkedList<WodProblem> wodProblems = new LinkedList<WodProblem>();
                try {
                    wodElement.fillInProblems(this._cache.getJavaProject(), this._cache.getComponentType(), validateBindingValues, wodProblems, WodParserCache.getTypeCache(), this._cache.getHtmlEntry().getHtmlElementCache());
                    inlineProblems.add(new InlineWodProblem(element, wodProblems, this._cache));
                }
                catch (JavaModelException e) {
                    try {
                        WodParserCache.getTypeCache().clearCacheForType(this._cache.getComponentType());
                    }
                    catch (LocateException e1) {
                        e1.printStackTrace();
                    }
                }
                catch (Throwable t) {
                    Activator activator = Activator.getDefault();
                    if (activator != null) {
                        activator.log(t);
                    }
                }
            }
        } else if (WodHtmlUtils.isWOTag(elementName)) {
            String webobjectName = element.getAttributeValue("name");
            if (webobjectName == null) {
                if (validate) {
                    inlineProblems.add(new InlineWodProblem(element, "webobject tag missing 'name' attribute", false, this._cache));
                }
            } else {
                this._woElements.add(element);
                if (validate && element.getAttributes().length > 1) {
                    inlineProblems.add(new InlineWodProblem(element, "webobject tags should only have a 'name' attribute", true, this._cache));
                }
            }
        }
        FuzzyXMLNode[] nodes = element.getChildren();
        for (int i = 0; i < nodes.length; ++i) {
            if (!(nodes[i] instanceof FuzzyXMLElement)) continue;
            this.visitElement((FuzzyXMLElement)nodes[i], inlineProblems, validate);
        }
    }
}

