/*
 * Decompiled with CFR 0.152.
 */
package com.gammastream.validity;

import com.gammastream.validity.GSVEOEntity;
import com.gammastream.validity.GSVEOModel;
import com.gammastream.validity.GSVEntity;
import com.gammastream.validity.GSVRule;
import com.webobjects.appserver.xml.WOXMLCoder;
import com.webobjects.appserver.xml.WOXMLCoding;
import com.webobjects.appserver.xml.WOXMLDecoder;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSMutableArray;
import java.io.IOException;

public final class GSVAttribute
implements WOXMLCoding {
    private GSVEntity entity;
    private String name;
    private NSMutableArray rules;

    public GSVAttribute(GSVEntity anEntity, String aName) throws IllegalArgumentException {
        if (!this.validateAttributeForName(anEntity, aName)) {
            throw new IllegalArgumentException("EOAttribute named '" + aName + "' does not exist for EOEnity named '" + anEntity.name() + "' in EOModel for path: " + anEntity.model().eomodelPath());
        }
        this.entity = anEntity;
        this.name = aName;
        this.rules = new NSMutableArray();
    }

    private boolean validateAttributeForName(GSVEntity anEntity, String aName) {
        try {
            GSVEOModel gsmodel = new GSVEOModel(anEntity.model().eomodelPath());
            GSVEOEntity eoEntity = gsmodel.entityNamed(anEntity.name());
            return eoEntity.attributeNamed(aName) != null;
        }
        catch (IOException e) {
            System.out.println(e);
            return false;
        }
    }

    public String name() {
        return this.name;
    }

    public void setName(String newName) {
        this.name = newName;
    }

    public NSArray rules() {
        return this.rules;
    }

    public void addRule(GSVRule newRule) {
        this.rules.addObject((Object)newRule);
    }

    public void removeRule(GSVRule oldRule) {
        this.rules.removeObject((Object)oldRule);
    }

    public GSVRule ruleNamed(String name) {
        GSVRule currentrule = null;
        for (int i = 0; i < this.rules.count(); ++i) {
            currentrule = (GSVRule)this.rules.objectAtIndex(i);
            if (!currentrule.ruleName().equals(name)) continue;
            return currentrule;
        }
        return null;
    }

    public GSVEntity entity() {
        return this.entity;
    }

    public void setEntity(GSVEntity parentEntity) {
        this.entity = parentEntity;
    }

    public void encodeWithWOXMLCoder(WOXMLCoder coder) {
        coder.encodeObjectForKey((Object)this.entity, "Entity");
        coder.encodeObjectForKey((Object)this.name, "Name");
        coder.encodeObjectForKey((Object)new NSArray((NSArray)this.rules), "Rules");
    }

    public GSVAttribute(WOXMLDecoder decoder) {
        this.entity = (GSVEntity)decoder.decodeObjectForKey("Entity");
        this.name = (String)decoder.decodeObjectForKey("Name");
        this.rules = new NSMutableArray((NSArray)decoder.decodeObjectForKey("Rules"));
    }

    public Class classForCoder() {
        try {
            return Class.forName("com.gammastream.validity.GSVAttribute");
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }
}

