/*
 * Decompiled with CFR 0.152.
 */
package com.gammastream.validity;

import com.gammastream.validity.GSVAttribute;
import com.gammastream.validity.GSVModel;
import com.webobjects.appserver.xml.WOXMLCoder;
import com.webobjects.appserver.xml.WOXMLCoding;
import com.webobjects.appserver.xml.WOXMLDecoder;
import com.webobjects.eoaccess.EOAttribute;
import com.webobjects.eoaccess.EOEntity;
import com.webobjects.eoaccess.EORelationship;
import com.webobjects.eocontrol.EOClassDescription;
import com.webobjects.eocontrol.EOEditingContext;
import com.webobjects.eocontrol.EOEnterpriseObject;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSKeyValueCoding;
import com.webobjects.foundation.NSLog;
import com.webobjects.foundation.NSMutableArray;
import java.util.Enumeration;

public final class GSVEntity
implements WOXMLCoding {
    private GSVModel _model;
    private String _name;
    private NSMutableArray _attributes;

    public GSVEntity(GSVModel model, String entityname) throws IllegalArgumentException {
        if (!this.validateEntityForName(model, entityname)) {
            throw new IllegalArgumentException("EOEntity named '" + entityname + "' does not exist in EOModel for path: " + model.eomodelPath());
        }
        this._model = model;
        this._name = entityname;
        this._attributes = new NSMutableArray();
    }

    private boolean validateEntityForName(GSVModel model, String name) {
        return model.eomodelGroup().modelNamed(model.eomodelName()).entityNamed(name) != null;
    }

    public GSVModel model() {
        return this._model;
    }

    public void setModel(GSVModel newModel) {
        this._model = newModel;
    }

    public String name() {
        return this._name;
    }

    public NSMutableArray attributes() {
        return this._attributes;
    }

    public void addAttribute(GSVAttribute newAtt) {
        this._attributes.addObject((Object)newAtt);
    }

    public void removeAttribute(GSVAttribute oldAtt) {
        this._attributes.removeObject((Object)oldAtt);
    }

    public GSVAttribute attributeNamed(String name) {
        GSVAttribute currentAttribute = null;
        for (int i = 0; i < this._attributes.count(); ++i) {
            currentAttribute = (GSVAttribute)this._attributes.objectAtIndex(i);
            if (!currentAttribute.name().equals(name)) continue;
            return currentAttribute;
        }
        return null;
    }

    public void encodeWithWOXMLCoder(WOXMLCoder coder) {
        coder.encodeObjectForKey((Object)this._model, "Model");
        coder.encodeObjectForKey((Object)this._name, "Name");
        coder.encodeObjectForKey((Object)this._attributes.immutableClone(), "Attributes");
    }

    public GSVEntity(WOXMLDecoder decoder) {
        this._model = (GSVModel)decoder.decodeObjectForKey("Model");
        this._name = (String)decoder.decodeObjectForKey("Name");
        this._attributes = new NSMutableArray((NSArray)decoder.decodeObjectForKey("Attributes"));
    }

    public Class classForCoder() {
        try {
            return Class.forName("com.gammastream.validity.GSVEntity");
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(GSVModel model, EOEntity eoentity) {
        NSArray myattributes = this.attributes().immutableClone();
        Enumeration e = myattributes.objectEnumerator();
        while (e.hasMoreElements()) {
            GSVAttribute attribute = (GSVAttribute)e.nextElement();
            EOAttribute a = eoentity.attributeNamed(attribute.name());
            EORelationship p = eoentity.relationshipNamed(attribute.name());
            if (a == null) {
                NSLog.out.appendln((Object)("attribute " + attribute.name() + " does not exist in entity " + this.name() + " (anymore?), deleted from Valididy model"));
                this.removeAttribute(attribute);
                continue;
            }
            if (p != null) {
                NSLog.out.appendln((Object)("attribute " + attribute.name() + " in entity " + this.name() + " is (now?) an relationship which cannot have a validation rule, deleted from Valididy model"));
                this.removeAttribute(attribute);
                continue;
            }
            EOEditingContext ec = new EOEditingContext();
            ec.lock();
            try {
                if (attribute == null) {
                    NSLog.debug.appendln((Object)"attribute == null");
                    continue;
                }
                if (attribute.name() == null) {
                    NSLog.debug.appendln((Object)("attribute.name() == null, attribute = " + attribute));
                    continue;
                }
                EOClassDescription eoclassdescription = EOClassDescription.classDescriptionForEntityName((String)eoentity.name());
                EOEnterpriseObject eoenterpriseobject = eoclassdescription.createInstanceWithEditingContext(null, null);
                eoenterpriseobject.valueForKeyPath(attribute.name());
            }
            catch (NSKeyValueCoding.UnknownKeyException e1) {
                NSLog.out.appendln((Object)("attribute " + attribute.name() + " does not exist in entity " + this.name() + " anymore, deleted from Valididy model"));
                this.removeAttribute(attribute);
            }
            catch (Exception e1) {}
            continue;
            finally {
                ec.unlock();
                ec.dispose();
            }
        }
    }
}

