/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.appserver;

import com.webobjects.appserver.WOActionResults;
import com.webobjects.appserver.WOApplication;
import com.webobjects.appserver.WODirectAction;
import com.webobjects.appserver.WORequest;
import com.webobjects.appserver.WOResponse;
import com.webobjects.appserver._private.WOHostUtilities;
import com.webobjects.appserver.xml.WOXMLException;
import com.webobjects.appserver.xml._JavaMonitorCoder;
import com.webobjects.appserver.xml._JavaMonitorDecoder;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSLog;
import com.webobjects.foundation.NSMutableDictionary;
import com.webobjects.foundation.NSPropertyListSerialization;
import com.webobjects.foundation.NSTimestamp;
import com.webobjects.foundation.NSTimestampFormatter;

public class WOAdminAction
extends WODirectAction {
    private static final NSTimestampFormatter startedAtFormatter = new NSTimestampFormatter("%Y:%m:%d:%H:%M:%S %Z");
    private static final NSDictionary successElement = new NSDictionary(new Object[]{Boolean.TRUE}, new Object[]{"success"});
    private static final Object[] errorKeys = new Object[]{"success", "errorMessage"};
    private static final String _accessDenied = new _JavaMonitorCoder().encodeRootObjectForKey(new NSDictionary(new Object[]{Boolean.FALSE, "Access Denied"}, errorKeys), "instanceResponse");
    private static final String _invalidXML = new _JavaMonitorCoder().encodeRootObjectForKey(new NSDictionary(new Object[]{Boolean.FALSE, "Invalid XML Request"}, errorKeys), "instanceResponse");
    private static final String _emptyXML = new _JavaMonitorCoder().encodeRootObjectForKey(new NSDictionary(new Object[]{Boolean.FALSE, "Empty XML Request"}, errorKeys), "instanceResponse");

    public WOAdminAction(WORequest wORequest) {
        super(wORequest);
    }

    public WOActionResults pingAction() {
        WOResponse wOResponse = WOApplication.application().createResponseInContext(null);
        wOResponse.appendContentString("ALIVE");
        return wOResponse;
    }

    public WOActionResults instanceRequestAction() {
        Object object;
        String string;
        NSDictionary nSDictionary;
        WOResponse wOResponse = WOApplication.application().createResponseInContext(null);
        WORequest wORequest = this.request();
        boolean bl = WOHostUtilities._isLocalInetAddress(wORequest._originatingAddress(), true);
        if (wORequest.isUsingWebServer() || !bl) {
            wOResponse.setStatus(403);
            wOResponse.appendContentString(_accessDenied);
            return wOResponse;
        }
        try {
            nSDictionary = (NSDictionary)new _JavaMonitorDecoder().decodeRootObject(wORequest.content());
        }
        catch (WOXMLException wOXMLException) {
            NSLog.err.appendln((Object)("Instance Request: Error parsing: " + wORequest.contentString()));
            wOResponse.appendContentString(_invalidXML);
            return wOResponse;
        }
        if (nSDictionary == null) {
            wOResponse.appendContentString(_emptyXML);
            return wOResponse;
        }
        NSMutableDictionary nSMutableDictionary = new NSMutableDictionary(2);
        NSDictionary nSDictionary2 = (NSDictionary)nSDictionary.valueForKey("commandInstance");
        if (nSDictionary2 != null) {
            string = (String)nSDictionary2.valueForKey("command");
            if (string == null) {
                object = new NSDictionary(new Object[]{Boolean.FALSE, "Invalid Command: <null>"}, errorKeys);
                nSMutableDictionary.takeValueForKey(object, "commandInstanceResponse");
            } else if (string.equals("REFUSE")) {
                object = (Integer)nSDictionary2.valueForKey("minimumActiveSessionsCount");
                try {
                    int n = (Integer)object;
                    WOApplication.application().setMinimumActiveSessionsCount(n);
                }
                catch (Exception exception) {
                    NSLog._conditionallyLogPrivateException((Throwable)exception);
                }
                WOApplication.application().refuseNewSessions(true);
                nSMutableDictionary.takeValueForKey((Object)successElement, "commandInstanceResponse");
            } else if (string.equals("ACCEPT")) {
                WOApplication.application().refuseNewSessions(false);
                nSMutableDictionary.takeValueForKey((Object)successElement, "commandInstanceResponse");
            } else if (string.equals("TERMINATE")) {
                WOApplication.application()._terminateFromMonitor();
                nSMutableDictionary.takeValueForKey((Object)successElement, "commandInstanceResponse");
            } else {
                object = new NSDictionary(new Object[]{Boolean.FALSE, "Invalid Command: ".concat(string)}, errorKeys);
                nSMutableDictionary.takeValueForKey(object, "commandInstanceResponse");
            }
        }
        if ((string = (String)nSDictionary.valueForKey("queryInstance")) != null && string.equals("STATISTICS")) {
            object = "Sessions";
            String string2 = "Last Session's Statistics";
            NSMutableDictionary nSMutableDictionary2 = null;
            NSTimestamp nSTimestamp = null;
            NSMutableDictionary nSMutableDictionary3 = WOApplication.application().statistics().mutableClone();
            nSMutableDictionary2 = (NSMutableDictionary)nSMutableDictionary3.objectForKey(object);
            if (nSMutableDictionary2 != null) {
                nSMutableDictionary2.removeObjectForKey((Object)string2);
            }
            if ((nSTimestamp = (NSTimestamp)nSMutableDictionary3.objectForKey((Object)"StartedAt")) != null) {
                nSMutableDictionary3.setObjectForKey((Object)startedAtFormatter.format((Object)nSTimestamp), (Object)"StartedAt");
            }
            String string3 = NSPropertyListSerialization.stringFromPropertyList((Object)nSMutableDictionary3);
            nSMutableDictionary.takeValueForKey((Object)string3, "queryInstanceResponse");
        }
        wOResponse.appendContentString(new _JavaMonitorCoder().encodeRootObjectForKey(nSMutableDictionary, "instanceResponse"));
        return wOResponse;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<");
        stringBuffer.append(this.getClass().getName());
        stringBuffer.append(" " + super.toString());
        stringBuffer.append(">");
        return new String(stringBuffer);
    }
}

