/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.appserver;

import com.webobjects.appserver.WOApplication;
import com.webobjects.appserver.WOComponent;
import com.webobjects.appserver.WOElement;
import com.webobjects.appserver.WORequest;
import com.webobjects.appserver.WOResourceManager;
import com.webobjects.appserver.WOResponse;
import com.webobjects.appserver.WOSession;
import com.webobjects.appserver._private.WOComponentDefinition;
import com.webobjects.appserver._private.WODynamicURL;
import com.webobjects.appserver._private.WOElementID;
import com.webobjects.appserver._private.WOShared;
import com.webobjects.appserver._private.WOURLEncoder;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSForwardException;
import com.webobjects.foundation.NSKeyValueCoding;
import com.webobjects.foundation.NSKeyValueCodingAdditions;
import com.webobjects.foundation.NSLog;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSMutableDictionary;
import com.webobjects.foundation._NSStringUtilities;
import java.util.Enumeration;

public class WOContext
implements Cloneable,
NSKeyValueCoding,
NSKeyValueCoding.ErrorHandling,
NSKeyValueCodingAdditions {
    private String _contextID = null;
    private String _requestContextID;
    private String _requestSenderID = null;
    private String _requestSessionID;
    private String _componentName;
    private WOElementID _elementID = null;
    protected WOSession _session = null;
    private WORequest _request = null;
    private WOResponse _response = null;
    private WOElement _pageElement = null;
    private WOComponent _pageComponent = null;
    private WOComponent _currentComponent;
    private WODynamicURL _url = new WODynamicURL();
    private boolean _generateCompleteURLs;
    private StringBuffer _completeURLPrefix;
    private String _urlApplicationNumber = "-1";
    private boolean _distributionEnabled;
    private boolean _pageChanged;
    private boolean _pageReplaced;
    private boolean _inForm = false;
    private boolean _formSubmitted = false;
    private boolean _actionInvoked;
    private boolean _isMultipleSubmitForm;
    private NSMutableArray _awakePageComponents;
    private StringBuffer _requestHandlerPath;
    private WOComponentDefinition _tempComponentDefinition;
    private WOResourceManager _resourceManager;
    private NSArray _languagesAction;
    private NSMutableDictionary _userInfo;
    private volatile boolean _refuseThisRequest;
    private static final String _SessionIDKey = "?wosid";

    public static WOContext contextWithRequest(WORequest wORequest) {
        return WOApplication.application().createContextForRequest(wORequest);
    }

    private WOContext() {
        this(null);
    }

    public WOContext(WORequest wORequest) {
        this._setRequest(wORequest);
        this._pageChanged = false;
        this._pageReplaced = false;
        this._awakePageComponents = new NSMutableArray();
        this._requestHandlerPath = new StringBuffer(256);
        this._tempComponentDefinition = null;
        this._generateCompleteURLs = false;
        this._completeURLPrefix = new StringBuffer(256);
        this._resourceManager = WOApplication.application().resourceManager();
        this._userInfo = new NSMutableDictionary();
        this._refuseThisRequest = false;
    }

    public Object clone() {
        WOContext wOContext;
        try {
            wOContext = WOApplication.application().createContextForRequest(this._request);
            wOContext._setSenderID(this._requestSenderID);
            wOContext._setRequestContextID(this._requestContextID);
            wOContext._setSession(this._session);
            wOContext._setResponse(this._response);
            wOContext._setPageElement(this._pageElement);
            wOContext.appendElementIDComponent(this.elementID());
            wOContext._takeAwakeComponentsFromArray(this._awakePageComponents);
            wOContext._setUserInfo(this._userInfo.mutableClone());
            if (this._generateCompleteURLs) {
                wOContext._generateCompleteURLs();
            } else {
                wOContext._generateRelativeURLs();
            }
        }
        catch (Exception exception) {
            NSLog.err.appendln((Object)("<" + this.getClass().getName() + ".clone()> Exception occurred  :" + exception.toString()));
            if (NSLog.debugLoggingAllowedForLevelAndGroups((int)1, (long)4L)) {
                NSLog.debug.appendln((Throwable)exception);
            }
            throw NSForwardException._runtimeExceptionForThrowable((Throwable)exception);
        }
        return wOContext;
    }

    public String toString() {
        return "<" + this.getClass().getName() + " contextID=" + this._contextID + " requestSenderID=" + this._requestSenderID + " elementID=" + this._elementID + " sessionID=" + (this._session != null ? this._session.sessionID() : "null") + " request=" + this._request + " response=" + this._response + " pageElement=" + this._pageElement + " pageComponent=" + this._pageComponent + " currentComponent=" + this._currentComponent + " url=" + this._url + " urlApplicationNumber=" + this._urlApplicationNumber + " distributionEnabled=" + this._distributionEnabled + " pageChanged=" + this._pageChanged + " pageReplaced=" + this._pageReplaced + ">";
    }

    public String contextID() {
        if (this._contextID == null && this._session != null) {
            this._contextID = WOShared.unsignedIntString(this._session._contextCounter());
        }
        return this._contextID;
    }

    public String senderID() {
        return this._requestSenderID;
    }

    public void _setRequestContextID(String string) {
        this._requestContextID = string;
    }

    public String _requestContextID() {
        return this._requestContextID;
    }

    public void _setRequestSessionID(String string) {
        this._requestSessionID = string;
    }

    public String _requestSessionID() {
        return this._requestSessionID;
    }

    public boolean hasSession() {
        return this._session != null;
    }

    public WOSession session() {
        WOApplication wOApplication = WOApplication.application();
        if (this._session == null && this._requestSessionID != null) {
            wOApplication.restoreSessionWithID(this._requestSessionID, this);
        }
        if (this._session == null) {
            wOApplication._initializeSessionInContext(this);
            if (this._session == null) {
                throw new IllegalStateException("<" + wOApplication.getClass().getName() + ": Unable to create new session.");
            }
        }
        return this._session;
    }

    public WORequest request() {
        return this._request;
    }

    public WOResponse response() {
        return this._response;
    }

    public WODynamicURL _url() {
        return this._url;
    }

    public void setInForm(boolean bl) {
        this._inForm = bl;
    }

    public boolean isInForm() {
        return this._inForm;
    }

    public void _setFormSubmitted(boolean bl) {
        this._formSubmitted = bl;
    }

    public boolean _wasFormSubmitted() {
        return this._formSubmitted;
    }

    public void _setActionInvoked(boolean bl) {
        this._actionInvoked = bl;
    }

    public boolean _wasActionInvoked() {
        return this._actionInvoked;
    }

    public void _setIsMultipleSubmitForm(boolean bl) {
        this._isMultipleSubmitForm = bl;
    }

    public boolean _isMultipleSubmitForm() {
        return this._isMultipleSubmitForm;
    }

    protected void _takeAwakeComponent(WOComponent wOComponent) {
        if (!this._awakePageComponents.containsObject((Object)wOComponent)) {
            this._awakePageComponents.addObject((Object)wOComponent);
        }
    }

    private void _takeAwakeComponentsFromArray(NSMutableArray nSMutableArray) {
        if (nSMutableArray != null) {
            Enumeration enumeration = nSMutableArray.objectEnumerator();
            while (enumeration.hasMoreElements()) {
                this._awakePageComponents.addObject(enumeration.nextElement());
            }
        }
    }

    public void _setUserInfo(NSMutableDictionary nSMutableDictionary) {
        this._userInfo = nSMutableDictionary;
    }

    public NSMutableDictionary _userInfo() {
        return this._userInfo;
    }

    public WOComponent page() {
        if (this._pageComponent != null && this._pageComponent._isPage()) {
            return this._pageComponent;
        }
        return null;
    }

    public WOComponent component() {
        return this._currentComponent;
    }

    public String _componentName() {
        String string = this._componentName;
        this._componentName = null;
        return string;
    }

    public void _setComponentName(String string) {
        this._componentName = string;
    }

    public WOComponentDefinition _tempComponentDefinition() {
        WOComponentDefinition wOComponentDefinition = this._tempComponentDefinition;
        this._tempComponentDefinition = null;
        return wOComponentDefinition;
    }

    public void _setTempComponentDefinition(WOComponentDefinition wOComponentDefinition) {
        this._tempComponentDefinition = wOComponentDefinition;
    }

    public String elementID() {
        String string = null;
        if (this._elementID != null) {
            string = this._elementID.toString();
        }
        return string;
    }

    public boolean _pageChanged() {
        return this._pageChanged;
    }

    public void _setPageChanged(boolean bl) {
        this._pageChanged = bl;
    }

    public void _setCurrentComponent(WOComponent wOComponent) {
        this._currentComponent = wOComponent;
    }

    public WOSession _session() {
        return this._session;
    }

    public void _incrementContextID() {
        this._contextID = this._contextID == null ? "1" : WOShared.unsignedIntString(Integer.parseInt(this._contextID) + 1);
        if (this._session != null) {
            this._session._contextDidIncrementContextID();
        }
    }

    public void _synchronizeForDistribution() {
        boolean bl;
        int n = -1;
        String string = null;
        if (this._request != null) {
            n = this._request.applicationNumber();
            string = this._request.sessionID();
        }
        boolean bl2 = n < -1;
        boolean bl3 = this._session != null && this._session.storesIDsInURLs() && !this._session.isDistributionEnabled();
        boolean bl4 = this._session == null && string != null && n != -1;
        boolean bl5 = bl = bl3 || bl4;
        this._urlApplicationNumber = bl2 || bl ? (this._request != null ? WOShared.unsignedIntString(n) : "-1") : "-1";
        this._url.setApplicationNumber(this._urlApplicationNumber);
    }

    public void _setSenderID(String string) {
        this._requestSenderID = string;
    }

    public void _setSession(WOSession wOSession) {
        if (wOSession != this._session) {
            this._session = wOSession;
            this._synchronizeForDistribution();
        }
        if (wOSession != null) {
            this._contextID = WOShared.unsignedIntString(wOSession._contextCounter());
        }
    }

    public void _setRequest(WORequest wORequest) {
        if (wORequest != this._request) {
            this._request = wORequest;
            this._request._setContext(this);
            if (this._request != null) {
                this._url.setPrefix(this._request.adaptorPrefix());
                this._url.setApplicationName(this._request.applicationName());
            } else {
                this._url.setPrefix(null);
                this._url.setApplicationName(null);
            }
            this._synchronizeForDistribution();
        }
    }

    public void _setResponse(WOResponse wOResponse) {
        this._response = wOResponse;
    }

    public void _setPageComponent(WOComponent wOComponent) {
        this._pageComponent = wOComponent;
        this._takeAwakeComponent(this._pageComponent);
    }

    public void _setPageElement(WOElement wOElement) {
        if (wOElement != this._pageElement) {
            this._pageComponent = null;
            this._pageElement = wOElement;
            if (this._pageElement != null) {
                Class<?> clazz = this._pageElement.getClass();
                if (this._pageElement instanceof WOComponent) {
                    this._setPageComponent((WOComponent)this._pageElement);
                }
            }
        }
    }

    public WOElement _pageElement() {
        return this._pageElement;
    }

    public WOComponent _pageComponent() {
        return this._pageComponent;
    }

    void _setLanguages(NSArray nSArray) {
        this._languagesAction = nSArray;
    }

    public NSArray _languages() {
        if (this._session != null) {
            return this._session.languages();
        }
        if (this._languagesAction != null) {
            return this._languagesAction;
        }
        WORequest wORequest = this.request();
        if (wORequest != null) {
            return wORequest.browserLanguages();
        }
        return null;
    }

    public void _putAwakeComponentsToSleep() {
        Enumeration enumeration = this._awakePageComponents.objectEnumerator();
        while (enumeration.hasMoreElements()) {
            WOComponent wOComponent = (WOComponent)enumeration.nextElement();
            wOComponent._sleepInContext(this);
        }
    }

    private void _stripSessionIDFromURL() {
        String string = this._url.requestHandlerPath();
        if (string == null) {
            return;
        }
        int n = string.indexOf(_SessionIDKey);
        if (n > 0) {
            int n2 = n;
            int n3 = string.indexOf(63, n2);
            if (n3 < 0) {
                this._url.setRequestHandlerPath(string.substring(0, n2));
            } else {
                this._url.setRequestHandlerPath(_NSStringUtilities.concat((String)string.substring(0, n2), (String)string.substring(n2 + 1, string.length())));
            }
        }
    }

    private NSDictionary _removeSessionIDFromDictionary(NSDictionary nSDictionary) {
        NSDictionary nSDictionary2;
        if (nSDictionary instanceof NSMutableDictionary) {
            NSMutableDictionary nSMutableDictionary = (NSMutableDictionary)nSDictionary;
            nSMutableDictionary.removeObjectForKey((Object)"wosid");
            nSDictionary2 = nSMutableDictionary;
        } else {
            Object object = nSDictionary.objectForKey((Object)"wosid");
            if (object != null) {
                NSMutableDictionary nSMutableDictionary = nSDictionary.mutableClone();
                nSMutableDictionary.removeObjectForKey((Object)"wosid");
                nSDictionary2 = nSMutableDictionary;
            } else {
                nSDictionary2 = nSDictionary;
            }
        }
        return nSDictionary2;
    }

    public void _generateCompleteURLs() {
        this._generateCompleteURLs = true;
    }

    public void _generateRelativeURLs() {
        this._generateCompleteURLs = false;
    }

    private boolean _sessionIDInURL() {
        String string = null;
        if (this.request() != null) {
            string = this.request().stringFormValueForKey("wosid");
        }
        return string != null;
    }

    private String _directActionURLForActionNamed(String string, NSDictionary nSDictionary, boolean bl) {
        String string2;
        WOSession wOSession;
        boolean bl2 = nSDictionary != null && nSDictionary.count() > 0;
        Object object = null;
        String string3 = null;
        if (this.hasSession() && (wOSession = this._session()).storesIDsInURLs()) {
            string3 = wOSession.sessionID();
        } else if (!this.hasSession() && this._sessionIDInURL()) {
            string3 = this._requestSessionID;
        }
        if (!(string3 == null || bl2 && nSDictionary.objectForKey((Object)"wosid") == Boolean.FALSE)) {
            if (string.indexOf(_SessionIDKey) < 0) {
                string2 = nSDictionary == null ? new NSMutableDictionary(1) : (nSDictionary instanceof NSMutableDictionary ? (NSMutableDictionary)nSDictionary : nSDictionary.mutableClone());
                string2.setObjectForKey((Object)string3, (Object)"wosid");
                object = string2;
                bl2 = true;
            } else if (bl2) {
                object = this._removeSessionIDFromDictionary(nSDictionary);
                bl2 = object.count() > 0;
            }
        } else {
            if (bl2) {
                object = this._removeSessionIDFromDictionary(nSDictionary);
                bl2 = object.count() > 0;
            }
            this._stripSessionIDFromURL();
        }
        string2 = null;
        if (bl2) {
            string2 = WOURLEncoder.encodeAsCGIFormValues(object);
        }
        return this._urlWithRequestHandlerKey(WOApplication.application().directActionRequestHandlerKey(), string, string2, bl);
    }

    public String directActionURLForActionNamed(String string, NSDictionary nSDictionary) {
        return this._directActionURL(string, nSDictionary, false);
    }

    public String _directActionURL(String string, NSDictionary nSDictionary, boolean bl) {
        boolean bl2;
        String string2 = null;
        boolean bl3 = this._request != null && this._request.applicationNumber() < -1;
        boolean bl4 = bl2 = this._session == null && this._requestSessionID == null && !bl3;
        if (bl2) {
            this._url.setApplicationNumber("-1");
        }
        string2 = this._directActionURLForActionNamed(string, nSDictionary, bl);
        if (bl2) {
            this._url.setApplicationNumber(this._urlApplicationNumber);
        }
        return string2;
    }

    public String componentActionURL() {
        return this._componentActionURL(false);
    }

    public String _componentActionURL(boolean bl) {
        Object var2_2 = null;
        WOSession wOSession = this.session();
        WOApplication wOApplication = WOApplication.application();
        String string = this.contextID();
        String string2 = this.elementID();
        this._requestHandlerPath.setLength(0);
        if (wOApplication.pageCacheSize() == 0) {
            if (wOSession.storesIDsInURLs()) {
                this._requestHandlerPath.append(this.page().name());
                this._requestHandlerPath.append('/');
                this._requestHandlerPath.append(wOSession.sessionID());
                this._requestHandlerPath.append('/');
                this._requestHandlerPath.append(string);
                this._requestHandlerPath.append('.');
                this._requestHandlerPath.append(string2);
            } else {
                this._requestHandlerPath.append(this.page().name());
                this._requestHandlerPath.append('/');
                this._requestHandlerPath.append(string);
                this._requestHandlerPath.append('.');
                this._requestHandlerPath.append(string2);
            }
        } else if (wOSession.storesIDsInURLs()) {
            this._requestHandlerPath.append(wOSession.sessionID());
            this._requestHandlerPath.append('/');
            this._requestHandlerPath.append(string);
            this._requestHandlerPath.append('.');
            this._requestHandlerPath.append(string2);
        } else {
            this._requestHandlerPath.append(string);
            this._requestHandlerPath.append('.');
            this._requestHandlerPath.append(string2);
        }
        return this._urlWithRequestHandlerKey(wOApplication.componentRequestHandlerKey(), this._requestHandlerPath.toString(), null, bl);
    }

    public String urlWithRequestHandlerKey(String string, String string2, String string3) {
        return this._urlWithRequestHandlerKey(string, string2, string3, false);
    }

    public String _urlWithRequestHandlerKey(String string, String string2, String string3, boolean bl) {
        String string4 = null;
        string4 = this._generateCompleteURLs ? this.completeURLWithRequestHandlerKey(string, string2, string3, bl, 0) : this._relativeURLWithRequestHandlerKey(string, string2, string3);
        return string4;
    }

    public String completeURLWithRequestHandlerKey(String string, String string2, String string3, boolean bl, int n) {
        this._completeURLPrefix.setLength(0);
        if (this._request != null) {
            this._request._completeURLPrefix(this._completeURLPrefix, bl, n);
        }
        this._url.setRequestHandlerKey(string);
        this._url.setRequestHandlerPath(string2);
        this._url.setQueryString(string3);
        this._completeURLPrefix.append(this._url.toString());
        return this._completeURLPrefix.toString();
    }

    private String _relativeURLWithRequestHandlerKey(String string, String string2, String string3) {
        this._url.setRequestHandlerKey(string);
        this._url.setRequestHandlerPath(string2);
        this._url.setQueryString(string3);
        return this._url.toString();
    }

    public String _urlForResourceNamed(String string, String string2, boolean bl) {
        return this._resourceManager.urlForResourceNamed(string, string2, this._languages(), this.request());
    }

    public void appendElementIDComponent(String string) {
        if (this._elementID == null) {
            this._elementID = new WOElementID(null);
        }
        this._elementID.appendElementIDComponent(string);
    }

    public void appendZeroElementIDComponent() {
        if (this._elementID == null) {
            this._elementID = new WOElementID(null);
        }
        this._elementID.appendZeroElementIDComponent();
    }

    public void incrementLastElementIDComponent() {
        if (this._elementID == null) {
            this._elementID = new WOElementID(null);
        }
        this._elementID.incrementLastElementIDComponent();
    }

    public void deleteLastElementIDComponent() {
        if (this._elementID == null) {
            this._elementID = new WOElementID(null);
        }
        this._elementID.deleteLastElementIDComponent();
    }

    public void deleteAllElementIDComponents() {
        if (this._elementID == null) {
            this._elementID = new WOElementID(null);
        }
        this._elementID.deleteAllElementIDComponents();
    }

    public boolean _refuseThisRequest() {
        return this._refuseThisRequest;
    }

    public void _set_refuseThisRequest(boolean bl) {
        this._refuseThisRequest = bl;
    }

    public static boolean canAccessFieldsDirectly() {
        return true;
    }

    public Object valueForKey(String string) {
        return NSKeyValueCoding.DefaultImplementation.valueForKey((Object)this, (String)string);
    }

    public void takeValueForKey(Object object, String string) {
        NSKeyValueCoding.DefaultImplementation.takeValueForKey((Object)this, (Object)object, (String)string);
    }

    public Object handleQueryWithUnboundKey(String string) {
        return NSKeyValueCoding.DefaultImplementation.handleQueryWithUnboundKey((Object)this, (String)string);
    }

    public void handleTakeValueForUnboundKey(Object object, String string) {
        NSKeyValueCoding.DefaultImplementation.handleTakeValueForUnboundKey((Object)this, (Object)object, (String)string);
    }

    public void unableToSetNullForKey(String string) {
        NSKeyValueCoding.DefaultImplementation.unableToSetNullForKey((Object)this, (String)string);
    }

    public Object valueForKeyPath(String string) {
        return NSKeyValueCodingAdditions.DefaultImplementation.valueForKeyPath((Object)this, (String)string);
    }

    public void takeValueForKeyPath(Object object, String string) {
        NSKeyValueCodingAdditions.DefaultImplementation.takeValueForKeyPath((Object)this, (Object)object, (String)string);
    }
}

