/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.appserver;

import com.webobjects.foundation.NSKeyValueCoding;
import com.webobjects.foundation.NSKeyValueCodingAdditions;
import com.webobjects.foundation.NSTimeZone;
import com.webobjects.foundation.NSTimestamp;
import com.webobjects.foundation.NSTimestampFormatter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.text.DateFormatSymbols;
import java.util.Locale;

public class WOCookie
implements NSKeyValueCoding,
NSKeyValueCoding.ErrorHandling,
NSKeyValueCodingAdditions,
Serializable {
    static final long serialVersionUID = 4511673225599865671L;
    String _name;
    String _value;
    String _domain;
    String _path;
    boolean _isSecure;
    NSTimestamp _expires;
    int _timeout;
    static final NSTimestampFormatter TheDateFormat;

    public static WOCookie cookieWithName(String string, String string2, String string3, String string4, NSTimestamp nSTimestamp, boolean bl) {
        return new WOCookie(string, string2, string3, string4, nSTimestamp, bl);
    }

    public static WOCookie cookieWithName(String string, String string2, String string3, String string4, int n, boolean bl) {
        return new WOCookie(string, string2, string3, string4, n, bl);
    }

    public static WOCookie cookieWithName(String string, String string2) {
        return new WOCookie(string, string2);
    }

    public WOCookie(String string, String string2, String string3, String string4, NSTimestamp nSTimestamp, boolean bl) {
        if (string == null) {
            throw new IllegalArgumentException("Cookie may not have null name.");
        }
        this._name = string;
        this._value = string2;
        this._path = string3;
        this._domain = string4;
        this._expires = nSTimestamp;
        this._isSecure = bl;
        this.setTimeOut(-1);
    }

    public WOCookie(String string, String string2, String string3, String string4, int n, boolean bl) {
        if (string == null) {
            throw new IllegalArgumentException("Cookie may not have null name.");
        }
        this._name = string;
        this._value = string2;
        this._path = string3;
        this._domain = string4;
        this.setTimeOut(n);
        this._isSecure = bl;
    }

    public WOCookie(String string, String string2) {
        this(string, string2, null, null, -1, false);
    }

    public String toString() {
        String string = this._expires == null ? "" : " expires=" + TheDateFormat.format((Object)this._expires);
        String string2 = this._timeout >= 0 ? " max-age=" + this._timeout : "";
        return "<" + this.getClass().getName() + " name=" + this._name + " value=" + this._value + " path=" + this._path + " domain=" + this._domain + string + string2 + " isSecure=" + (this._isSecure ? "true" : "false") + ">";
    }

    public String headerString() {
        return this._headerString(false);
    }

    String _headerString(boolean bl) {
        StringBuffer stringBuffer = new StringBuffer(140);
        stringBuffer.append(this._name);
        stringBuffer.append('=');
        if (!(this._value == null || this._value.indexOf(32) == -1 || this._value.startsWith("\"") && this._value.endsWith("\""))) {
            stringBuffer.append("\"");
            stringBuffer.append(this._value);
            stringBuffer.append("\"");
        } else if (this._value == null) {
            stringBuffer.append(" ");
        } else {
            stringBuffer.append(this._value);
        }
        if (!bl) {
            stringBuffer.append("; version=\"1\"");
            if (this._timeout >= 0) {
                stringBuffer.append("; max-age=");
                stringBuffer.append(this._timeout);
            }
            if (this._expires != null) {
                stringBuffer.append("; expires=");
                stringBuffer.append(TheDateFormat.format((Object)this._expires));
            }
            if (this._path != null) {
                stringBuffer.append("; path=");
                stringBuffer.append(this._path);
            }
            if (this._domain != null) {
                stringBuffer.append("; domain=");
                stringBuffer.append(this._domain);
            }
            if (this._isSecure) {
                stringBuffer.append("; secure");
            }
        }
        return new String(stringBuffer);
    }

    public String name() {
        return this._name;
    }

    public void setName(String string) {
        this._name = string;
    }

    public String value() {
        return this._value;
    }

    public void setValue(String string) {
        this._value = string;
    }

    public String domain() {
        return this._domain;
    }

    public void setDomain(String string) {
        this._domain = string;
    }

    public String path() {
        return this._path;
    }

    public void setPath(String string) {
        this._path = string;
    }

    public NSTimestamp expires() {
        return this._expires;
    }

    public void setExpires(NSTimestamp nSTimestamp) {
        this._expires = nSTimestamp;
    }

    public void setTimeOut(int n) {
        this._timeout = n;
    }

    public int timeOut() {
        return this._timeout;
    }

    public boolean isSecure() {
        return this._isSecure;
    }

    public void setIsSecure(boolean bl) {
        this._isSecure = bl;
    }

    public static boolean canAccessFieldsDirectly() {
        return true;
    }

    public Object valueForKey(String string) {
        return NSKeyValueCoding.DefaultImplementation.valueForKey((Object)this, (String)string);
    }

    public void takeValueForKey(Object object, String string) {
        NSKeyValueCoding.DefaultImplementation.takeValueForKey((Object)this, (Object)object, (String)string);
    }

    public Object handleQueryWithUnboundKey(String string) {
        return NSKeyValueCoding.DefaultImplementation.handleQueryWithUnboundKey((Object)this, (String)string);
    }

    public void handleTakeValueForUnboundKey(Object object, String string) {
        NSKeyValueCoding.DefaultImplementation.handleTakeValueForUnboundKey((Object)this, (Object)object, (String)string);
    }

    public void unableToSetNullForKey(String string) {
        NSKeyValueCoding.DefaultImplementation.unableToSetNullForKey((Object)this, (String)string);
    }

    public Object valueForKeyPath(String string) {
        return NSKeyValueCodingAdditions.DefaultImplementation.valueForKeyPath((Object)this, (String)string);
    }

    public void takeValueForKeyPath(Object object, String string) {
        NSKeyValueCodingAdditions.DefaultImplementation.takeValueForKeyPath((Object)this, (Object)object, (String)string);
    }

    public void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeInt(this._timeout);
        objectOutputStream.writeUTF(this._name);
        objectOutputStream.writeUTF(this._value);
        objectOutputStream.writeUTF(this._domain);
        objectOutputStream.writeUTF(this._path);
        objectOutputStream.writeBoolean(this._isSecure);
        objectOutputStream.writeObject(this._expires);
    }

    public void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this._timeout = objectInputStream.readInt();
        this._name = objectInputStream.readUTF();
        this._value = objectInputStream.readUTF();
        this._domain = objectInputStream.readUTF();
        this._path = objectInputStream.readUTF();
        this._isSecure = objectInputStream.readBoolean();
        this._expires = (NSTimestamp)objectInputStream.readObject();
    }

    static {
        DateFormatSymbols dateFormatSymbols = new DateFormatSymbols(Locale.US);
        dateFormatSymbols.setZoneStrings(NSTimestampFormatter._getDefaultZoneStrings());
        TheDateFormat = new NSTimestampFormatter("%a, %d-%b-%Y %H:%M:%S GMT", dateFormatSymbols);
        TheDateFormat.setDefaultFormatTimeZone(NSTimeZone.timeZoneWithName((String)"GMT", (boolean)true));
    }
}

