/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.appserver;

import com.webobjects.appserver.WOActionResults;
import com.webobjects.appserver.WOApplication;
import com.webobjects.appserver.WOComponent;
import com.webobjects.appserver.WOContext;
import com.webobjects.appserver.WOCookie;
import com.webobjects.appserver.WOElement;
import com.webobjects.appserver.WORequest;
import com.webobjects.appserver.WOResponse;
import com.webobjects.appserver.WOStatisticsStore;
import com.webobjects.appserver._private.WOShared;
import com.webobjects.appserver._private.WOTransactionRecord;
import com.webobjects.appserver._private.WOUniqueIDGenerator;
import com.webobjects.appserver._private._PermanentCacheSingleton;
import com.webobjects.eocontrol.EOEditingContext;
import com.webobjects.eocontrol.EOEventCenter;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSForwardException;
import com.webobjects.foundation.NSKeyValueCoding;
import com.webobjects.foundation.NSKeyValueCodingAdditions;
import com.webobjects.foundation.NSLog;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSMutableDictionary;
import com.webobjects.foundation.NSNotificationCenter;
import com.webobjects.foundation.NSSelector;
import com.webobjects.foundation.NSTimestamp;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Enumeration;

public class WOSession
implements Cloneable,
Serializable,
NSKeyValueCoding,
NSKeyValueCoding.ErrorHandling,
NSKeyValueCodingAdditions {
    static final long serialVersionUID = -3892089045508903478L;
    private String _sessionID;
    private long _timeOut;
    private NSMutableArray _contextArrayStack;
    private NSMutableDictionary _contextRecords;
    private NSArray _languages;
    protected NSMutableDictionary _componentState;
    private NSTimestamp _birthDate;
    private boolean _wasTimedOut;
    private boolean _wasJ2EETerminated;
    private NSMutableArray _stats;
    private StringBuffer _formattedStats;
    private transient WOContext _currentContext;
    private int _contextCounter;
    private int _requestCounter;
    private boolean _allowedToViewStatistics;
    private boolean _allowedToViewEvents;
    private boolean _terminating;
    private boolean _distributionEnabled;
    private boolean _cookieRVEnabled;
    private boolean _URLRVEnabled;
    private NSMutableDictionary _permanentPageCache;
    private NSMutableArray _permanentContextIDArray;
    private EOEditingContext _editingContext;
    private boolean _hasSessionLockedEditingContext;
    public static final String SessionDidTimeOutNotification = "SessionDidTimeOutNotification";
    public static final String SessionDidRestoreNotification = "SessionDidRestoreNotification";
    public static final String SessionDidCreateNotification = "SessionDidCreateNotification";
    private static String TheRendezVousCookiePath;
    protected transient Object _httpSession = null;
    protected transient Object _httpSessionWatcher = null;

    private WOSession(String string, long l) {
        WOApplication wOApplication = WOApplication.application();
        if (string == null) {
            string = WOUniqueIDGenerator.sharedInstance().longUniqueID(l);
        }
        this._sessionID = string;
        this._URLRVEnabled = true;
        this.setTimeOut(WOApplication.application().sessionTimeOut().doubleValue());
        this._finishInitializingSession(wOApplication, l);
    }

    private void _finishInitializingSession(WOApplication wOApplication, long l) {
        WOStatisticsStore wOStatisticsStore = wOApplication.statisticsStore();
        if (wOStatisticsStore != null) {
            if (this._birthDate == null) {
                this._birthDate = new NSTimestamp(l);
            }
            if (this._stats == null) {
                this._stats = new NSMutableArray(64);
            }
            wOStatisticsStore._applicationCreatedSession(this);
        } else {
            this._birthDate = null;
            this._stats = null;
        }
        wOApplication._finishInitializingSession(this);
    }

    public WOSession() {
        this(null, System.currentTimeMillis());
    }

    public WOSession(String string) {
        this(string, System.currentTimeMillis());
    }

    public Object clone() {
        WOSession wOSession;
        try {
            try {
                Class<?> clazz = this.getClass();
                if (clazz == WOSession.class) {
                    wOSession = new WOSession(this._sessionID);
                } else {
                    wOSession = (WOSession)clazz.newInstance();
                    wOSession._sessionID = this._sessionID;
                }
            }
            catch (Exception exception) {
                try {
                    wOSession = new WOSession(this._sessionID);
                }
                catch (Exception exception2) {
                    throw new NSForwardException((Throwable)exception2, "<" + this.getClass().getName() + "> Exception occurred while initializing component copy: " + exception2.toString());
                }
            }
            wOSession._setContextArrayStack((NSArray)this._contextArrayStack);
            wOSession._setContextRecords((NSDictionary)this._contextRecords);
            wOSession._setComponentState((NSDictionary)this._componentState);
            wOSession._setBirthDate(this._birthDate);
            wOSession._setStats((NSArray)this._stats);
            wOSession._setFormattedStats(new String(this._formattedStats));
            wOSession._setContextCounter(this._contextCounter);
            wOSession._setRequestCounter(this._requestCounter);
            wOSession._setAllowedToViewStatistics(this._allowedToViewStatistics);
            wOSession._setAllowedToViewEvents(this._allowedToViewEvents);
            wOSession.setLanguages(this._languages);
            wOSession.setTimeOut(this.timeOut());
            wOSession._setContext(this._currentContext);
            wOSession.setDistributionEnabled(this._distributionEnabled);
            wOSession.setStoresIDsInURLs(this._URLRVEnabled);
            wOSession.setStoresIDsInCookies(this._cookieRVEnabled);
        }
        catch (Exception exception) {
            NSLog.err.appendln((Object)("<" + this.getClass().getName() + ".clone()> Exception occurred  :" + exception.getMessage()));
            if (NSLog.debugLoggingAllowedForLevelAndGroups((int)1, (long)4L)) {
                NSLog.debug.appendln((Throwable)exception);
            }
            throw NSForwardException._runtimeExceptionForThrowable((Throwable)exception);
        }
        return wOSession;
    }

    public String toString() {
        return "<" + this.getClass().getName() + " sessionID=" + this._sessionID + " timeOut(sec)=" + (double)this._timeOut / 1000.0 + " terminating=" + this._terminating + "_wasTimedOut" + this._wasTimedOut + " contextArray=" + (this._contextArrayStack == null ? "null" : this._contextArrayStack.toString()) + " contextPageInfos=" + (this._contextRecords == null ? "null" : this._contextRecords.toString()) + " languages=" + (this._languages == null ? "null" : this._languages.toString()) + " componentState=" + (this._componentState == null ? "null" : this._componentState.toString()) + " currentContextID=" + (this._currentContext == null ? "null" : this._currentContext.contextID()) + " distributionEnabled=" + this._distributionEnabled + " cookieRendezVousEnabled=" + this._cookieRVEnabled + " URLRendezVousEnabled=" + this._URLRVEnabled + ">";
    }

    public String sessionID() {
        return this._sessionID;
    }

    public void _setSessionID(String string) {
        this._sessionID = string;
    }

    public void setDistributionEnabled(boolean bl) {
        if (bl != this._distributionEnabled) {
            this._distributionEnabled = bl;
            if (this._currentContext != null) {
                this._currentContext._synchronizeForDistribution();
            }
        }
    }

    public boolean isDistributionEnabled() {
        return this._distributionEnabled;
    }

    public void setStoresIDsInCookies(boolean bl) {
        if (bl != this._cookieRVEnabled) {
            this._cookieRVEnabled = bl;
        }
    }

    public boolean storesIDsInCookies() {
        return this._cookieRVEnabled;
    }

    public NSTimestamp expirationDateForIDCookies() {
        return null;
    }

    public int timeOutForIDCookies() {
        NSTimestamp nSTimestamp = this.expirationDateForIDCookies();
        if (nSTimestamp == null) {
            return -1;
        }
        return (int)nSTimestamp.timeIntervalSinceNow();
    }

    public void setStoresIDsInURLs(boolean bl) {
        if (bl != this._URLRVEnabled) {
            this._URLRVEnabled = bl;
            if (this._currentContext != null) {
                this._currentContext._synchronizeForDistribution();
            }
        }
    }

    public boolean storesIDsInURLs() {
        return this._URLRVEnabled;
    }

    private synchronized void _initRendezVousCookiePath() {
        WORequest wORequest = this._currentContext.request();
        StringBuffer stringBuffer = new StringBuffer(128);
        if (wORequest != null) {
            stringBuffer.append(wORequest.adaptorPrefix());
            stringBuffer.append('/');
            stringBuffer.append(wORequest.applicationName());
            stringBuffer.append(".woa");
        }
        TheRendezVousCookiePath = new String(stringBuffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String domainForIDCookies() {
        Object var1_1 = null;
        WOApplication wOApplication = null;
        if (TheRendezVousCookiePath != null) {
            return TheRendezVousCookiePath;
        }
        WOApplication wOApplication2 = wOApplication = WOApplication.application();
        synchronized (wOApplication2) {
            if (TheRendezVousCookiePath != null) {
                return TheRendezVousCookiePath;
            }
            this._initRendezVousCookiePath();
        }
        return TheRendezVousCookiePath;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this._finishInitializingSession(WOApplication.application(), 0L);
    }

    private void _setContextArrayStack(NSArray nSArray) {
        this._contextArrayStack = nSArray.mutableClone();
    }

    private void _setContextRecords(NSDictionary nSDictionary) {
        this._contextRecords = nSDictionary.mutableClone();
    }

    private void _setComponentState(NSDictionary nSDictionary) {
        this._componentState = nSDictionary.mutableClone();
    }

    private void _setBirthDate(NSTimestamp nSTimestamp) {
        this._birthDate = nSTimestamp;
    }

    private void _setStats(NSArray nSArray) {
        this._stats = nSArray.mutableClone();
    }

    private void _setFormattedStats(String string) {
        this._formattedStats = new StringBuffer(string);
    }

    private void _setContextCounter(int n) {
        this._contextCounter = n;
    }

    private void _setRequestCounter(int n) {
        this._requestCounter = n;
    }

    private void _setAllowedToViewStatistics(boolean bl) {
        this._allowedToViewStatistics = bl;
    }

    private void _setAllowedToViewEvents(boolean bl) {
        this._allowedToViewEvents = bl;
    }

    public void _setHttpSession(Object object) {
        this._httpSession = object;
    }

    public void _setHttpSessionWatcher(Object object) {
        this._httpSessionWatcher = object;
    }

    public void _terminateByTimeout() {
        this._wasTimedOut = true;
        this.terminate();
    }

    public void _terminateByJ2EE() {
        this._wasJ2EETerminated = true;
        this.terminate();
    }

    public void terminate() {
        if (!this._terminating) {
            this._terminating = true;
            NSNotificationCenter.defaultCenter().postNotification(SessionDidTimeOutNotification, (Object)this.sessionID());
            WOApplication wOApplication = WOApplication.application();
            wOApplication._discountTerminatedSession();
            WOStatisticsStore wOStatisticsStore = wOApplication.statisticsStore();
            if (wOStatisticsStore != null) {
                wOStatisticsStore._sessionTerminating(this);
            }
            if (!this._wasJ2EETerminated) {
                try {
                    if (this._httpSessionWatcher != null) {
                        new NSSelector("_clearWOSession").invoke(this._httpSessionWatcher);
                    }
                    if (this._httpSession != null) {
                        new NSSelector("invalidate").invoke(this._httpSession);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        this._terminating = true;
    }

    public boolean isTerminating() {
        return this._terminating;
    }

    public void setTimeOut(double d) {
        this._timeOut = d != 0.0 ? (long)(d * 1000.0) : NSTimestamp.DistantFuture.getTime() - this._birthDate.getTime();
    }

    public double timeOut() {
        return (double)this._timeOut / 1000.0;
    }

    public long timeOutMillis() {
        return this._timeOut;
    }

    public void savePageInPermanentCache(WOComponent wOComponent) {
        WOContext wOContext = this.context();
        String string = wOContext.contextID();
        NSMutableDictionary nSMutableDictionary = this._permanentPageCache();
        int n = WOApplication.application().permanentPageCacheSize();
        while (this._permanentContextIDArray.count() >= n) {
            String string2 = (String)this._permanentContextIDArray.objectAtIndex(0);
            nSMutableDictionary.removeObjectForKey((Object)string2);
            this._permanentContextIDArray.removeObjectAtIndex(0);
        }
        nSMutableDictionary.setObjectForKey((Object)wOComponent, (Object)string);
        this._permanentContextIDArray.addObject((Object)string);
    }

    public WOComponent restorePageForContextID(String string) {
        WOTransactionRecord wOTransactionRecord;
        WOComponent wOComponent = null;
        if (this._contextRecords != null && (wOTransactionRecord = (WOTransactionRecord)this._contextRecords.objectForKey((Object)string)) != null) {
            wOComponent = wOTransactionRecord.responsePage();
        }
        if (wOComponent != null && this._contextArrayStack != null) {
            int n = 0;
            int n2 = 0;
            int[] nArray = this._contextArrayForContextID(string);
            n = nArray[0];
            n2 = nArray[1];
            if (n != -1) {
                NSMutableArray nSMutableArray = (NSMutableArray)this._contextArrayStack.objectAtIndex(n);
                if (n != this._contextArrayStack.count() - 1) {
                    this._contextArrayStack.removeObjectAtIndex(n);
                    this._contextArrayStack.addObject((Object)nSMutableArray);
                }
            }
        }
        if (wOComponent == null) {
            wOComponent = this._permanentPageWithContextID(string);
        }
        if (wOComponent != null) {
            wOComponent._awakeInContext(this._currentContext);
        }
        return wOComponent;
    }

    public void _awakeInContext(WOContext wOContext) {
        this._setContext(wOContext);
        ++this._contextCounter;
        ++this._requestCounter;
        if (this._editingContext != null && !this._hasSessionLockedEditingContext && WOApplication.application()._lockDefaultEditingContext()) {
            this._editingContext.lock();
            this._hasSessionLockedEditingContext = true;
        }
        this.awake();
    }

    public void _sleepInContext(WOContext wOContext) {
        this.sleep();
        if (this.isTerminating() && this._editingContext != null) {
            this._editingContext.dispose();
            this._editingContext = null;
        }
        if (this._hasSessionLockedEditingContext) {
            if (this._editingContext != null) {
                this._editingContext.unlock();
            }
            this._hasSessionLockedEditingContext = false;
        }
        this._setContext(null);
    }

    public void _setContext(WOContext wOContext) {
        if (wOContext != this._currentContext) {
            this._currentContext = wOContext;
        }
    }

    public int _contextCounter() {
        return this._contextCounter;
    }

    protected void _contextDidIncrementContextID() {
        ++this._contextCounter;
    }

    public int _requestCounter() {
        return this._requestCounter;
    }

    public void _saveCurrentPage() {
        WOComponent wOComponent;
        if (this._currentContext != null && (wOComponent = this._currentContext._pageComponent()) != null && wOComponent._isPage()) {
            WOComponent wOComponent2 = this._permanentPageWithContextID(this._currentContext._requestContextID());
            WOComponent wOComponent3 = this._permanentPageWithContextID(this._currentContext.contextID());
            if (wOComponent3 != wOComponent) {
                WOApplication wOApplication = WOApplication.application();
                if (wOComponent2 == wOComponent && wOApplication.permanentPageCacheSize() != 0) {
                    if (this._shouldPutInPermanentCache(wOComponent)) {
                        this.savePageInPermanentCache(wOComponent);
                    }
                } else if (wOApplication.pageCacheSize() != 0) {
                    this.savePage(wOComponent);
                }
            }
        }
    }

    private boolean _shouldPutInPermanentCache(WOComponent wOComponent) {
        boolean bl = true;
        if (_PermanentCacheSingleton.class.isInstance(wOComponent)) {
            bl = false;
        } else {
            NSArray nSArray = wOComponent._subcomponents();
            if (nSArray != NSArray.EmptyArray) {
                Enumeration enumeration = nSArray.objectEnumerator();
                while (bl && enumeration.hasMoreElements()) {
                    if (this._shouldPutInPermanentCache((WOComponent)enumeration.nextElement())) continue;
                    bl = false;
                }
            }
        }
        return bl;
    }

    public void savePage(WOComponent wOComponent) {
        Object object;
        boolean bl = this._currentContext._pageChanged();
        WOApplication wOApplication = WOApplication.application();
        String string = this._currentContext.contextID();
        NSMutableArray nSMutableArray = null;
        boolean bl2 = false;
        if (this._contextArrayStack == null) {
            this._contextArrayStack = new NSMutableArray(64);
            this._contextRecords = new NSMutableDictionary(64);
        } else {
            nSMutableArray = (NSMutableArray)this._contextArrayStack.lastObject();
            this._rearrangeContextArrayStack(string);
        }
        if (bl || nSMutableArray == null) {
            bl2 = true;
        } else if (nSMutableArray.count() > 0) {
            String string2 = (String)nSMutableArray.lastObject();
            object = (WOTransactionRecord)this._contextRecords.objectForKey((Object)string2);
            WOComponent wOComponent2 = null;
            if (object != null) {
                wOComponent2 = ((WOTransactionRecord)object).responsePage();
            }
            bl2 = wOComponent2 != wOComponent;
        }
        if (bl2) {
            nSMutableArray = new NSMutableArray(64);
            this._contextArrayStack.addObject((Object)nSMutableArray);
        }
        WOTransactionRecord wOTransactionRecord = this._currentContext.response() != null && this._currentContext.response()._isClientCachingDisabled() ? new WOTransactionRecord(wOComponent, this._currentContext) : new WOTransactionRecord(wOComponent, null);
        this._contextRecords.setObjectForKey((Object)wOTransactionRecord, (Object)string);
        nSMutableArray.addObject((Object)string);
        int n = wOApplication.pageCacheSize();
        while (nSMutableArray.count() > n) {
            object = (String)nSMutableArray.objectAtIndex(0);
            this._contextRecords.removeObjectForKey(object);
            nSMutableArray.removeObjectAtIndex(0);
        }
        if (nSMutableArray.count() == 0) {
            this._contextArrayStack.removeObjectAtIndex(this._contextArrayStack.count() - 1);
        }
        while (this._contextArrayStack.count() > n) {
            object = (NSMutableArray)this._contextArrayStack.objectAtIndex(0);
            int n2 = object.count();
            for (int i = 0; i < n2; ++i) {
                String string3 = (String)object.objectAtIndex(0);
                this._contextRecords.removeObjectForKey((Object)string3);
            }
            this._contextArrayStack.removeObjectAtIndex(0);
        }
    }

    private int[] _contextArrayForContextID(String string) {
        int[] nArray = new int[2];
        int n = this._contextArrayStack.count();
        for (int i = n - 1; i >= 0; --i) {
            NSMutableArray nSMutableArray = (NSMutableArray)this._contextArrayStack.objectAtIndex(i);
            int n2 = nSMutableArray.indexOfObject((Object)string);
            if (n2 == -1) continue;
            nArray[0] = i;
            nArray[1] = n2;
            return nArray;
        }
        nArray[0] = -1;
        nArray[1] = -1;
        return nArray;
    }

    private void _rearrangeContextArrayStack(String string) {
        if (this._contextRecords != null) {
            int[] nArray = this._contextArrayForContextID(string);
            int n = nArray[0];
            int n2 = nArray[1];
            if (n != -1) {
                NSMutableArray nSMutableArray = (NSMutableArray)this._contextArrayStack.objectAtIndex(n);
                if (this._contextArrayStack.count() - 1 != n || nSMutableArray.count() - 1 != n2) {
                    this._contextArrayStack.removeObjectAtIndex(n);
                    this._contextArrayStack.addObject((Object)nSMutableArray);
                }
            }
        }
    }

    public String _contextIDMatchingIDs(WOContext wOContext) {
        Object object = null;
        if (this._contextRecords != null && wOContext._requestContextID() != null) {
            NSArray nSArray = this._contextRecords.allKeys();
            int n = nSArray.count();
            for (int i = 0; i < n; ++i) {
                object = nSArray.objectAtIndex(i);
                if (!((WOTransactionRecord)this._contextRecords.objectForKey(object)).isMatchingIDs(wOContext)) continue;
                return (String)object;
            }
        }
        return null;
    }

    public void setLanguages(NSArray nSArray) {
        if (nSArray != this._languages) {
            this._languages = nSArray != null ? (NSArray)nSArray.clone() : null;
        }
    }

    public NSArray languages() {
        WORequest wORequest;
        if (this._languages == null && this._currentContext != null && (wORequest = this._currentContext.request()) != null) {
            this.setLanguages(wORequest.browserLanguages());
        }
        return this._languages;
    }

    public void setObjectForKey(Object object, String string) {
        if (this._componentState == null) {
            this._componentState = new NSMutableDictionary();
        }
        this._componentState.setObjectForKey(object, (Object)string);
    }

    public Object objectForKey(String string) {
        if (this._componentState == null) {
            return null;
        }
        return this._componentState.objectForKey((Object)string);
    }

    public Enumeration _keyEnumerator() {
        if (this._componentState == null) {
            return null;
        }
        return this._componentState.keyEnumerator();
    }

    public void removeObjectForKey(String string) {
        if (this._componentState == null) {
            return;
        }
        this._componentState.removeObjectForKey((Object)string);
    }

    public WOContext context() {
        if (this._currentContext == null) {
            WOApplication.application().debugString(this.getClass().getName() + ".context() evaluates to null. You may be trying to get the context object from an archived session object. there is no context object outside of the request-response loop.");
        }
        return this._currentContext;
    }

    public void awake() {
    }

    public void takeValuesFromRequest(WORequest wORequest, WOContext wOContext) {
        WOElement wOElement = wOContext._pageElement();
        WOComponent wOComponent = wOContext._pageComponent();
        wOContext._setCurrentComponent(wOComponent);
        wOElement.takeValuesFromRequest(wORequest, wOContext);
        wOContext._setCurrentComponent(null);
    }

    public WOActionResults invokeAction(WORequest wORequest, WOContext wOContext) {
        WOElement wOElement = wOContext._pageElement();
        WOComponent wOComponent = wOContext._pageComponent();
        wOContext._setCurrentComponent(wOComponent);
        WOActionResults wOActionResults = wOElement.invokeAction(wORequest, wOContext);
        wOContext._setCurrentComponent(null);
        return wOActionResults;
    }

    public void appendToResponse(WOResponse wOResponse, WOContext wOContext) {
        WOStatisticsStore wOStatisticsStore = WOApplication.application().statisticsStore();
        WOElement wOElement = wOContext._pageElement();
        WOComponent wOComponent = wOContext._pageComponent();
        wOContext._setCurrentComponent(wOComponent);
        wOElement.appendToResponse(wOResponse, wOContext);
        wOContext._setCurrentComponent(null);
        this._appendCookieToResponse(wOResponse);
        if (wOStatisticsStore != null) {
            String string;
            wOStatisticsStore.recordStatisticsForResponse(wOResponse, wOContext);
            int n = wOStatisticsStore._statisticStoreSessionMax();
            if (this._stats.count() < n && (string = wOStatisticsStore.descriptionForResponse(wOResponse, wOContext)) != null) {
                String string2;
                this._stats.addObject((Object)string);
                if (wOStatisticsStore.logFile() != null && (string2 = wOStatisticsStore.formatDescription(string, wOResponse, wOContext)) != null) {
                    if (this._formattedStats == null) {
                        this._formattedStats = new StringBuffer(1024);
                    }
                    this._formattedStats.append(string2);
                }
            }
        }
    }

    public void sleep() {
    }

    public NSArray statistics() {
        return this._stats;
    }

    protected NSTimestamp _birthDate() {
        return this._birthDate;
    }

    protected long _lifeInMillis() {
        long l = System.currentTimeMillis();
        long l2 = l - this._birthDate().getTime() - (this._wasTimedOut ? this.timeOutMillis() : 0L);
        return l2;
    }

    protected String _formattedStatistics() {
        String string = null;
        if (this._formattedStats != null) {
            string = this._formattedStats.toString();
        }
        return string;
    }

    protected void _allowToViewStatistics() {
        this._allowedToViewStatistics = true;
    }

    public boolean allowedToViewStatistics() {
        return this._allowedToViewStatistics;
    }

    public void validateStatisticsLogin(String string, String string2) {
        String string3;
        WOStatisticsStore wOStatisticsStore = WOApplication.application().statisticsStore();
        if (wOStatisticsStore != null && (string3 = wOStatisticsStore._password()) != null && string3.equals(string == null ? "" : string)) {
            this._allowToViewStatistics();
        }
    }

    public void validationFailedWithException(Throwable throwable, Object object, String string, WOComponent wOComponent) {
        WOApplication.application().validationFailedWithException(throwable, object, string, wOComponent, this);
    }

    protected void _allowToViewEvents() {
        this._allowedToViewEvents = true;
    }

    public boolean allowedToViewEvents() {
        return this._allowedToViewEvents;
    }

    public void validateEventsLogin(String string, String string2) {
        String string3 = EOEventCenter.password();
        if (string3 != null && string3.equals(string == null ? "" : string)) {
            this._allowToViewEvents();
        }
    }

    public void _appendCookieToResponse(WOResponse wOResponse) {
        if (this.storesIDsInCookies()) {
            NSKeyValueCodingAdditions nSKeyValueCodingAdditions;
            String string;
            String string2 = this.domainForIDCookies();
            int n = this.isTerminating() ? 0 : this.timeOutForIDCookies();
            NSTimestamp nSTimestamp = this.isTerminating() ? new NSTimestamp().timestampByAddingGregorianUnits(0, -1, 0, 0, 0, 0) : null;
            String string3 = this.isTerminating() ? "" : this.sessionID();
            WOCookie wOCookie = new WOCookie("wosid", string3, string2, null, n, false);
            wOCookie.setExpires(nSTimestamp);
            wOResponse.addCookie(wOCookie);
            if (this.isDistributionEnabled() || this.isTerminating()) {
                string = "-1";
                n = 0;
            } else {
                nSKeyValueCodingAdditions = this._currentContext.request();
                int n2 = nSKeyValueCodingAdditions != null ? nSKeyValueCodingAdditions.applicationNumber() : -1;
                string = n2 == -1 ? "-1" : WOShared.unsignedIntString(n2);
            }
            nSKeyValueCodingAdditions = new WOCookie("woinst", string, string2, null, n, false);
            wOResponse.addCookie((WOCookie)nSKeyValueCodingAdditions);
        }
    }

    public void _clearCookieFromResponse(WOResponse wOResponse) {
        String string = this.domainForIDCookies();
        NSTimestamp nSTimestamp = new NSTimestamp();
        NSTimestamp nSTimestamp2 = nSTimestamp.timestampByAddingGregorianUnits(0, -1, 0, 0, 0, 0);
        WOCookie wOCookie = new WOCookie("wosid", this.sessionID(), string, null, nSTimestamp2, false);
        wOResponse.addCookie(wOCookie);
        WOCookie wOCookie2 = new WOCookie("woinst", "-1", string, null, nSTimestamp2, false);
        wOResponse.addCookie(wOCookie2);
    }

    public static void logString(String string) {
        WOApplication.application().logString(string);
    }

    public static void debugString(String string) {
        WOApplication.application().debugString(string);
    }

    private NSMutableDictionary _permanentPageCache() {
        if (this._permanentPageCache == null) {
            this._permanentPageCache = new NSMutableDictionary(64);
            this._permanentContextIDArray = new NSMutableArray(64);
        }
        return this._permanentPageCache;
    }

    private WOComponent _permanentPageWithContextID(String string) {
        WOComponent wOComponent = null;
        if (this._permanentPageCache != null) {
            wOComponent = (WOComponent)this._permanentPageCache.objectForKey((Object)string);
        }
        return wOComponent;
    }

    public EOEditingContext defaultEditingContext() {
        if (this._editingContext == null) {
            this._editingContext = new EOEditingContext();
            this._editingContext.undoManager().setLevelsOfUndo(WOApplication.application().defaultUndoStackLimit().intValue());
            if (WOApplication.application()._lockDefaultEditingContext()) {
                this._editingContext.lock();
                this._hasSessionLockedEditingContext = true;
            }
        }
        return this._editingContext;
    }

    public void setDefaultEditingContext(EOEditingContext eOEditingContext) {
        if (this._editingContext != null) {
            throw new IllegalStateException("<" + this.getClass().getName() + "> Cannot use-setDefaultEditingContext() once the defaultEditingContext exists.");
        }
        this._editingContext = eOEditingContext;
        if (WOApplication.application()._lockDefaultEditingContext()) {
            this._editingContext.lock();
            this._hasSessionLockedEditingContext = true;
        }
    }

    public static boolean canAccessFieldsDirectly() {
        return true;
    }

    public Object valueForKey(String string) {
        return NSKeyValueCoding.DefaultImplementation.valueForKey((Object)this, (String)string);
    }

    public void takeValueForKey(Object object, String string) {
        NSKeyValueCoding.DefaultImplementation.takeValueForKey((Object)this, (Object)object, (String)string);
    }

    public Object handleQueryWithUnboundKey(String string) {
        return NSKeyValueCoding.DefaultImplementation.handleQueryWithUnboundKey((Object)this, (String)string);
    }

    public void handleTakeValueForUnboundKey(Object object, String string) {
        NSKeyValueCoding.DefaultImplementation.handleTakeValueForUnboundKey((Object)this, (Object)object, (String)string);
    }

    public void unableToSetNullForKey(String string) {
        NSKeyValueCoding.DefaultImplementation.unableToSetNullForKey((Object)this, (String)string);
    }

    public Object valueForKeyPath(String string) {
        return NSKeyValueCodingAdditions.DefaultImplementation.valueForKeyPath((Object)this, (String)string);
    }

    public void takeValueForKeyPath(Object object, String string) {
        NSKeyValueCodingAdditions.DefaultImplementation.takeValueForKeyPath((Object)this, (Object)object, (String)string);
    }

    static {
        EOEditingContext.setUsesContextRelativeEncoding((boolean)true);
        TheRendezVousCookiePath = null;
    }
}

