/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.appserver;

import com.webobjects.appserver.WOContext;
import com.webobjects.appserver.WORequest;
import com.webobjects.appserver.WOSession;
import com.webobjects.appserver._private.WOServerSessionStore;
import com.webobjects.foundation.NSLog;
import com.webobjects.foundation.NSMutableDictionary;
import com.webobjects.foundation.NSProperties;
import com.webobjects.foundation._NSThreadsafeMutableDictionary;
import java.util.Enumeration;

public abstract class WOSessionStore {
    private final _NSThreadsafeMutableDictionary _timeoutEntries = new _NSThreadsafeMutableDictionary(new NSMutableDictionary(512));
    protected final _SessionTimeoutManager _timeoutManager;

    public WOSessionStore() {
        int n;
        try {
            n = Integer.parseInt(NSProperties.getProperty((String)"_WOSessionReclaimingInterval"));
        }
        catch (NumberFormatException numberFormatException) {
            NSLog.err.appendln((Object)"The property _WOSessionReclaimingInterval takes a numerical argument. Defaulting to 60 secconds.");
            n = 60;
        }
        this._timeoutManager = new _SessionTimeoutManager(n);
        Thread thread = new Thread((Runnable)this._timeoutManager, "Session Timeout Thread");
        thread.setDaemon(true);
        thread.start();
    }

    public void finalize() throws Throwable {
        this._timeoutManager.terminate();
        super.finalize();
    }

    private TimeoutEntry timeoutEntryForSession(String string) {
        TimeoutEntry timeoutEntry = (TimeoutEntry)this._timeoutEntries.objectForKey((Object)string);
        if (timeoutEntry == null) {
            timeoutEntry = new TimeoutEntry(string);
            this._timeoutEntries.setObjectForKey((Object)timeoutEntry, (Object)string);
        }
        return timeoutEntry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final WOSession checkOutSessionWithID(String string, WORequest wORequest) {
        TimeoutEntry timeoutEntry;
        WOSession wOSession = this.restoreSessionWithID(string, wORequest);
        if (wOSession == null) {
            return null;
        }
        TimeoutEntry timeoutEntry2 = timeoutEntry = this.timeoutEntryForSession(string);
        synchronized (timeoutEntry2) {
            while (timeoutEntry.checkedOut) {
                timeoutEntry.waitingThreads = (short)(timeoutEntry.waitingThreads + 1);
                try {
                    timeoutEntry.wait();
                    if (timeoutEntry.expiryTime == 0) {
                        return null;
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                timeoutEntry.waitingThreads = (short)(timeoutEntry.waitingThreads - 1);
            }
            timeoutEntry.checkedOut = true;
            timeoutEntry.expiryTime = Integer.MAX_VALUE;
        }
        return wOSession;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void checkInSessionForContext(WOContext wOContext) {
        int n;
        WOSession wOSession = wOContext._session();
        if (wOSession == null) {
            throw new IllegalStateException(this.toString() + ": Cannot save session because the current context has no session.");
        }
        boolean bl = wOSession.isTerminating();
        wOSession.setDistributionEnabled(bl);
        String string = wOSession.sessionID();
        TimeoutEntry timeoutEntry = this.timeoutEntryForSession(string);
        if (bl) {
            this.removeSessionWithID(string);
            n = 0;
        } else {
            this.saveSessionForContext(wOContext);
            n = (int)((this.now() + wOSession.timeOutMillis()) / 1000L);
        }
        TimeoutEntry timeoutEntry2 = timeoutEntry;
        synchronized (timeoutEntry2) {
            timeoutEntry.checkedOut = false;
            timeoutEntry.expiryTime = n;
            if (timeoutEntry.waitingThreads > 0) {
                timeoutEntry.notify();
            }
        }
    }

    private long now() {
        return System.currentTimeMillis();
    }

    public abstract WOSession removeSessionWithID(String var1);

    public abstract WOSession restoreSessionWithID(String var1, WORequest var2);

    public abstract void saveSessionForContext(WOContext var1);

    public static WOSessionStore serverSessionStore() {
        return new WOServerSessionStore();
    }

    protected class _SessionTimeoutManager
    implements Runnable {
        private volatile boolean inAction;
        private final int _interval;

        _SessionTimeoutManager(int n) {
            this._interval = n * 1000;
            this.inAction = true;
        }

        public void terminate() {
            this.inAction = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (this.inAction) {
                try {
                    Thread.currentThread();
                    Thread.sleep(this._interval);
                    long l = System.currentTimeMillis();
                    int n = (int)(l / 1000L);
                    Enumeration enumeration = WOSessionStore.this._timeoutEntries.objectEnumerator();
                    while (enumeration.hasMoreElements()) {
                        TimeoutEntry timeoutEntry = (TimeoutEntry)enumeration.nextElement();
                        if (timeoutEntry == null || timeoutEntry.expiryTime >= n) continue;
                        TimeoutEntry timeoutEntry2 = timeoutEntry;
                        synchronized (timeoutEntry2) {
                            if (timeoutEntry.expiryTime < n) {
                                String string = timeoutEntry.sessionID;
                                WOSession wOSession = WOSessionStore.this.removeSessionWithID(string);
                                WOSessionStore.this._timeoutEntries.removeObjectForKey((Object)string);
                                if (wOSession != null) {
                                    wOSession._terminateByTimeout();
                                }
                            }
                        }
                    }
                }
                catch (Throwable throwable) {
                    NSLog._conditionallyLogPrivateException((Throwable)throwable);
                }
            }
        }
    }

    private static class TimeoutEntry {
        final String sessionID;
        volatile int expiryTime;
        boolean checkedOut;
        short waitingThreads;

        TimeoutEntry(String string) {
            this.sessionID = string;
            this.expiryTime = Integer.MAX_VALUE;
        }
    }
}

