/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.appserver;

import com.webobjects.appserver.WOTimer;
import com.webobjects.foundation.NSLog;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSTimestamp;

public class _WORunLoop {
    NSMutableArray _timers = new NSMutableArray(8);
    long _nextIntervalDate = 0L;
    boolean _hasIntervalDate = false;
    public static final long _LimitWaitInterval = 55555000L;
    private static _WORunLoop _currentRunLoop = new _WORunLoop();

    public static _WORunLoop currentRunLoop() {
        return _currentRunLoop;
    }

    private _WORunLoop() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTimer(WOTimer wOTimer) {
        if (!wOTimer.isValid()) {
            return;
        }
        NSMutableArray nSMutableArray = this._timers;
        synchronized (nSMutableArray) {
            this._insertTimer(wOTimer);
            long l = wOTimer.fireDate().getTime();
            if (!this._hasIntervalDate || l < this._nextIntervalDate) {
                this._nextIntervalDate = l;
                this._hasIntervalDate = true;
            }
        }
        this._notify();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeTimer(WOTimer wOTimer) {
        NSMutableArray nSMutableArray = this._timers;
        synchronized (nSMutableArray) {
            this._timers.removeObject((Object)wOTimer);
            this._hasIntervalDate = false;
            this._nextTimerInterval();
        }
        this._notify();
    }

    public synchronized boolean runBeforeDate(NSTimestamp nSTimestamp) {
        long l;
        this._notify();
        NSTimestamp nSTimestamp2 = this._limitDate();
        if (nSTimestamp2 == null) {
            return false;
        }
        long l2 = nSTimestamp.getTime();
        this._acceptInputBeforeDate(l2 < (l = nSTimestamp2.getTime()) ? nSTimestamp : nSTimestamp2);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NSTimestamp _limitDate() {
        long l = 55555000L + System.currentTimeMillis();
        boolean bl = false;
        NSMutableArray nSMutableArray = this._timers;
        synchronized (nSMutableArray) {
            if (this._timers.count() != 0) {
                long l2 = this._nextTimerInterval();
                if (l2 > 0L) {
                    l = l2;
                    bl = true;
                }
            } else {
                this._hasIntervalDate = false;
            }
        }
        if (bl) {
            return new NSTimestamp(l);
        }
        return NSTimestamp.DistantFuture;
    }

    private void _insertTimer(WOTimer wOTimer) {
        WOTimer wOTimer2;
        int n;
        long l = wOTimer.fireDate().getTime();
        int n2 = this._timers.count();
        for (n = n2 - 1; n >= 0 && !(wOTimer2 = (WOTimer)this._timers.objectAtIndex(n)).equals(wOTimer); --n) {
            if (!wOTimer2.isValid() || l <= wOTimer2.fireDate().getTime()) continue;
            this._timers.insertObjectAtIndex((Object)wOTimer, n + 1);
            break;
        }
        if (n == -1) {
            this._timers.insertObjectAtIndex((Object)wOTimer, 0);
        }
    }

    private long _nextTimerInterval() {
        long l = 0L;
        boolean bl = false;
        long l2 = 0L;
        int n = 0;
        if (this._hasIntervalDate) {
            l = System.currentTimeMillis();
            bl = true;
            if (this._nextIntervalDate > l) {
                l2 = this._nextIntervalDate;
                return l2;
            }
        }
        n = this._timers.count();
        this._hasIntervalDate = false;
        for (int i = 0; i < n; ++i) {
            long l3;
            WOTimer wOTimer = (WOTimer)this._timers.objectAtIndex(i);
            if (!wOTimer.isValid()) {
                this._timers.removeObjectAtIndex(i);
                --i;
                n = this._timers.count();
                continue;
            }
            if (!bl) {
                l = System.currentTimeMillis();
                bl = true;
            }
            if ((l3 = wOTimer.fireDate().getTime()) > l) {
                if (this._hasIntervalDate && (!this._hasIntervalDate || l3 >= this._nextIntervalDate)) break;
                this._nextIntervalDate = l3;
                this._hasIntervalDate = true;
                break;
            }
            this._timers.removeObjectAtIndex(i);
            wOTimer.fire();
            if (wOTimer.isValid()) {
                this._insertTimer(wOTimer);
            }
            i = -1;
            n = this._timers.count();
            this._hasIntervalDate = false;
        }
        if (this._hasIntervalDate) {
            l2 = this._nextIntervalDate;
        }
        return l2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _acceptInputBeforeDate(NSTimestamp nSTimestamp) {
        block9: {
            long l = 55555000L;
            boolean bl = false;
            long l2 = System.currentTimeMillis();
            if (nSTimestamp == NSTimestamp.DistantFuture) {
                bl = true;
            } else {
                l = nSTimestamp.getTime() - l2;
            }
            NSMutableArray nSMutableArray = this._timers;
            synchronized (nSMutableArray) {
                if (this._hasIntervalDate && (bl || this._nextIntervalDate - l2 < l)) {
                    l = this._nextIntervalDate - l2;
                    bl = false;
                }
            }
            try {
                if (l > 0L) {
                    this.wait(l);
                }
            }
            catch (Exception exception) {
                NSLog.err.appendln((Object)("<" + this.getClass().getName() + " Ignoring  " + exception.getClass().getName()));
                if (!NSLog.debugLoggingAllowedForLevelAndGroups((int)1, (long)20L)) break block9;
                NSLog.debug.appendln((Throwable)exception);
            }
        }
    }

    private synchronized void _notify() {
        this.notify();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<");
        stringBuffer.append(this.getClass().getName());
        stringBuffer.append(" timers=" + this._timers);
        stringBuffer.append(" nextIntervalDate=" + this._nextIntervalDate);
        stringBuffer.append(" hasIntervalDate=" + this._hasIntervalDate);
        stringBuffer.append(">");
        return stringBuffer.toString();
    }
}

