/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.appserver._private;

import com.webobjects.appserver.WOAssociation;
import com.webobjects.appserver.WOComponent;

public class WOConstantValueAssociation
extends WOAssociation
implements Cloneable {
    private Object _value;
    private boolean _needToCacheBoolean;
    private boolean _booleanValue;
    public static final WOConstantValueAssociation TRUE = new WOConstantValueAssociation(Boolean.TRUE);
    public static final WOConstantValueAssociation FALSE = new WOConstantValueAssociation(Boolean.FALSE);

    public WOConstantValueAssociation(Object object) {
        this._value = object;
        this._needToCacheBoolean = true;
    }

    public Object clone() {
        return new WOConstantValueAssociation(this._value);
    }

    public String toString() {
        return "<" + this.getClass().getName() + ": value=" + this._value + ">";
    }

    public Object valueInComponent(WOComponent wOComponent) {
        if (this._debugEnabled) {
            this._logPullValue(this._value, wOComponent);
        }
        return this._value;
    }

    public void setValue(Object object, WOComponent wOComponent) {
        throw new IllegalStateException(this.toString() + ": Cannot set value to '" + this._value + "' in component '" + wOComponent.name() + "' because value is not settable.");
    }

    public boolean isValueSettable() {
        return false;
    }

    public boolean isValueConstant() {
        return true;
    }

    protected String _debugDescription() {
        return this._value.getClass().toString();
    }

    public String keyPath() {
        return "<none>";
    }

    public String bindingInComponent(WOComponent wOComponent) {
        return this._value == null ? null : this._value.toString();
    }

    public boolean booleanValueInComponent(WOComponent wOComponent) {
        if (this._needToCacheBoolean) {
            this._booleanValue = super.booleanValueInComponent(wOComponent);
            this._needToCacheBoolean = false;
        }
        return this._booleanValue;
    }
}

