/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.appserver._private;

import com.webobjects.appserver.WOApplication;
import com.webobjects.appserver.WOResponse;
import com.webobjects.foundation.NSArray;
import java.util.Enumeration;

public class WODefaultExceptions {
    public static final WOResponse defaultWOSessionCreationError(Exception exception) {
        WOResponse wOResponse = WOApplication.application().createResponseInContext(null);
        wOResponse.setHeader("text/html", "content-type");
        wOResponse.appendContentString("<html>\n<head><title>Session Creation Error</title></head>\n<body>\n<hr>\n<strong>\nYour session could not be created.</strong>\n<hr>\n</body>\n</html>\n");
        return wOResponse;
    }

    public static final WOResponse defaultWOSessionRestorationError(Exception exception) {
        WOResponse wOResponse = WOApplication.application().createResponseInContext(null);
        wOResponse.setHeader("text/html", "content-type");
        wOResponse.appendContentString("<html>\n<head><title>Missing Session Error</title></head>\n<body>\n<hr>\n<strong>\nYour session has timed out.</strong>\n<hr>\n</body>\n</html>\n");
        return wOResponse;
    }

    public static final WOResponse defaultWOPageRestorationError(Exception exception) {
        WOResponse wOResponse = WOApplication.application().createResponseInContext(null);
        wOResponse.setHeader("text/html", "content-type");
        wOResponse.appendContentString("<html>\n<html>\n<head><title>Missing Page Error</title></head>\n<body>\n<hr>\n<strong>\nYou backtracked too far.\nThe application backtracking limit of" + WOApplication.application().pageCacheSize() + " has been exceeded.\n</strong>\n<hr>\n</body>\n</html>\n");
        return wOResponse;
    }

    public static final WOResponse defaultWOExceptionPage(Exception exception) {
        NSArray nSArray = NSArray.componentsSeparatedByString((String)exception.toString(), (String)"\n");
        WOResponse wOResponse = WOApplication.application().createResponseInContext(null);
        wOResponse.setHeader("text/html", "content-type");
        wOResponse.appendContentString("<html>\n<head><title>WebObjects Error</title></head>\n<body>\n<hr>\n<strong>\nApplication: ");
        wOResponse.appendContentHTMLString(WOApplication.application().name());
        wOResponse.appendContentString("<br>\nError: ");
        wOResponse.appendContentHTMLString(exception.getClass().getName());
        wOResponse.appendContentString(" exception<br>\nReason:<br>\n");
        Enumeration enumeration = nSArray.objectEnumerator();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            wOResponse.appendContentHTMLString(string);
            wOResponse.appendContentString("<br>\n");
        }
        wOResponse.appendContentString("</strong>\n<hr>\n</body>\n</html>\n");
        return wOResponse;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<");
        stringBuffer.append(this.getClass().getName());
        stringBuffer.append(">");
        return stringBuffer.toString();
    }
}

