/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.appserver._private;

import com.webobjects.foundation.NSData;
import com.webobjects.foundation.NSDisposable;
import com.webobjects.foundation.NSRange;
import com.webobjects.foundation._NSStringUtilities;

public class WOHTTPHeaderValue
implements NSDisposable {
    private byte[] buffer;
    private int offset;
    private int length;
    private char[] uppercase;
    private char[] lowercase;

    public WOHTTPHeaderValue() {
    }

    public WOHTTPHeaderValue(String string) {
        this.buffer = string.getBytes();
        this.offset = 0;
        this.length = this.buffer.length;
        this.uppercase = null;
        this.lowercase = null;
    }

    public void dispose() {
        this.buffer = null;
        this.uppercase = null;
        this.lowercase = null;
    }

    public void set(byte[] byArray, int n, int n2) {
        this.buffer = byArray;
        this.offset = n;
        this.length = n2;
        this.uppercase = null;
        this.lowercase = null;
    }

    public NSData _data() {
        return new NSData(this.buffer, new NSRange(this.offset, this.length));
    }

    protected boolean equals(WOHTTPHeaderValue wOHTTPHeaderValue) {
        return wOHTTPHeaderValue != null && this.buffer == wOHTTPHeaderValue.buffer && this.offset == wOHTTPHeaderValue.offset && this.length == wOHTTPHeaderValue.length;
    }

    public boolean equals(Object object) {
        if (object instanceof WOHTTPHeaderValue) {
            return this.equals((WOHTTPHeaderValue)object);
        }
        return false;
    }

    protected char[] uppercase() {
        if (this.uppercase == null) {
            this.uppercase = new char[this.length];
            this.lowercase = new char[this.length];
            for (int i = 0; i < this.length; ++i) {
                char c = (char)this.buffer[i + this.offset];
                char c2 = Character.toLowerCase(c);
                if (c2 == c) {
                    this.lowercase[i] = c;
                    this.uppercase[i] = Character.toUpperCase(c);
                    continue;
                }
                this.lowercase[i] = c2;
                this.uppercase[i] = c;
            }
        }
        return this.uppercase;
    }

    protected char[] lowercase() {
        if (this.lowercase == null) {
            this.uppercase();
        }
        return this.lowercase;
    }

    public boolean equalsIgnoreCase(WOHTTPHeaderValue wOHTTPHeaderValue) {
        if (wOHTTPHeaderValue == null || wOHTTPHeaderValue.length != this.length) {
            return false;
        }
        if (this.buffer == wOHTTPHeaderValue.buffer && this.offset == wOHTTPHeaderValue.offset) {
            return true;
        }
        char[] cArray = wOHTTPHeaderValue.uppercase();
        char[] cArray2 = wOHTTPHeaderValue.lowercase();
        for (int i = 0; i < this.length; ++i) {
            char c = (char)this.buffer[i + this.offset];
            if (c == cArray2[i] || c == cArray[i]) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return this.buffer == null ? null : _NSStringUtilities.stringForBytes((byte[])this.buffer, (int)this.offset, (int)this.length, (String)"ISO-8859-1");
    }

    public String description() {
        return this.buffer == null ? "<" + this.getClass().getName() + " null >" : "<" + this.getClass().getName() + " \"" + new String(this.buffer, this.offset, this.length) + "\">";
    }
}

