/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.appserver._private;

import com.webobjects.appserver._private.WOCaseInsensitiveDictionary;
import com.webobjects.appserver._private.WOHTTPHeaderValue;
import com.webobjects.appserver._private.WOLowercaseCharArray;
import com.webobjects.appserver._private.WOObjectPool;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSDisposable;
import com.webobjects.foundation.NSMutableArray;

public class WOHTTPHeadersDictionary
extends WOCaseInsensitiveDictionary
implements NSDisposable {
    static final long serialVersionUID = -4713163240630376236L;
    private static final int _TheHeadersDictionarySize = 20;
    private static final int _TheHeaderValuesMultiplier = 5;
    private static final String HighWaterHeadersSize = "WOMaxHeaders";
    private WOHTTPHeaderPool _headerPool;
    private WOHTTPHeaderValuePool _valuePool;
    private WOLowercaseCharArray _lastKey;

    public WOHTTPHeadersDictionary() {
        this(20);
    }

    public WOHTTPHeadersDictionary(int n) {
        super(n);
        this._headerPool = new WOHTTPHeaderPool(n);
        this._valuePool = new WOHTTPHeaderValuePool(n * 5);
        this._lastKey = null;
    }

    public void dispose() {
        this.removeAllObjects();
        this._headerPool.dispose();
        this._valuePool.dispose();
        this._lastKey = null;
    }

    public WOHTTPHeaderValue setBufferForKey(byte[] byArray, int n, int n2, int n3, int n4) {
        WOHTTPHeaderValue wOHTTPHeaderValue = (WOHTTPHeaderValue)this._valuePool.nextInstance();
        wOHTTPHeaderValue.set(byArray, n, n2);
        WOHTTPHeader wOHTTPHeader = (WOHTTPHeader)this._headerPool.nextInstance();
        wOHTTPHeader.key.setKeyFromBuffer(byArray, n3, n4);
        NSMutableArray nSMutableArray = (NSMutableArray)this._objectForKey(wOHTTPHeader.key, false);
        if (nSMutableArray != null) {
            nSMutableArray.addObject((Object)wOHTTPHeaderValue);
            this._headerPool.freeLastInstance();
        } else {
            wOHTTPHeader.values.addObject((Object)wOHTTPHeaderValue);
            super._setObjectForKey(wOHTTPHeader.values, wOHTTPHeader.key);
        }
        this._lastKey = wOHTTPHeader.key;
        return wOHTTPHeaderValue;
    }

    public WOLowercaseCharArray lastInsertedKey() {
        return this._lastKey;
    }

    protected Object _objectForKey(Object object) {
        return this._objectForKey(object, true);
    }

    protected Object _removeObjectForKey(Object object) {
        Object object2 = super._removeObjectForKey(object);
        if (object2 instanceof WOHTTPHeader) {
            this._headerPool.freeInstance(object2);
            this._valuePool.freeInstances((NSArray)((WOHTTPHeader)object2).values);
        }
        return object2;
    }

    private Object _objectForKey(Object object, boolean bl) {
        NSMutableArray nSMutableArray;
        int n;
        Object object2 = null;
        if (object != null && (object2 = super._objectForKey(object)) != null && bl && object2 instanceof NSMutableArray && (n = (nSMutableArray = (NSMutableArray)object2).count()) > 0 && nSMutableArray.objectAtIndex(0) instanceof WOHTTPHeaderValue) {
            for (int i = 0; i < n; ++i) {
                WOHTTPHeaderValue wOHTTPHeaderValue = (WOHTTPHeaderValue)nSMutableArray.objectAtIndex(i);
                String string = wOHTTPHeaderValue.toString();
                nSMutableArray.replaceObjectAtIndex((Object)string, i);
                this._valuePool.freeInstance(wOHTTPHeaderValue);
            }
        }
        return object2;
    }

    public Object _realObjectForKey(Object object) {
        return this._objectForKey(this.caseInsensitiveWrapper(object), false);
    }

    public String toString() {
        int n = this.count();
        NSArray nSArray = this.allKeys();
        StringBuffer stringBuffer = new StringBuffer("{");
        for (int i = 0; i < n; ++i) {
            Object object = nSArray.objectAtIndex(i);
            Object object2 = super._objectForKey(this.caseInsensitiveWrapper(object));
            stringBuffer.append(object.toString());
            stringBuffer.append(" = ");
            if (object2 instanceof String) {
                stringBuffer.append("\"");
                stringBuffer.append(object2);
                stringBuffer.append("\"");
            } else {
                stringBuffer.append(object2.toString());
            }
            stringBuffer.append("; ");
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    protected class WOHTTPHeaderValuePool
    extends WOObjectPool {
        public WOHTTPHeaderValuePool(int n) {
            super(n);
        }

        public NSDisposable newInstance() {
            return new WOHTTPHeaderValue();
        }

        public String highWaterMarkPropertyKey() {
            return WOHTTPHeadersDictionary.HighWaterHeadersSize;
        }

        public int highWaterMarkSize() {
            return WOHTTPHeadersDictionary.this._headerPool.highWaterMarkSize() * 5;
        }
    }

    protected class WOHTTPHeaderPool
    extends WOObjectPool {
        public WOHTTPHeaderPool(int n) {
            super(n);
        }

        public NSDisposable newInstance() {
            return new WOHTTPHeader(new WOLowercaseCharArray(), new NSMutableArray());
        }

        public String highWaterMarkPropertyKey() {
            return WOHTTPHeadersDictionary.HighWaterHeadersSize;
        }
    }

    public static class WOHTTPHeader
    implements NSDisposable {
        protected WOLowercaseCharArray key;
        protected NSMutableArray values;

        public WOHTTPHeader(WOLowercaseCharArray wOLowercaseCharArray, NSMutableArray nSMutableArray) {
            this.key = wOLowercaseCharArray;
            this.values = nSMutableArray;
        }

        public void dispose() {
            this.values.removeAllObjects();
        }

        public String toString() {
            return "<" + this.getClass().getName() + " " + this.key + "=" + this.values + " >";
        }
    }
}

