/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.appserver._private;

import com.webobjects.appserver.WOApplication;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSLog;
import com.webobjects.foundation.NSMutableArray;
import java.net.InetAddress;

public class WOHostUtilities {
    static volatile NSArray _localHosts = null;

    private WOHostUtilities() {
    }

    static NSArray initLocalHosts() {
        InetAddress[] inetAddressArray;
        NSMutableArray nSMutableArray = new NSMutableArray();
        try {
            inetAddressArray = InetAddress.getLocalHost();
            WOHostUtilities._addInetAddress((InetAddress)inetAddressArray, nSMutableArray);
        }
        catch (Exception exception) {
            NSLog.err.appendln((Object)("<WOHostUtilities>: Couldn't invoke getLocalHost(): " + exception));
        }
        try {
            inetAddressArray = InetAddress.getAllByName("localhost");
            WOHostUtilities._addInetAddressArray(inetAddressArray, nSMutableArray);
        }
        catch (Exception exception) {
            NSLog.err.appendln((Object)("<WOHostUtilities>: Couldn't get InetAddress for 'localhost': " + exception));
        }
        try {
            inetAddressArray = InetAddress.getAllByName("127.0.0.1");
            WOHostUtilities._addInetAddressArray(inetAddressArray, nSMutableArray);
        }
        catch (Exception exception) {
            NSLog.err.appendln((Object)("<WOHostUtilities>: Couldn't get InetAddress for '127.0.0.1': " + exception));
        }
        int n = nSMutableArray.count();
        for (int i = 0; i < n; ++i) {
            InetAddress inetAddress = (InetAddress)nSMutableArray.objectAtIndex(i);
            try {
                InetAddress[] inetAddressArray2 = InetAddress.getAllByName(inetAddress.getHostName());
                WOHostUtilities._addInetAddressArray(inetAddressArray2, nSMutableArray);
                continue;
            }
            catch (Exception exception) {
                NSLog.err.appendln((Object)("<WOHostUtilities>: Couldn't get InetAddresses for '" + inetAddress.getHostName() + "': " + exception));
            }
        }
        if (NSLog.debugLoggingAllowedForLevelAndGroups((int)3, (long)4L)) {
            NSLog.out.appendln((Object)("<WOHostUtilities>: Initialized Local Host List: " + nSMutableArray));
        }
        return nSMutableArray;
    }

    static void _addInetAddressArray(InetAddress[] inetAddressArray, NSMutableArray nSMutableArray) {
        if (inetAddressArray != null) {
            for (int i = 0; i < inetAddressArray.length; ++i) {
                WOHostUtilities._addInetAddress(inetAddressArray[i], nSMutableArray);
            }
        }
    }

    static void _addInetAddress(InetAddress inetAddress, NSMutableArray nSMutableArray) {
        if (inetAddress != null && !nSMutableArray.containsObject((Object)inetAddress)) {
            nSMutableArray.addObject((Object)inetAddress);
        }
    }

    public static NSArray getLocalHosts() {
        return _localHosts;
    }

    public static boolean isLocalInetAddress(InetAddress inetAddress, boolean bl) {
        if (inetAddress != null) {
            if (WOApplication.application()._unsetHost) {
                return WOHostUtilities._isLocalInetAddress(inetAddress, bl);
            }
            return inetAddress.equals(WOApplication.application().hostAddress());
        }
        return false;
    }

    public static boolean isAnyLocalInetAddress(InetAddress inetAddress, boolean bl) {
        return WOHostUtilities._isLocalInetAddress(inetAddress, bl) || WOApplication.application().hostAddress().equals(inetAddress);
    }

    public static boolean _isLocalInetAddress(InetAddress inetAddress, boolean bl) {
        boolean bl2 = false;
        if (inetAddress != null && !(bl2 = _localHosts.containsObject((Object)inetAddress)) && bl) {
            _localHosts = WOHostUtilities.initLocalHosts();
            bl2 = _localHosts.containsObject((Object)inetAddress);
        }
        return bl2;
    }

    static {
        _localHosts = WOHostUtilities.initLocalHosts();
    }
}

