/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.appserver._private;

import com.webobjects.appserver.WOApplication;
import com.webobjects.appserver.WOMessage;
import com.webobjects.appserver.WORequest;
import com.webobjects.appserver.WOResponse;
import com.webobjects.appserver._private.WOHTTPHeaderValue;
import com.webobjects.appserver._private.WOHTTPHeadersDictionary;
import com.webobjects.appserver._private.WOInputStreamData;
import com.webobjects.appserver._private.WOLowercaseCharArray;
import com.webobjects.appserver._private.WONoCopyPushbackInputStream;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSData;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSLog;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSMutableData;
import com.webobjects.foundation.NSMutableDictionary;
import com.webobjects.foundation.NSMutableRange;
import com.webobjects.foundation.NSProperties;
import com.webobjects.foundation.NSRange;
import com.webobjects.foundation._NSStringUtilities;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketException;

public final class WOHttpIO {
    private static final int USE_KEEP_ALIVE_DEFAULT = 2;
    private int _keepAlive;
    private static final int _TheInputBufferSize = 2048;
    private static final int _TheOutputBufferSize = 2048;
    private static final int _HighWaterBufferSize;
    public static String URIResponseString;
    private final WOHTTPHeaderValue KeepAliveValue = new WOHTTPHeaderValue("keep-alive");
    private final WOHTTPHeaderValue CloseValue = new WOHTTPHeaderValue("close");
    private final WOLowercaseCharArray ConnectionKey = new WOLowercaseCharArray("connection");
    private final WOLowercaseCharArray ContentLengthKey = new WOLowercaseCharArray("content-length");
    private byte[] _buffer = new byte[2048];
    private int _bufferLength;
    private int _bufferIndex;
    private int _lineStartIndex;
    StringBuffer _headersBuffer = new StringBuffer(2048);
    public boolean _socketClosed = false;
    private final WOApplication _application;
    private static boolean _expectContentLengthHeader;
    private static int _contentTimeout;
    private final WOHTTPHeadersDictionary _headers = new WOHTTPHeadersDictionary();
    public static boolean _alwaysAppendContentLength;

    public static void expectContentLengthHeader(boolean bl, int n) {
        _expectContentLengthHeader = bl;
        _contentTimeout = n;
    }

    private int _readBlob(InputStream inputStream, int n) throws IOException {
        int n2;
        byte[] byArray = this._buffer;
        int n3 = this._bufferLength - this._bufferIndex;
        int n4 = this._bufferIndex;
        this._ensureBufferIsLargeEnoughToRead(n - n3);
        if (this._buffer != byArray) {
            System.arraycopy(byArray, n4, this._buffer, 0, n3);
            this._bufferLength = n3;
        }
        int n5 = 1;
        for (n2 = n3; n2 < n && n5 > 0; n2 += n5) {
            n5 = inputStream.read(this._buffer, this._bufferIndex + n2, n - n2);
        }
        return n2 > n ? n : n2;
    }

    private int refillInputBuffer(InputStream inputStream) throws IOException {
        int n = 0;
        boolean bl = true;
        if (this._bufferIndex >= 1) {
            if (this._bufferLength < this._buffer.length) {
                n = inputStream.read(this._buffer, this._bufferLength, this._buffer.length - this._bufferLength);
                bl = false;
            } else {
                byte[] byArray = this._buffer;
                int n2 = this._bufferLength - this._lineStartIndex;
                int n3 = this._lineStartIndex;
                this._ensureBufferIsLargeEnoughToRead(this._buffer.length);
                System.arraycopy(byArray, n3, this._buffer, 0, n2);
                this._bufferLength = n2;
                n = inputStream.read(this._buffer, n2, this._buffer.length - n2);
                this._bufferIndex = n2;
            }
        } else {
            this._bufferLength = 0;
            this._bufferIndex = 0;
            n = inputStream.read(this._buffer, 0, this._buffer.length);
        }
        if (n < 1) {
            return 0;
        }
        this._bufferLength += n;
        if (bl) {
            this._lineStartIndex = 0;
        }
        return this._bufferLength;
    }

    public int readLine(InputStream inputStream) throws IOException {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        this._lineStartIndex = this._bufferIndex;
        while (true) {
            if (this._bufferIndex < this._bufferLength) {
                if (bl) {
                    if (this._buffer[this._bufferIndex] == 9) {
                        this._buffer[this._bufferIndex] = 32;
                        bl2 = false;
                        bl = false;
                    } else if (this._buffer[this._bufferIndex] == 32) {
                        bl2 = false;
                        bl = false;
                    } else {
                        bl3 = true;
                    }
                } else if (this._buffer[this._bufferIndex] == 13) {
                    this._buffer[this._bufferIndex] = 32;
                    bl2 = true;
                } else if (this._buffer[this._bufferIndex] == 10) {
                    this._buffer[this._bufferIndex] = 32;
                    bl = true;
                    if (this._bufferIndex - this._lineStartIndex < 2) {
                        bl3 = true;
                        ++this._bufferIndex;
                    }
                }
                if (!bl3) {
                    ++this._bufferIndex;
                    continue;
                }
            }
            if (this._bufferIndex >= this._bufferLength && !bl3 && this.refillInputBuffer(inputStream) == 0) {
                if (bl) break;
                return 0;
            }
            if (bl3) break;
        }
        int n = this._bufferIndex;
        if (this._bufferIndex > this._bufferLength) {
            this._bufferIndex = this._bufferLength;
        }
        if (bl) {
            --n;
            if (bl2) {
                --n;
            }
        }
        return n - this._lineStartIndex;
    }

    public WOHttpIO() {
        this._application = WOApplication.application();
    }

    public void resetBuffer() {
        this._bufferLength = 0;
        this._bufferIndex = 0;
        this._lineStartIndex = 0;
    }

    private void _ensureBufferIsLargeEnoughToRead(int n) {
        int n2 = this._buffer.length;
        if (n + this._bufferLength > n2) {
            while (n + this._bufferLength > n2) {
                n2 <<= 1;
            }
            this._buffer = new byte[n2];
            this.resetBuffer();
        }
    }

    private void _shrinkBufferToHighWaterMark() {
        if (this._buffer.length > _HighWaterBufferSize) {
            this._buffer = new byte[2048];
            this.resetBuffer();
        }
    }

    protected WORequest readRequestFromSocket(Socket socket) throws IOException {
        int n;
        InputStream inputStream = socket.getInputStream();
        Object var4_3 = null;
        int n2 = 0;
        boolean bl = false;
        int n3 = 0;
        WORequest wORequest = null;
        String string = null;
        String string2 = null;
        String string3 = null;
        this.resetBuffer();
        this._headers.dispose();
        int n4 = this.readLine(inputStream);
        if (n4 == 0) {
            return null;
        }
        n3 = this._lineStartIndex;
        int n5 = n4 - 1;
        for (n = 0; this._buffer[n + n3] != 32 && n < n5; ++n) {
        }
        if (n < n5) {
            for (n2 = n5; this._buffer[n2 + n3] != 32 && n2 > n; --n2) {
            }
            int n6 = n5 - n2;
            if (n6 > 0) {
                string3 = _NSStringUtilities.stringForBytes((byte[])this._buffer, (int)(n2 + n3 + 1), (int)n6, (String)"ISO-8859-1");
            }
            if ((n6 = n2 - n - 1) > 0) {
                string2 = _NSStringUtilities.stringForBytes((byte[])this._buffer, (int)(n + n3 + 1), (int)n6, (String)"ISO-8859-1");
            }
            if ((n6 = n) > 0) {
                string = _NSStringUtilities.stringForBytes((byte[])this._buffer, (int)n3, (int)n6, (String)"ISO-8859-1");
            }
        }
        this._keepAlive = 2;
        InputStream inputStream2 = this._readHeaders(inputStream, true, true, false);
        WOInputStreamData wOInputStreamData = null;
        int n7 = 0;
        NSArray nSArray = (NSArray)this._headers.objectForKey(this.ContentLengthKey);
        if (nSArray != null && nSArray.count() == 1 && inputStream2 != null) {
            try {
                n7 = Integer.parseInt(nSArray.lastObject().toString());
            }
            catch (NumberFormatException numberFormatException) {
                this._application.debugString("<" + this.getClass().getName() + "> Unable to parse content-length header: '" + nSArray.lastObject() + "'.");
            }
            if (n7 > 0) {
                wOInputStreamData = new WOInputStreamData(inputStream2, n7);
            }
        } else {
            NSData nSData = this._content(inputStream, socket, false);
            if (nSData != null) {
                wOInputStreamData = new WOInputStreamData(nSData);
            }
        }
        if ((wORequest = this._application.createRequest(string, string2, string3, (NSDictionary)this._headers, (NSData)wOInputStreamData, null)) != null) {
            wORequest._setOriginatingAddress(socket.getInetAddress());
            wORequest._setOriginatingPort(socket.getPort());
        }
        this._shrinkBufferToHighWaterMark();
        return wORequest;
    }

    private void appendMessageHeaders(WOMessage wOMessage) {
        NSDictionary nSDictionary = wOMessage.headers();
        if (nSDictionary != null) {
            if (!(nSDictionary instanceof NSMutableDictionary)) {
                nSDictionary = nSDictionary.mutableClone();
            }
            ((NSMutableDictionary)nSDictionary).removeObjectForKey((Object)this.ContentLengthKey);
            NSArray nSArray = nSDictionary.allKeys();
            int n = nSArray.count();
            for (int i = 0; i < n; ++i) {
                Object object = nSArray.objectAtIndex(i);
                NSArray nSArray2 = wOMessage.headersForKey(object);
                int n2 = nSArray2.count();
                if (object instanceof WOLowercaseCharArray) {
                    char[] cArray = ((WOLowercaseCharArray)object).toCharArray();
                    for (int j = 0; j < n2; ++j) {
                        this._headersBuffer.append(cArray);
                        this._headersBuffer.append(": ");
                        this._headersBuffer.append(nSArray2.objectAtIndex(j));
                        this._headersBuffer.append("\r\n");
                    }
                    continue;
                }
                for (int j = 0; j < n2; ++j) {
                    this._headersBuffer.append(object);
                    this._headersBuffer.append(": ");
                    this._headersBuffer.append(nSArray2.objectAtIndex(j));
                    this._headersBuffer.append("\r\n");
                }
            }
        }
    }

    protected boolean sendResponse(WOResponse wOResponse, Socket socket, WORequest wORequest) throws IOException {
        String string = wOResponse.httpVersion();
        this._headersBuffer.setLength(0);
        this._headersBuffer.append(string);
        this._headersBuffer.append(' ');
        this._headersBuffer.append(wOResponse.status());
        this._headersBuffer.append(URIResponseString);
        return this.sendMessage(wOResponse, socket, string, wORequest);
    }

    public void sendRequest(WORequest wORequest, Socket socket) throws IOException {
        String string = wORequest.httpVersion();
        this._headersBuffer.setLength(0);
        this._headersBuffer.append(wORequest.method());
        this._headersBuffer.append(' ');
        this._headersBuffer.append(wORequest.uri());
        this._headersBuffer.append(' ');
        this._headersBuffer.append(string);
        this._headersBuffer.append("\r\n");
        this.sendMessage(wORequest, socket, string, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean sendMessage(WOMessage wOMessage, Socket socket, String string, WORequest wORequest) throws IOException {
        boolean bl;
        String string2;
        Object object;
        Object object2;
        Object object3;
        boolean bl2;
        NSData nSData;
        int n;
        block31: {
            WOInputStreamData wOInputStreamData;
            n = 0;
            nSData = null;
            this.appendMessageHeaders(wOMessage);
            if (string.equals("HTTP/1.1")) {
                if (this._keepAlive == 0) {
                    this._headersBuffer.append("connection: close\r\n");
                    bl2 = false;
                } else {
                    bl2 = true;
                }
            } else if (this._keepAlive == 1) {
                this._headersBuffer.append("connection: keep-alive\r\n");
                bl2 = true;
            } else {
                bl2 = false;
            }
            if (wORequest != null && (object3 = wORequest.content()) != null && object3 instanceof WOInputStreamData && (object2 = (wOInputStreamData = (WOInputStreamData)((Object)object3))._stream()) != null && object2 instanceof WONoCopyPushbackInputStream) {
                long l;
                object = (WONoCopyPushbackInputStream)object2;
                if (((WONoCopyPushbackInputStream)object).wasPrematurelyTerminated()) {
                    return false;
                }
                string2 = wORequest.headerForKey("content-length");
                long l2 = l = string2 != null ? Long.parseLong(string2) : 0L;
                if (l > 0L) {
                    long l3 = 0L;
                    int n2 = -1;
                    try {
                        n2 = socket.getSoTimeout();
                        socket.setSoTimeout(_contentTimeout);
                        ((WONoCopyPushbackInputStream)object).drain();
                        if (NSLog.debugLoggingAllowedForLevelAndGroups((int)3, (long)4L)) {
                            NSLog.out.appendln((Object)"<WOHttpIO>: Drained socket");
                        }
                        if (n2 != -1) {
                            socket.setSoTimeout(n2);
                        }
                    }
                    catch (SocketException socketException) {
                        if (NSLog.debugLoggingAllowedForLevelAndGroups((int)1, (long)4L)) {
                            NSLog.err.appendln((Object)("<WOHttpIO>: Unable to set socket timeout:" + socketException.getMessage()));
                            if (NSLog.allowedDebugLevel() > 1) {
                                NSLog.err.appendln((Throwable)socketException);
                            }
                        }
                    }
                    catch (IOException iOException) {
                        if (!NSLog.debugLoggingAllowedForLevelAndGroups((int)2, (long)4L)) break block31;
                        NSLog.err.appendln((Object)("<WOHttpIO>: Finished reading before content length of " + l + " : " + iOException.getMessage()));
                        if (NSLog.allowedDebugLevel() <= 1) break block31;
                        NSLog.err.appendln((Throwable)iOException);
                    }
                }
            }
        }
        object3 = null;
        int n3 = 0;
        if (wOMessage instanceof WOResponse && (object3 = ((WOResponse)(object2 = (WOResponse)wOMessage)).contentInputStream()) != null) {
            n3 = ((WOResponse)object2).contentInputStreamBufferSize();
            n = ((WOResponse)object2).contentInputStreamLength();
        }
        if (object3 == null) {
            nSData = wOMessage.content();
            int n4 = n = nSData == null ? 0 : nSData.length();
        }
        if (_alwaysAppendContentLength || n > 0) {
            this._headersBuffer.append("content-length: ");
            this._headersBuffer.append(n);
        }
        this._headersBuffer.append("\r\n\r\n");
        object2 = socket.getOutputStream();
        object = _NSStringUtilities.bytesForIsolatinString((String)new String(this._headersBuffer));
        ((OutputStream)object2).write((byte[])object, 0, ((Object)object).length);
        string2 = wORequest != null ? wORequest.method() : "";
        boolean bl3 = bl = string2.equals("HEAD");
        if (n > 0 && !bl) {
            if (object3 == null) {
                NSMutableRange nSMutableRange = new NSMutableRange();
                byte[] byArray = nSData.bytesNoCopy(nSMutableRange);
                ((OutputStream)object2).write(byArray, nSMutableRange.location(), nSMutableRange.length());
            } else {
                try {
                    byte[] byArray = new byte[n3];
                    while (n > 0) {
                        int n5 = ((InputStream)object3).read(byArray, 0, n > n3 ? n3 : n);
                        if (n5 == -1) {
                            break;
                        }
                        n -= n5;
                        ((OutputStream)object2).write(byArray, 0, n5);
                    }
                }
                finally {
                    block33: {
                        try {
                            ((InputStream)object3).close();
                        }
                        catch (Exception exception) {
                            NSLog.err.appendln((Object)("<WOHttpIO>: Failed to close content InputStream: " + exception));
                            if (!NSLog.debugLoggingAllowedForLevelAndGroups((int)2, (long)4L)) break block33;
                            NSLog.err.appendln((Throwable)exception);
                        }
                    }
                }
            }
        }
        ((OutputStream)object2).flush();
        return bl2;
    }

    public WOResponse readResponseFromSocket(Socket socket) throws IOException {
        int n;
        InputStream inputStream = socket.getInputStream();
        Object var4_3 = null;
        int n2 = 0;
        boolean bl = false;
        int n3 = 0;
        WOHTTPHeadersDictionary wOHTTPHeadersDictionary = new WOHTTPHeadersDictionary();
        WOResponse wOResponse = null;
        String string = null;
        String string2 = null;
        String string3 = null;
        this.resetBuffer();
        int n4 = this.readLine(inputStream);
        if (n4 == 0) {
            return null;
        }
        String string4 = _NSStringUtilities.stringForBytes((byte[])this._buffer, (int)n3, (int)n4, (String)"ISO-8859-1");
        n3 = this._lineStartIndex;
        int n5 = n4 - 1;
        for (n = 0; this._buffer[n + n3] != 32 && n < n5; ++n) {
        }
        if (n < n5) {
            for (n2 = n + 1; this._buffer[n2 + n3] != 32 && n2 < n5; ++n2) {
            }
            if (n2 < n5) {
                string2 = _NSStringUtilities.stringForBytes((byte[])this._buffer, (int)(n2 + n3 + 1), (int)(n5 - n2), (String)"ISO-8859-1");
            }
            string = _NSStringUtilities.stringForBytes((byte[])this._buffer, (int)(n + n3 + 1), (int)(n2 - n - 1), (String)"ISO-8859-1");
            string3 = _NSStringUtilities.stringForBytes((byte[])this._buffer, (int)n3, (int)n, (String)"ISO-8859-1");
        }
        wOResponse = this._application != null ? this._application.createResponseInContext(null) : new WOResponse();
        wOResponse.setHTTPVersion(string3);
        wOResponse.setStatus(Integer.parseInt(string));
        this._readHeaders(inputStream, false, false, false);
        wOResponse.setHeaders((NSDictionary)this._headers);
        boolean bl2 = false;
        NSArray nSArray = (NSArray)this._headers.valueForKey("Connection");
        if (nSArray != null) {
            int n6 = nSArray.count();
            for (int i = 0; i < n6; ++i) {
                String string5 = (String)nSArray.objectAtIndex(i);
                if (!string5.equalsIgnoreCase("close")) continue;
                bl2 = true;
                break;
            }
        }
        NSData nSData = this._content(inputStream, socket, bl2);
        wOResponse.setContent(nSData);
        this._shrinkBufferToHighWaterMark();
        if (bl2 || string3.equals("HTTP/1.1") && this._keepAlive == 0 || !string3.equals("HTTP/1.1") && this._keepAlive != 1) {
            socket.close();
            this._socketClosed = true;
        }
        return wOResponse;
    }

    public NSDictionary headers() {
        return this._headers;
    }

    public InputStream _readHeaders(InputStream inputStream, boolean bl, boolean bl2, boolean bl3) throws IOException {
        int n;
        int n2 = 0;
        while ((n = this.readLine(inputStream)) != 0) {
            n2 = this._lineStartIndex;
            int n3 = 0;
            int n4 = 0;
            for (int i = 0; i < n; ++i) {
                if (this._buffer[n2 + i] != 58) continue;
                n4 = i++;
                while (i < n && this._buffer[n2 + i] == 32) {
                    ++i;
                }
                if (i >= n) continue;
                n3 = i;
                break;
            }
            if (n3 == 0) continue;
            int n5 = n2;
            int n6 = n4;
            int n7 = n2 + n3;
            int n8 = n - n3;
            WOHTTPHeaderValue wOHTTPHeaderValue = this._headers.setBufferForKey(this._buffer, n7, n8, n5, n6);
            WOLowercaseCharArray wOLowercaseCharArray = this._headers.lastInsertedKey();
            if (!bl || this._keepAlive != 2 || !this.ConnectionKey.equals(wOLowercaseCharArray)) continue;
            if (wOHTTPHeaderValue.equalsIgnoreCase(this.KeepAliveValue)) {
                this._keepAlive = 1;
                continue;
            }
            if (!wOHTTPHeaderValue.equalsIgnoreCase(this.CloseValue)) continue;
            this._keepAlive = 0;
        }
        WONoCopyPushbackInputStream wONoCopyPushbackInputStream = null;
        int n9 = this._bufferLength - this._bufferIndex;
        if (bl2) {
            int n10 = 0;
            NSArray nSArray = (NSArray)this._headers.objectForKey(this.ContentLengthKey);
            if (nSArray != null && nSArray.count() == 1) {
                try {
                    n10 = Integer.parseInt(nSArray.lastObject().toString());
                }
                catch (NumberFormatException numberFormatException) {
                    this._application.debugString("<" + this.getClass().getName() + "> Unable to parse content-length header: '" + nSArray.lastObject() + "'.");
                }
                if (n9 > n10) {
                    n10 = n9;
                    this._headers.setObjectForKey(new NSMutableArray((Object)("" + n9)), this.ContentLengthKey);
                }
                wONoCopyPushbackInputStream = new WONoCopyPushbackInputStream(new BufferedInputStream(inputStream), n10 - n9);
            } else {
                wONoCopyPushbackInputStream = null;
            }
        } else if (bl3) {
            wONoCopyPushbackInputStream = inputStream instanceof WONoCopyPushbackInputStream ? (WONoCopyPushbackInputStream)inputStream : null;
        }
        if (wONoCopyPushbackInputStream != null && n9 > 0) {
            wONoCopyPushbackInputStream.unread(this._buffer, this._bufferIndex, n9);
        }
        return wONoCopyPushbackInputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NSData _forceReadContent(InputStream inputStream, Socket socket) {
        int n;
        byte[] byArray;
        BufferedInputStream bufferedInputStream;
        NSMutableData nSMutableData;
        int n2;
        block19: {
            n2 = 0;
            nSMutableData = new NSMutableData();
            bufferedInputStream = new BufferedInputStream(inputStream);
            byArray = new byte[2048];
            n = -1;
            try {
                n = socket.getSoTimeout();
                socket.setSoTimeout(_contentTimeout);
            }
            catch (SocketException socketException) {
                if (!NSLog.debugLoggingAllowedForLevelAndGroups((int)1, (long)4L)) break block19;
                NSLog.err.appendln((Object)("<WOHttpIO>: Unable to set socket timeout:" + socketException.getMessage()));
                if (NSLog.allowedDebugLevel() <= 1) break block19;
                NSLog.err.appendln((Throwable)socketException);
            }
        }
        if (this._bufferLength > this._bufferIndex) {
            nSMutableData.appendBytes(this._buffer, new NSRange(this._bufferIndex, this._bufferLength - this._bufferIndex));
        }
        while (true) {
            try {
                n2 = bufferedInputStream.read(byArray, 0, 2048);
                if (n2 < 0) break;
                nSMutableData.appendBytes(byArray, new NSRange(0, n2));
                continue;
            }
            catch (IOException iOException) {
                if (NSLog.debugLoggingAllowedForLevelAndGroups((int)2, (long)4L)) {
                    NSLog.err.appendln((Object)("<WOHttpIO>: IOException occurred during read():" + iOException.getMessage()));
                    if (NSLog.allowedDebugLevel() > 2) {
                        NSLog.err.appendln((Throwable)iOException);
                    }
                }
                NSData nSData = null;
                return nSData;
            }
            finally {
                try {
                    if (n == -1) continue;
                    socket.setSoTimeout(n);
                }
                catch (SocketException socketException) {
                    if (!NSLog.debugLoggingAllowedForLevelAndGroups((int)2, (long)4L)) continue;
                    NSLog.err.appendln((Object)("<WOHttpIO>: Unable to reset socket timeout:" + socketException.getMessage()));
                    if (NSLog.allowedDebugLevel() <= 2) continue;
                    NSLog.err.appendln((Throwable)socketException);
                }
                continue;
            }
            break;
        }
        return nSMutableData;
    }

    private NSData _content(InputStream inputStream, Socket socket, boolean bl) throws IOException {
        NSData nSData;
        block11: {
            byte[] byArray = null;
            int n = 0;
            int n2 = 0;
            nSData = null;
            NSMutableArray nSMutableArray = (NSMutableArray)this._headers.objectForKey(this.ContentLengthKey);
            if (nSMutableArray != null && nSMutableArray.count() == 1) {
                try {
                    n = Integer.parseInt((String)nSMutableArray.lastObject());
                }
                catch (NumberFormatException numberFormatException) {
                    this._application.debugString("<" + this.getClass().getName() + "> Unable to parse content-length header: '" + (String)nSMutableArray.lastObject() + "'.");
                }
                if (n != 0) {
                    n = this._readBlob(inputStream, n);
                    n2 = this._bufferIndex;
                    if (n > 0) {
                        byArray = this._buffer;
                    } else {
                        byArray = null;
                        n2 = 0;
                        n = 0;
                    }
                }
                try {
                    if (byArray != null) {
                        nSData = new NSData(byArray, new NSRange(n2, n), true);
                    }
                    break block11;
                }
                catch (Exception exception) {
                    NSLog.err.appendln((Object)("<" + this.getClass().getName() + "> Error: Request creation failed!\n" + exception.toString()));
                    if (NSLog.debugLoggingAllowedForLevelAndGroups((int)1, (long)8196L)) {
                        NSLog.debug.appendln((Throwable)exception);
                    }
                    break block11;
                }
            }
            if (bl || !_expectContentLengthHeader) {
                nSData = this._forceReadContent(inputStream, socket);
            }
        }
        return nSData;
    }

    public String toString() {
        return "<" + this.getClass().getName() + " keepAlive='" + this._keepAlive + "' buffer=" + this._buffer + " >";
    }

    static {
        URIResponseString = " Apple WebObjects\r\n";
        _expectContentLengthHeader = true;
        _contentTimeout = 5000;
        _alwaysAppendContentLength = true;
        int n = NSProperties.integerForKey((String)"WOMaxIOBufferSize");
        _HighWaterBufferSize = n != 0 ? (n < 2048 ? 2048 : n) : 8196;
    }
}

