/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.appserver._private;

import com.webobjects.appserver._private.WOCaseInsensitiveDictionary;
import com.webobjects.appserver._private.WOGIFHeaderScanner;
import com.webobjects.appserver._private.WOImageHeaderScanner;
import com.webobjects.appserver._private.WOJPEGHeaderScanner;
import com.webobjects.appserver._private.WOPNGHeaderScanner;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSLog;
import com.webobjects.foundation.NSPathUtilities;
import java.io.DataInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;

public class WOImageInfo {
    private int _width;
    private int _height;
    private String _widthString;
    private String _heightString;
    static WOCaseInsensitiveDictionary theSubclassPerExtensionDictionary;

    public WOImageInfo(URL uRL) throws IOException, FileNotFoundException {
        WOImageHeaderScanner wOImageHeaderScanner;
        if (uRL != null) {
            String string = uRL.toString();
            String string2 = NSPathUtilities.pathExtension((String)string);
            wOImageHeaderScanner = WOImageInfo._getScannerForExtension(string2);
            if (wOImageHeaderScanner == null) {
                throw new IllegalArgumentException("<WOImageInfo>:WOImageInfo only supports the following file extensions at present" + WOImageInfo.getSupportedExtensions());
            }
        } else {
            throw new IllegalArgumentException("<WOImageInfo>: Failed to create WOImageInfo from URL (" + uRL + ").");
        }
        DataInputStream dataInputStream = this._readImageFromURL(uRL);
        wOImageHeaderScanner.setStream(dataInputStream);
        wOImageHeaderScanner.scan();
        this._setImageDimensionUsingScanner(wOImageHeaderScanner);
    }

    public static NSArray getSupportedExtensions() {
        return theSubclassPerExtensionDictionary.allKeys();
    }

    public static boolean isSupportedExtension(String string) {
        return WOImageInfo._getScannerForExtension(string) != null;
    }

    public static boolean pathHasSupportedExtension(String string) {
        String string2 = NSPathUtilities.pathExtension((String)string);
        return WOImageInfo.isSupportedExtension(string2);
    }

    public int width() {
        return this._width;
    }

    public int height() {
        return this._height;
    }

    public String widthString() {
        return this._widthString;
    }

    public String heightString() {
        return this._heightString;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<");
        stringBuffer.append(this.getClass().getName());
        stringBuffer.append(" width=" + this._width);
        stringBuffer.append(" height=" + this._height);
        stringBuffer.append(" widthString=" + this._widthString);
        stringBuffer.append(" heightString=" + this._heightString);
        stringBuffer.append(">");
        return stringBuffer.toString();
    }

    private DataInputStream _readImageFromURL(URL uRL) throws FileNotFoundException, IOException {
        return new DataInputStream(uRL.openStream());
    }

    private void _setImageDimensionUsingScanner(WOImageHeaderScanner wOImageHeaderScanner) throws IOException {
        this._width = wOImageHeaderScanner.getWidth();
        this._height = wOImageHeaderScanner.getHeight();
        this._widthString = String.valueOf(this._width);
        this._heightString = String.valueOf(this._height);
    }

    private static WOImageHeaderScanner _getScannerForExtension(String string) {
        block6: {
            if (string == null || string.length() < 1) {
                return null;
            }
            Class clazz = (Class)theSubclassPerExtensionDictionary.objectForKey(string);
            if (clazz == null) {
                return null;
            }
            try {
                return (WOImageHeaderScanner)clazz.newInstance();
            }
            catch (InstantiationException instantiationException) {
                if (NSLog.debugLoggingAllowedForLevelAndGroups((int)2, (long)0x1000000L)) {
                    NSLog.debug.appendln((Object)("<WOImageInfo>:Couldn't create an instance of the subclass:" + clazz.getName()));
                    NSLog.debug.appendln((Throwable)instantiationException);
                }
            }
            catch (IllegalAccessException illegalAccessException) {
                if (!NSLog.debugLoggingAllowedForLevelAndGroups((int)2, (long)0x1000000L)) break block6;
                NSLog.debug.appendln((Object)("<WOImageInfo>:Couldn't access the subclass:" + clazz.getName()));
                NSLog.debug.appendln((Throwable)illegalAccessException);
            }
        }
        return null;
    }

    static {
        block2: {
            try {
                theSubclassPerExtensionDictionary = new WOCaseInsensitiveDictionary();
                theSubclassPerExtensionDictionary.setObjectForKey(WOJPEGHeaderScanner.class, "jpg");
                theSubclassPerExtensionDictionary.setObjectForKey(WOJPEGHeaderScanner.class, "jpeg");
                theSubclassPerExtensionDictionary.setObjectForKey(WOGIFHeaderScanner.class, "gif");
                theSubclassPerExtensionDictionary.setObjectForKey(WOPNGHeaderScanner.class, "png");
            }
            catch (Exception exception) {
                NSLog.err.appendln((Object)"<WOImageInfo>:Exception during static initialization:");
                if (!NSLog.debugLoggingAllowedForLevelAndGroups((int)1, (long)8192L)) break block2;
                NSLog.debug.appendln((Throwable)exception);
            }
        }
    }
}

