/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.appserver._private;

import com.webobjects.foundation.NSCoder;
import com.webobjects.foundation.NSData;
import com.webobjects.foundation.NSForwardException;
import com.webobjects.foundation.NSLog;
import com.webobjects.foundation.NSMutableData;
import com.webobjects.foundation.NSMutableRange;
import com.webobjects.foundation.NSRange;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectStreamException;

public class WOInputStreamData
extends NSMutableData {
    static final long serialVersionUID = 1L;
    protected InputStream _stream = null;
    protected int _streamLength = 0;
    protected boolean _shouldClose = false;
    protected boolean _hasAccessedStream = false;

    public WOInputStreamData(NSData nSData) {
        super(nSData);
    }

    public WOInputStreamData(InputStream inputStream, int n) {
        super(0);
        this._initInputStream(inputStream, n, false);
    }

    protected void _initInputStream(InputStream inputStream, int n, boolean bl) {
        if (n < 0) {
            throw new IllegalArgumentException("WOStreamingData: Length must be >= 0");
        }
        if (inputStream == null) {
            throw new IllegalArgumentException("WOStreamingData: InputStream must not be null");
        }
        this._stream = inputStream;
        this._streamLength = n;
        this._range = new NSRange(0, n);
        this._shouldClose = bl;
        this._bytes = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void _extractBytesFromInputStream() {
        try {
            if (this._bytes != null) {
                return;
            }
            if (this._stream == null) {
                return;
            }
            if (this._hasAccessedStream) {
                if (NSLog.debugLoggingAllowedForLevelAndGroups((int)3, (long)4L)) {
                    NSLog.debug.appendln((Object)"<WOInputStreamData>: Cannot access byte data after accessing InputStream");
                }
                return;
            }
            if (NSLog.debugLoggingAllowedForLevelAndGroups((int)3, (long)4L)) {
                NSLog.debug.appendln((Object)"<WOInputStreamData>: Reading InputStream into byte data");
            }
            try {
                if (this._streamLength <= 0) {
                    NSData nSData = new NSData(this._stream, 4096);
                    this._bytes = nSData._bytesNoCopy();
                    this._range = new NSRange(0, nSData.length());
                    this._streamLength = this._range.length();
                } else {
                    int n;
                    this._bytes = new byte[this._streamLength];
                    this._range = new NSMutableRange(0, this._streamLength);
                    for (int i = 0; i < this._streamLength; i += n) {
                        n = this._stream.read(this._bytes, i, this._streamLength - i);
                        if (n >= 0) continue;
                        throw new IOException("error while reading input stream for new WOInputStreamData: " + i + " out of " + this._streamLength + "bytes");
                    }
                }
            }
            finally {
                if (this._shouldClose) {
                    this._stream.close();
                }
                this._stream = null;
            }
        }
        catch (IOException iOException) {
            throw new NSForwardException((Throwable)iOException);
        }
    }

    protected byte[] bytesNoCopy() {
        this._extractBytesFromInputStream();
        return super.bytesNoCopy();
    }

    protected NSRange rangeNoCopy() {
        if (this._streamLength <= 0) {
            this._extractBytesFromInputStream();
        }
        return this._range;
    }

    public boolean isEqualToData(NSData nSData) {
        if (nSData == null) {
            return false;
        }
        return nSData == this;
    }

    public InputStream inputStream() {
        if (this._bytes == null) {
            this._hasAccessedStream = true;
            this._range = new NSRange(0, 0);
            return this._stream;
        }
        if (NSLog.debugLoggingAllowedForLevelAndGroups((int)3, (long)4L)) {
            NSLog.debug.appendln((Object)"<WOInputStreamData>: Cannot access InputStream after accessing byte data");
        }
        return null;
    }

    public int streamLength() {
        return this._streamLength;
    }

    public boolean hasStreamBeenAccessed() {
        return this._hasAccessedStream;
    }

    public InputStream _stream() {
        return this._stream;
    }

    public Class classForCoder() {
        return NSMutableData._CLASS;
    }

    public static Object decodeObject(NSCoder nSCoder) {
        return new NSMutableData(nSCoder.decodeBytes());
    }

    public int hashCode() {
        if (this._hashCache == 0) {
            this._hashCache = System.identityHashCode((Object)this);
        }
        return this._hashCache;
    }

    public String toString() {
        if (this._bytes == null) {
            String string = "";
            if (!this._hasAccessedStream) {
                string = "NOT ";
            }
            return "<" + ((Object)((Object)this)).getClass().toString() + " (stream " + this._stream + " of length " + this._streamLength + "), has " + string + "been accessed>";
        }
        return super.toString();
    }

    protected Object writeReplace() throws ObjectStreamException {
        return new NSMutableData((NSData)this);
    }

    protected NSRange immutableRange() {
        return new NSRange(0, this.length());
    }

    public void setLength(int n) {
        this._extractBytesFromInputStream();
        super.setLength(n);
    }

    public void setData(NSData nSData) {
        this._stream = null;
        this._hasAccessedStream = false;
        super.setData(nSData);
    }

    public void resetBytesInRange(NSRange nSRange) {
        this._extractBytesFromInputStream();
        super.resetBytesInRange(nSRange);
    }

    public void appendByte(byte by) {
        this._extractBytesFromInputStream();
        super.appendByte(by);
    }

    public void appendBytes(byte[] byArray, NSRange nSRange) {
        this._extractBytesFromInputStream();
        super.appendBytes(byArray, nSRange);
    }

    public Object clone() {
        return new NSMutableData((NSData)this);
    }
}

