/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.appserver._private;

import com.webobjects.appserver._private.WOImageHeaderScanner;
import com.webobjects.foundation.NSLog;
import java.io.IOException;

public class WOJPEGHeaderScanner
extends WOImageHeaderScanner {
    static final int M_SOF0 = 192;
    static final int M_SOF1 = 193;
    static final int M_SOF2 = 194;
    static final int M_SOF3 = 195;
    static final int M_SOF5 = 197;
    static final int M_SOF6 = 198;
    static final int M_SOF7 = 199;
    static final int M_SOF9 = 201;
    static final int M_SOF10 = 202;
    static final int M_SOF11 = 203;
    static final int M_SOF13 = 205;
    static final int M_SOF14 = 206;
    static final int M_SOF15 = 207;
    static final int M_SOI = 216;
    static final int M_EOI = 217;
    static final int M_SOS = 218;
    static final int M_COM = 254;

    public void scan() throws IOException {
        if (this.firstMarker() != 216) {
            throw new IOException("Expected SOI marker first");
        }
        while (true) {
            int n = this.nextMarker();
            switch (n) {
                case 192: 
                case 193: 
                case 194: 
                case 195: 
                case 197: 
                case 198: 
                case 199: 
                case 201: 
                case 202: 
                case 203: 
                case 205: 
                case 206: 
                case 207: {
                    this.processSOFn(n);
                }
                case 218: {
                    return;
                }
                case 217: {
                    return;
                }
            }
            this.skipVariable();
        }
    }

    public int getByte() {
        int n = 0;
        try {
            n = this.inputStream.readUnsignedByte();
        }
        catch (IOException iOException) {
            NSLog._conditionallyLogPrivateException((Throwable)iOException);
        }
        return n;
    }

    public int getInt() {
        int n = 0;
        try {
            n = this.inputStream.readUnsignedByte();
            n <<= 8;
            int n2 = this.inputStream.readUnsignedByte();
            n ^= n2;
        }
        catch (IOException iOException) {
            NSLog._conditionallyLogPrivateException((Throwable)iOException);
        }
        return n;
    }

    public int nextMarker() throws IOException {
        int n = 0;
        int n2 = this.getByte();
        while (n2 != 255) {
            ++n;
            n2 = this.getByte();
        }
        while ((n2 = this.getByte()) == 255) {
        }
        if (n != 0) {
            throw new IOException("Warning: garbage data found in JPEG file");
        }
        return n2;
    }

    public int firstMarker() throws IOException {
        int n = this.getByte();
        int n2 = this.getByte();
        if (n != 255 || n2 != 216) {
            throw new IOException("Not a JPEG file");
        }
        return n2;
    }

    public void skipVariable() throws IOException {
        int n = this.getInt();
        if (n < 2) {
            throw new IOException("Erroneous JPEG marker length");
        }
        n -= 2;
        while (n > 0) {
            int n2 = this.getByte();
            --n;
        }
    }

    public void processSOFn(int n) throws IOException {
        int n2 = this.getInt();
        int n3 = this.getByte();
        this.height = this.getInt();
        this.width = this.getInt();
        int n4 = this.getByte();
        if (n2 != 8 + n4 * 3) {
            throw new IOException("Bogus SOF marker length");
        }
        for (int i = 0; i < n4; ++i) {
            int n5 = this.getByte();
            n5 = this.getByte();
            n5 = this.getByte();
        }
    }
}

