/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.appserver._private;

import com.webobjects._ideservices._IDEProject;
import com.webobjects._ideservices._IDEProjectPBX;
import com.webobjects._ideservices._WOProject;
import com.webobjects.appserver.WOApplication;
import com.webobjects.appserver._private.WODeployedBundle;
import com.webobjects.appserver._private.WOProperties;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSBundle;
import com.webobjects.foundation.NSLog;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSMutableDictionary;
import com.webobjects.foundation.NSPathUtilities;
import com.webobjects.foundation.NSProperties;
import java.io.File;
import java.io.FilenameFilter;
import java.net.URL;
import java.util.Enumeration;

public class WOProjectBundle
extends WODeployedBundle {
    private volatile _WOProject _woProject;
    private final String _projectPath;
    private final int _projectPathLength;
    private final WODeployedBundle _associatedDeployedBundle;
    private static final NSMutableDictionary TheProjectBundles = new NSMutableDictionary(NSBundle.frameworkBundles().count());
    private static final String TheNotFoundMarker = "NotFoundMarker";
    private static volatile boolean _refreshProjectBundlesOnCacheMiss = NSProperties.booleanForKey((String)"WOMissingResourceSearchEnabled");
    private static PBWOProjectAndDirFilter theProjectsInDirectoryFilter = new PBWOProjectAndDirFilter();
    protected static NSMutableArray TheProjectsArrayArray = null;

    public WOProjectBundle(String string, WODeployedBundle wODeployedBundle) {
        super(string, wODeployedBundle.nsBundle());
        String string2 = this._woProject.ideProject().ideProjectPath();
        if (string2.endsWith("PB.project")) {
            string2 = NSPathUtilities.stringByDeletingLastPathComponent((String)string2);
        } else if (string2.endsWith("project.pbxproj") && (string2 = NSPathUtilities.stringByDeletingLastPathComponent((String)string2)).endsWith(".pbproj")) {
            string2 = NSPathUtilities.stringByDeletingLastPathComponent((String)string2);
        }
        this._projectPath = string2;
        this._projectPathLength = string2.length();
        if (this._projectName == null) {
            WOApplication.application().debugString("<" + this.getClass().getName() + ">: Warning - Unable to locate PROJECTNAME in '" + wODeployedBundle.bundlePath() + "'");
        }
        this._associatedDeployedBundle = wODeployedBundle;
    }

    public String toString() {
        return "<" + this.getClass().getName() + ": projectName='" + this._projectName + "'; bundlePath='" + this._bundlePath + "'; projectPath='" + this._projectPath + "'>";
    }

    public _WOProject _woProject() {
        return this._woProject;
    }

    protected String _initBundlePath(String string) {
        String string2 = null;
        _WOProject _WOProject2 = _WOProject.projectAtPath(string);
        if (_WOProject2 != null) {
            string2 = _WOProject2.bundlePath();
            this._woProject = _WOProject2;
        }
        if (string2 == null) {
            string2 = NSPathUtilities.stringByNormalizingExistingPath((String)string);
        }
        return string2;
    }

    protected String _initProjectName(String string) {
        if (this._woProject() != null) {
            return this._woProject().ideProject().projectName();
        }
        return null;
    }

    public String projectName() {
        return this._projectName;
    }

    public String projectPath() {
        return this._projectPath;
    }

    public WOProjectBundle projectBundle() {
        return this;
    }

    public URL pathURLForResourceNamed(String string, String string2, boolean bl) {
        String string3 = this._absolutePathForResource(string, string2, bl);
        return NSPathUtilities._URLWithPath((String)string3);
    }

    public URL pathURLForResourceNamed(String string, String string2) {
        String string3 = this._absolutePathForResource(string, string2);
        return NSPathUtilities._URLWithPath((String)string3);
    }

    public URL pathURLForResourceNamed(String string, NSArray nSArray) {
        String string2 = this._absolutePathForResource(string, nSArray);
        return NSPathUtilities._URLWithPath((String)string2);
    }

    public String _absolutePathForResource(String string, NSArray nSArray) {
        String string2 = null;
        if (nSArray != null && nSArray.count() > 0) {
            int n = nSArray.count();
            boolean bl = _refreshProjectBundlesOnCacheMiss;
            for (int i = 0; i < n && string2 == null; ++i) {
                String string3 = (String)nSArray.objectAtIndex(i);
                string2 = this._absolutePathForResource(string, string3, bl);
                bl = false;
            }
        } else {
            string2 = this._woProject.pathForResourceNamed(string, _refreshProjectBundlesOnCacheMiss);
            if (string2 == null) {
                string2 = this._associatedDeployedBundle._absolutePathForResource(string, nSArray);
            }
        }
        return string2;
    }

    public String _absolutePathForResource(String string, String string2) {
        return this._absolutePathForResource(string, string2, true);
    }

    public String _absolutePathForResource(String string, String string2, boolean bl) {
        String string3 = null;
        _WOProject _WOProject2 = this._woProject;
        string3 = _WOProject2.pathForResourceNamed(string, string2, bl);
        if (string3 == null) {
            string3 = this._associatedDeployedBundle._absolutePathForResource(string, string2);
        }
        return string3;
    }

    public String relativePathForResource(String string, String string2) {
        String string3 = this._absolutePathForResource(string, string2);
        String string4 = null;
        string4 = string3 == null || string3.length() < this._projectPathLength || !string3.startsWith(this._projectPath) ? string3 : string3.substring(this._projectPathLength);
        return string4;
    }

    public String relativePathForResource(String string, NSArray nSArray) {
        String string2 = this._absolutePathForResource(string, nSArray);
        String string3 = null;
        string3 = string2 == null || string2.length() < this._projectPathLength || !string2.startsWith(this._projectPath) ? string2 : string2.substring(this._projectPathLength);
        return string3;
    }

    protected static boolean _isProjectBundlePath(String string) {
        _IDEProject _IDEProject2 = _WOProject.ideProjectAtPath(string);
        return _IDEProject2 != null;
    }

    public static synchronized WODeployedBundle bundleWithPath(String string) {
        WODeployedBundle wODeployedBundle = WODeployedBundle.bundleWithPath(string);
        if (wODeployedBundle == null || wODeployedBundle instanceof WODeployedBundle) {
            WOProjectBundle wOProjectBundle = (WOProjectBundle)TheProjectBundles.objectForKey((Object)string);
            if (wOProjectBundle == null) {
                _IDEProject _IDEProject2 = _WOProject.ideProjectAtPath(string);
                if (_IDEProject2 != null) {
                    String string2 = _IDEProject2.projectName();
                    NSBundle nSBundle = NSBundle.bundleForName((String)string2);
                    if (nSBundle == null) {
                        nSBundle = NSBundle._appBundleForName((String)string2);
                    }
                    if (nSBundle != null && (wODeployedBundle = WODeployedBundle.bundleWithNSBundle(nSBundle)) != null) {
                        wODeployedBundle = new WOProjectBundle(string, wODeployedBundle);
                        TheProjectBundles.setObjectForKey((Object)wODeployedBundle, (Object)string);
                    }
                }
            } else {
                wODeployedBundle = wOProjectBundle;
            }
        }
        return wODeployedBundle;
    }

    protected static NSMutableArray _projectsInDirectory(String string) {
        String string2 = null;
        File file = new File(string);
        String[] stringArray = file.list(theProjectsInDirectoryFilter);
        NSMutableArray nSMutableArray = new NSMutableArray(64);
        NSMutableDictionary nSMutableDictionary = new NSMutableDictionary(64);
        if (stringArray != null) {
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                WOProjectBundle wOProjectBundle;
                string2 = stringArray[i];
                String string3 = NSPathUtilities.stringByAppendingPathComponent((String)string, (String)string2);
                if (!WOProjectBundle._isProjectBundlePath(string3) || (wOProjectBundle = (WOProjectBundle)WOProjectBundle.bundleWithPath(string3)) == null) continue;
                String string4 = wOProjectBundle.projectName();
                if (string4 != null) {
                    boolean bl = wOProjectBundle.isFramework();
                    String string5 = string4 + (bl ? "framework" : "woa");
                    WOProjectBundle wOProjectBundle2 = (WOProjectBundle)nSMutableDictionary.objectForKey((Object)string5);
                    if (wOProjectBundle2 != null) {
                        String string6;
                        String string7;
                        boolean bl2 = wOProjectBundle2.isFramework();
                        if (bl && bl2) {
                            string7 = wOProjectBundle.bundlePath();
                            string6 = NSPathUtilities.lastPathComponent((String)string7);
                            if (string6.startsWith(string4)) {
                                nSMutableArray.removeObject((Object)wOProjectBundle2);
                                nSMutableArray.addObject((Object)wOProjectBundle);
                                nSMutableDictionary.setObjectForKey((Object)wOProjectBundle, (Object)string5);
                                WOApplication.application().debugString("** Warning: More than one framework project with the name '" + string4 + "'.  Choosing " + string7 + " over " + wOProjectBundle2.bundlePath() + " .");
                                continue;
                            }
                            WOApplication.application().debugString("** Warning: More than one framework project with the name '" + string4 + "'.  Using " + wOProjectBundle2.bundlePath() + " rather than " + string7 + " .");
                            continue;
                        }
                        if (bl || bl2) continue;
                        string7 = System.getProperty("user.dir");
                        if (string7.startsWith(string6 = wOProjectBundle.bundlePath())) {
                            nSMutableArray.removeObject((Object)wOProjectBundle2);
                            nSMutableArray.addObject((Object)wOProjectBundle);
                            nSMutableDictionary.setObjectForKey((Object)wOProjectBundle, (Object)string5);
                            WOApplication.application().debugString("** Warning: More than one application project with the name '" + string4 + "'.  Choosing " + string6 + " over " + wOProjectBundle2.bundlePath() + " .");
                            continue;
                        }
                        WOApplication.application().debugString("** Warning: More than one application project with the name '" + string4 + "'.  Choosing " + wOProjectBundle2.bundlePath() + " over " + string6 + " .");
                        continue;
                    }
                    nSMutableArray.addObject((Object)wOProjectBundle);
                    nSMutableDictionary.setObjectForKey((Object)wOProjectBundle, (Object)string5);
                    continue;
                }
                WOApplication.application().debugString("<WOProjectBundle> Warning - Project bundle has no name. " + wOProjectBundle);
            }
        }
        return nSMutableArray;
    }

    static synchronized NSMutableArray _WOAllProjects() {
        NSMutableArray nSMutableArray;
        Object object;
        _IDEProjectPBX _IDEProjectPBX2;
        if (TheProjectsArrayArray != null) {
            return TheProjectsArrayArray;
        }
        NSArray nSArray = WOProperties.projectSearchPath();
        NSMutableArray nSMutableArray2 = new NSMutableArray(nSArray.count());
        String string = NSBundle.mainBundle().bundlePath();
        if (NSLog._debugLoggingAllowedForLevelAndGroups((int)3, (long)36L)) {
            NSLog.debug.appendln((Object)("WOProjectBundle._WOAllProjects() -- main bundle path is: " + string));
        }
        if ((_IDEProjectPBX2 = _IDEProjectPBX.pbxProjectAtPath(string)) == null) {
            if (NSLog._debugLoggingAllowedForLevelAndGroups((int)2, (long)36L)) {
                NSLog.debug.appendln((Object)"WOProjectBundle._WOAllProjects() -- no open Xcode project found for main bundle.  Skipping initialization of Xcode WOProjectBundles.");
            }
        } else {
            int n;
            object = _IDEProjectPBX2.frameworkBundlePaths();
            if (NSLog._debugLoggingAllowedForLevelAndGroups((int)2, (long)36L)) {
                NSLog.debug.appendln((Object)("WOProjectBundle._WOAllProjects() -- main bundle's project path is: " + _IDEProjectPBX2.ideProjectPath()));
                NSLog.debug.appendln((Object)("WOProjectBundle._WOAllProjects() -- main bundle's framework paths are " + object));
            }
            if ((n = object.count()) > 0) {
                nSMutableArray = new NSMutableArray(n + 1);
                WOProjectBundle wOProjectBundle = (WOProjectBundle)WOProjectBundle.bundleWithPath(string);
                if (wOProjectBundle == null) {
                    if (NSLog._debugLoggingAllowedForLevelAndGroups((int)2, (long)36L)) {
                        NSLog.debug.appendln((Object)("WOProjectBundle._WOAllProjects() -- failed to create a WOProjectBundle for the Xcode project for the main project bundle at: " + string + " ... Perhaps the project is not open in Xcode anymore."));
                    }
                } else {
                    nSMutableArray.addObject((Object)wOProjectBundle);
                }
                for (int i = 0; i < n; ++i) {
                    String string2 = (String)object.objectAtIndex(i);
                    if (WOProjectBundle._isProjectBundlePath(string2)) {
                        WOProjectBundle wOProjectBundle2 = (WOProjectBundle)WOProjectBundle.bundleWithPath(string2);
                        if (wOProjectBundle2 == null) {
                            if (!NSLog._debugLoggingAllowedForLevelAndGroups((int)2, (long)36L)) continue;
                            NSLog.debug.appendln((Object)("WOProjectBundle._WOAllProjects() -- failed to create a WOProjectBundle for the Xcode project for the framework bundle at: " + string2 + " ... Perhaps the project is not open in Xcode."));
                            continue;
                        }
                        nSMutableArray.addObject((Object)wOProjectBundle2);
                        if (!NSLog._debugLoggingAllowedForLevelAndGroups((int)2, (long)36L)) continue;
                        NSLog.debug.appendln((Object)("WOProjectBundle._WOAllProjects() -- found an open Xcode framework project at " + wOProjectBundle2.bundlePath()));
                        continue;
                    }
                    if (!NSLog._debugLoggingAllowedForLevelAndGroups((int)2, (long)36L)) continue;
                    NSLog.debug.appendln((Object)("WOProjectBundle._WOAllProjects() -- failed to find a Xcode project for the framework bundle at: " + string2 + " ... Perhaps the project is not a Xcode project.  If it is such a project, perhaps it's not open in Xcode or has not been built in development mode."));
                }
                if (NSLog.debugLoggingAllowedForLevelAndGroups((int)2, (long)36L)) {
                    NSLog.debug.appendln((Object)("*** The application has found the following opened, development-mode Xcode projects: " + nSMutableArray));
                }
                nSMutableArray2.addObject((Object)nSMutableArray);
            }
        }
        if (nSArray != null) {
            object = null;
            Enumeration enumeration = nSArray.objectEnumerator();
            while (enumeration.hasMoreElements()) {
                object = (String)enumeration.nextElement();
                nSMutableArray = WOProjectBundle._projectsInDirectory((String)object);
                if (nSMutableArray == null || nSMutableArray.count() <= 0) continue;
                if (NSLog.debugLoggingAllowedForLevelAndGroups((int)2, (long)36L)) {
                    NSLog.debug.appendln((Object)("*** The application has found the following opened, development-mode ProjectBuilderWO projects: " + nSMutableArray));
                }
                nSMutableArray2.addObject((Object)nSMutableArray);
            }
        }
        TheProjectsArrayArray = nSMutableArray2;
        return TheProjectsArrayArray;
    }

    private static WOProjectBundle _locateBundleInArrayForProjectNamedIsFramework(NSMutableArray nSMutableArray, String string, boolean bl) {
        WOProjectBundle wOProjectBundle = null;
        int n = nSMutableArray.count();
        for (int i = 0; !(i >= n || (wOProjectBundle = (WOProjectBundle)nSMutableArray.objectAtIndex(i)).projectName().equals(string) && bl == wOProjectBundle.isFramework()); ++i) {
            wOProjectBundle = null;
        }
        return wOProjectBundle;
    }

    public static WOProjectBundle projectBundleForProject(String string, boolean bl) {
        WOProjectBundle wOProjectBundle = null;
        NSMutableArray nSMutableArray = WOProjectBundle._WOAllProjects();
        if (nSMutableArray != null) {
            NSMutableArray nSMutableArray2 = null;
            int n = nSMutableArray.count();
            for (int i = 0; wOProjectBundle == null && i < n; ++i) {
                nSMutableArray2 = (NSMutableArray)nSMutableArray.objectAtIndex(i);
                wOProjectBundle = WOProjectBundle._locateBundleInArrayForProjectNamedIsFramework(nSMutableArray2, string, bl);
            }
        }
        return wOProjectBundle;
    }

    public static boolean refreshProjectBundlesOnCacheMiss() {
        return _refreshProjectBundlesOnCacheMiss;
    }

    public static void setRefreshProjectBundlesOnCacheMiss(boolean bl) {
        _refreshProjectBundlesOnCacheMiss = bl;
    }

    private static class PBWOProjectAndDirFilter
    implements FilenameFilter {
        private PBWOProjectAndDirFilter() {
        }

        public boolean accept(File file, String string) {
            return string.equals("PB.project") || new File(file.getPath() + string).isDirectory();
        }
    }
}

