/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.appserver._private;

import com.webobjects.appserver.WOApplication;
import com.webobjects.appserver.WOContext;
import com.webobjects.appserver._private.WOAxisSession;
import com.webobjects.foundation.NSLog;
import javax.xml.namespace.QName;
import org.apache.axis.AxisFault;
import org.apache.axis.Constants;
import org.apache.axis.Message;
import org.apache.axis.MessageContext;
import org.apache.axis.handlers.BasicHandler;
import org.apache.axis.message.SOAPEnvelope;
import org.apache.axis.message.SOAPHeaderElement;
import org.apache.axis.session.Session;

public class WOServerSessionHandler
extends BasicHandler {
    public static final QName sessionHeaderQName = new QName("http://www.apple.com/webobjects/webservices/soap/", "wosid");
    public static final QName instanceHeaderQName = new QName("http://www.apple.com/webobjects/webservices/soap/", "woinst");

    public void invoke(MessageContext messageContext) throws AxisFault {
        if (!messageContext.isClient()) {
            this.doServer(messageContext);
        }
    }

    public void doServer(MessageContext messageContext) throws AxisFault {
        if (messageContext.getPastPivot()) {
            Message message;
            if (NSLog.debugLoggingAllowedForLevelAndGroups((int)2, (long)0x10000000L)) {
                NSLog.debug.appendln((Object)"WOServerSessionHandler.doServer - processing response");
            }
            String string = null;
            WOContext wOContext = (WOContext)messageContext.getProperty("com.webobjects.appserver.WOContext");
            if (wOContext.hasSession() && !wOContext.session().isTerminating()) {
                string = wOContext.session().sessionID();
            }
            if (string == null) {
                string = wOContext._requestSessionID();
            }
            if (NSLog.debugLoggingAllowedForLevelAndGroups((int)3, (long)0x10000000L)) {
                NSLog.debug.appendln((Object)("WOServerSessionHandler.doServer - setting session ID to response: " + string));
            }
            if ((message = messageContext.getResponseMessage()) == null) {
                return;
            }
            SOAPEnvelope sOAPEnvelope = message.getSOAPEnvelope();
            SOAPHeaderElement sOAPHeaderElement = null;
            if (string != null) {
                sOAPHeaderElement = new SOAPHeaderElement(sessionHeaderQName.getNamespaceURI(), sessionHeaderQName.getLocalPart(), (Object)string);
                sOAPEnvelope.addHeader(sOAPHeaderElement);
                sOAPHeaderElement = new SOAPHeaderElement(instanceHeaderQName.getNamespaceURI(), instanceHeaderQName.getLocalPart(), (Object)Integer.toString(wOContext.request().applicationNumber()));
                sOAPEnvelope.addHeader(sOAPHeaderElement);
                if (wOContext.hasSession() && !wOContext.session().isTerminating()) {
                    if (WOApplication.application().wasMainInvoked()) {
                        wOContext.session().setStoresIDsInCookies(true);
                        wOContext.session()._appendCookieToResponse(wOContext.response());
                    } else {
                        wOContext.session().setStoresIDsInCookies(false);
                    }
                }
            }
        } else {
            Message message;
            if (NSLog.debugLoggingAllowedForLevelAndGroups((int)2, (long)0x10000000L)) {
                NSLog.debug.appendln((Object)"WOServerSessionHandler.doServer - processing request");
            }
            if ((message = messageContext.getRequestMessage()) == null) {
                throw new AxisFault("No Request Message");
            }
            SOAPEnvelope sOAPEnvelope = message.getSOAPEnvelope();
            SOAPHeaderElement sOAPHeaderElement = null;
            String string = null;
            WOContext wOContext = (WOContext)messageContext.getProperty("com.webobjects.appserver.WOContext");
            sOAPHeaderElement = sOAPEnvelope.getHeaderByName(sessionHeaderQName.getNamespaceURI(), sessionHeaderQName.getLocalPart());
            if (sOAPHeaderElement != null) {
                try {
                    string = (String)sOAPHeaderElement.getValueAsType(Constants.XSD_STRING);
                    if (string != null && !string.equals("")) {
                        wOContext._setRequestSessionID(string);
                        wOContext.session();
                        messageContext.setMaintainSession(true);
                    }
                }
                catch (Exception exception) {
                    throw AxisFault.makeFault((Exception)exception);
                }
            }
            if (NSLog.debugLoggingAllowedForLevelAndGroups((int)3, (long)0x10000000L)) {
                NSLog.debug.appendln((Object)("WOServerSessionHandler.doServer - getting session ID from request: " + string));
            }
            if ((sOAPHeaderElement = sOAPEnvelope.getHeaderByName(instanceHeaderQName.getNamespaceURI(), instanceHeaderQName.getLocalPart())) != null) {
                try {
                    string = (String)sOAPHeaderElement.getValueAsType(Constants.XSD_STRING);
                    if (string != null && !string.equals("")) {
                        wOContext.request()._setApplicationNumber(Integer.parseInt(string), false);
                    }
                }
                catch (Exception exception) {
                    throw AxisFault.makeFault((Exception)exception);
                }
            }
            if (NSLog.debugLoggingAllowedForLevelAndGroups((int)3, (long)0x10000000L)) {
                NSLog.debug.appendln((Object)("WOServerSessionHandler.doServer - getting instance ID from request: " + string));
            }
            messageContext.setSession((Session)new WOAxisSession(wOContext));
        }
    }

    public void onFault(MessageContext messageContext) {
        if (NSLog.debugLoggingAllowedForLevelAndGroups((int)2, (long)0x10000000L)) {
            NSLog.debug.appendln((Object)"WOServerSessionHandler.undo");
        }
    }
}

