/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.appserver._private;

import com.webobjects.appserver.WOAssociation;
import com.webobjects.appserver.WOComponent;
import com.webobjects.appserver.WOContext;
import com.webobjects.appserver.WODynamicElement;
import com.webobjects.appserver.WOElement;
import com.webobjects.appserver.WOResponse;
import com.webobjects.appserver._private.WODynamicElementCreationException;
import com.webobjects.appserver._private.WOFormatterRepository;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSLog;
import java.text.Format;

public class WOString
extends WODynamicElement {
    WOAssociation _dateFormat;
    WOAssociation _numberFormat;
    WOAssociation _formatter;
    WOAssociation _value;
    WOAssociation _escapeHTML;
    WOAssociation _valueWhenEmpty;
    boolean _shouldFormat;

    public WOString(String string, NSDictionary nSDictionary, WOElement wOElement) {
        super(null, null, null);
        this._value = (WOAssociation)nSDictionary.objectForKey((Object)"value");
        if (this._value == null) {
            throw new WODynamicElementCreationException("<" + this.getClass().getName() + "> ( no 'value' attribute specified.");
        }
        this._valueWhenEmpty = (WOAssociation)nSDictionary.objectForKey((Object)"valueWhenEmpty");
        this._escapeHTML = (WOAssociation)nSDictionary.objectForKey((Object)"escapeHTML");
        this._dateFormat = (WOAssociation)nSDictionary.objectForKey((Object)"dateformat");
        this._numberFormat = (WOAssociation)nSDictionary.objectForKey((Object)"numberformat");
        this._formatter = (WOAssociation)nSDictionary.objectForKey((Object)"formatter");
        this._shouldFormat = this._dateFormat != null || this._numberFormat != null || this._formatter != null;
        if (this._dateFormat != null && this._numberFormat != null || this._formatter != null && this._dateFormat != null || this._formatter != null && this._numberFormat != null) {
            throw new WODynamicElementCreationException("<" + this.getClass().getName() + "> ( cannot have 'dateFormat' and 'numberFormat' or 'formatter' attributes at the same time.");
        }
    }

    public void appendToResponse(WOResponse wOResponse, WOContext wOContext) {
        Object var3_3 = null;
        String string = null;
        WOComponent wOComponent = wOContext.component();
        Object object = null;
        if (this._value != null) {
            Format format;
            object = this._value.valueInComponent(wOComponent);
            if (this._shouldFormat && (format = WOFormatterRepository.formatterForInstance(object, wOComponent, this._dateFormat, this._numberFormat, this._formatter)) != null) {
                try {
                    object = format.format(object);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    NSLog._conditionallyLogPrivateException((Throwable)illegalArgumentException);
                    object = null;
                }
            }
        } else {
            NSLog.err.appendln((Object)"<WOString | appendToResponse> WARNING value binding is null !");
        }
        if (object != null) {
            string = object.toString();
        }
        if ((string == null || string.length() == 0) && this._valueWhenEmpty != null) {
            string = (String)this._valueWhenEmpty.valueInComponent(wOComponent);
            wOResponse.appendContentString(string);
        } else if (string != null) {
            boolean bl = true;
            if (this._escapeHTML != null) {
                bl = this._escapeHTML.booleanValueInComponent(wOComponent);
            }
            if (bl) {
                wOResponse.appendContentHTMLString(string);
            } else {
                wOResponse.appendContentString(string);
            }
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<");
        stringBuffer.append(this.getClass().getName());
        stringBuffer.append(" dateFormat=" + this._dateFormat);
        stringBuffer.append(" numberFormat=" + this._numberFormat);
        stringBuffer.append(" formatter=" + this._formatter);
        stringBuffer.append(" value=" + this._value);
        stringBuffer.append(" escapeHTML=" + this._escapeHTML);
        stringBuffer.append(" valueWhenEmpty=" + this._valueWhenEmpty);
        stringBuffer.append(" shouldFormat=" + this._shouldFormat);
        stringBuffer.append(">");
        return stringBuffer.toString();
    }
}

