/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.appserver._private;

import com.webobjects.appserver.WOActionResults;
import com.webobjects.appserver.WOAssociation;
import com.webobjects.appserver.WOComponent;
import com.webobjects.appserver.WOContext;
import com.webobjects.appserver.WOElement;
import com.webobjects.appserver.WORequest;
import com.webobjects.appserver.WOResponse;
import com.webobjects.appserver._private.WOConstantValueAssociation;
import com.webobjects.appserver._private.WODynamicElementCreationException;
import com.webobjects.appserver._private.WOInput;
import com.webobjects.foundation.NSDictionary;

public class WOSubmitButton
extends WOInput {
    protected WOAssociation _action;
    protected WOAssociation _actionClass;
    protected WOAssociation _directActionName;

    public WOSubmitButton(String string, NSDictionary nSDictionary, WOElement wOElement) {
        super("input", nSDictionary, (WOElement)null);
        if (this._value == null) {
            this._value = new WOConstantValueAssociation("Submit");
        }
        this._action = (WOAssociation)this._associations.removeObjectForKey((Object)"action");
        this._actionClass = (WOAssociation)this._associations.removeObjectForKey((Object)"actionClass");
        this._directActionName = (WOAssociation)this._associations.removeObjectForKey((Object)"directActionName");
        if (this._action != null && this._action.isValueConstant()) {
            throw new WODynamicElementCreationException("<" + this.getClass().getName() + ">'action' is a constant.");
        }
        if (this._action != null && this._directActionName != null || this._action != null && this._actionClass != null) {
            throw new WODynamicElementCreationException("<" + this.getClass().getName() + "> Either 'action' and 'directActionName' both exist, or 'action' and 'actionClass' both exist ");
        }
    }

    protected String type() {
        return "submit";
    }

    public String toString() {
        return "<WOSubmitButton  action: " + (this._action != null ? this._action.toString() : "null") + " actionClass: " + (this._actionClass != null ? this._actionClass.toString() : "null") + ">";
    }

    public void takeValuesFromRequest(WORequest wORequest, WOContext wOContext) {
    }

    public WOActionResults invokeAction(WORequest wORequest, WOContext wOContext) {
        WOActionResults wOActionResults = null;
        WOComponent wOComponent = wOContext.component();
        if (!this.disabledInComponent(wOComponent) && wOContext._wasFormSubmitted()) {
            if (wOContext._isMultipleSubmitForm()) {
                if (wORequest.formValueForKey(this.nameInContext(wOContext, wOComponent)) != null) {
                    wOContext._setActionInvoked(true);
                    if (this._action != null) {
                        wOActionResults = (WOActionResults)this._action.valueInComponent(wOComponent);
                    }
                    if (wOActionResults == null) {
                        wOActionResults = wOContext.page();
                    }
                }
            } else {
                wOContext._setActionInvoked(true);
                if (this._action != null) {
                    wOActionResults = (WOActionResults)this._action.valueInComponent(wOComponent);
                }
                if (wOActionResults == null) {
                    wOActionResults = wOContext.page();
                }
            }
        }
        return wOActionResults;
    }

    private String _actionClassAndName(WOContext wOContext) {
        String string = this.computeActionStringInContext(this._actionClass, this._directActionName, wOContext);
        return string;
    }

    protected void _appendNameAttributeToResponse(WOResponse wOResponse, WOContext wOContext) {
        if (this._directActionName != null || this._actionClass != null) {
            wOResponse._appendTagAttributeAndValue("name", this._actionClassAndName(wOContext), false);
        } else {
            super._appendNameAttributeToResponse(wOResponse, wOContext);
        }
    }

    public void appendToResponse(WOResponse wOResponse, WOContext wOContext) {
        super.appendToResponse(wOResponse, wOContext);
        if (this._directActionName != null || this._actionClass != null) {
            wOResponse._appendContentAsciiString("<input type=\"hidden\" name=\"WOSubmitAction\"");
            wOResponse._appendTagAttributeAndValue("value", this._actionClassAndName(wOContext), false);
            wOResponse.appendContentCharacter('>');
        }
    }

    protected void _appendCloseTagToResponse(WOResponse wOResponse, WOContext wOContext) {
    }
}

