/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.appserver._private;

import com.webobjects.appserver.WOAssociation;
import com.webobjects.appserver.WOComponent;
import com.webobjects.appserver.WOContext;
import com.webobjects.appserver.WOElement;
import com.webobjects.appserver.WORequest;
import com.webobjects.appserver.WOResponse;
import com.webobjects.appserver._private.WODynamicElementCreationException;
import com.webobjects.appserver._private.WOFormatterRepository;
import com.webobjects.appserver._private.WOInput;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSLog;
import com.webobjects.foundation.NSValidation;
import java.math.BigDecimal;
import java.text.Format;
import java.text.ParseException;

public class WOTextField
extends WOInput {
    WOAssociation _formatter;
    WOAssociation _dateFormat;
    WOAssociation _numberFormat;
    WOAssociation _useDecimalNumber;

    public WOTextField(String string, NSDictionary nSDictionary, WOElement wOElement) {
        super("input", nSDictionary, (WOElement)null);
        if (this._value == null || !this._value.isValueSettable()) {
            throw new WODynamicElementCreationException("<" + this.getClass().getName() + "> 'value' attribute not present or is a constant");
        }
        this._formatter = (WOAssociation)this._associations.removeObjectForKey((Object)"formatter");
        this._dateFormat = (WOAssociation)this._associations.removeObjectForKey((Object)"dateformat");
        this._numberFormat = (WOAssociation)this._associations.removeObjectForKey((Object)"numberformat");
        this._useDecimalNumber = (WOAssociation)this._associations.removeObjectForKey((Object)"useDecimalNumber");
        if (this._dateFormat != null && this._numberFormat != null) {
            throw new WODynamicElementCreationException("<" + this.getClass().getName() + "> Cannot have 'dateFormat' and 'numberFormat' attributes at the same time.");
        }
    }

    protected String type() {
        return "text";
    }

    public void takeValuesFromRequest(WORequest wORequest, WOContext wOContext) {
        String string = null;
        Object object = null;
        String string2 = null;
        WOComponent wOComponent = wOContext.component();
        if (!this.disabledInComponent(wOComponent) && wOContext._wasFormSubmitted() && (string2 = this.nameInContext(wOContext, wOComponent)) != null) {
            string = wORequest.stringFormValueForKey(string2);
            object = string;
            if (string != null) {
                Format format = null;
                if (string.length() != 0) {
                    format = WOFormatterRepository.formatterForComponent(wOComponent, this._dateFormat, this._numberFormat, this._formatter);
                }
                if (format != null) {
                    try {
                        Object object2 = format.parseObject(string);
                        String string3 = format.format(object2);
                        object = format.parseObject(string3);
                    }
                    catch (ParseException parseException) {
                        String string4 = this._value.keyPath();
                        NSValidation.ValidationException validationException = new NSValidation.ValidationException(parseException.getMessage(), (Object)string, string4);
                        wOComponent.validationFailedWithException(validationException, string, string4);
                        return;
                    }
                    if (object != null && this._useDecimalNumber != null && this._useDecimalNumber.booleanValueInComponent(wOComponent)) {
                        object = new BigDecimal(object.toString());
                    }
                } else if (object.toString().length() == 0) {
                    object = null;
                }
            }
            this._value.setValue(object, wOComponent);
        }
    }

    protected void _appendValueAttributeToResponse(WOResponse wOResponse, WOContext wOContext) {
        WOComponent wOComponent = wOContext.component();
        Object object = this._value.valueInComponent(wOComponent);
        if (object != null) {
            String string = null;
            Format format = WOFormatterRepository.formatterForInstance(object, wOComponent, this._dateFormat, this._numberFormat, this._formatter);
            if (format != null) {
                try {
                    String string2 = format.format(object);
                    Object object2 = format.parseObject(string2);
                    string = format.format(object2);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    NSLog._conditionallyLogPrivateException((Throwable)illegalArgumentException);
                    string = null;
                }
                catch (ParseException parseException) {
                    NSLog._conditionallyLogPrivateException((Throwable)parseException);
                    string = null;
                }
            }
            if (string == null) {
                string = object.toString();
            }
            wOResponse._appendTagAttributeAndValue("value", string, true);
        }
    }

    protected void _appendCloseTagToResponse(WOResponse wOResponse, WOContext wOContext) {
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<");
        stringBuffer.append(this.getClass().getName());
        stringBuffer.append(" formatter=" + this._formatter);
        stringBuffer.append(" dateFormat=" + this._dateFormat);
        stringBuffer.append(" numberFormat=" + this._numberFormat);
        stringBuffer.append(" useDecimalNumber=" + this._useDecimalNumber);
        stringBuffer.append(">");
        return stringBuffer.toString();
    }
}

