/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.appserver._private;

import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation._NSUtilities;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;

public class WOURLEncoder {
    public static final String PARAM_WOURLENCODING = "WOURLEncoding";
    public static String WO_URL_ENCODING = _NSUtilities.ISOLatin1StringEncoding;
    private static final char[][] QUERY_URIC_256;

    public static String encode(String string) {
        return WOURLEncoder.encode(string, WO_URL_ENCODING);
    }

    public static String encode(String string, String string2) {
        byte[] byArray;
        try {
            byArray = string.getBytes(string2);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new IllegalStateException("The character encoding supplied " + string2 + "is either not supported or can't be used to encode the URL.");
        }
        StringBuffer stringBuffer = new StringBuffer(byArray.length * 2);
        for (int i = 0; i < byArray.length; ++i) {
            stringBuffer.append(QUERY_URIC_256[byArray[i] & 0xFF]);
        }
        return stringBuffer.toString();
    }

    public static String encodeAsCGIFormValues(NSDictionary nSDictionary) {
        String string = (String)nSDictionary.objectForKey((Object)PARAM_WOURLENCODING);
        if (string == null) {
            string = WO_URL_ENCODING;
        }
        NSMutableArray nSMutableArray = WOURLEncoder._encodeAsCGIFormValues(nSDictionary, null, string);
        return nSMutableArray.componentsJoinedByString("&amp;");
    }

    private static NSMutableArray _encodeAsCGIFormValues(Object object, String string, String string2) {
        NSMutableArray nSMutableArray = null;
        if (object != null) {
            if (object instanceof NSDictionary) {
                nSMutableArray = WOURLEncoder._encodeAsCGIFormValues((NSDictionary)object, string, string2);
            } else if (object instanceof NSArray) {
                nSMutableArray = WOURLEncoder._encodeAsCGIFormValues((NSArray)object, string, string2);
            } else {
                String string3 = object.toString();
                String string4 = WOURLEncoder.encode(string3, string2);
                String string5 = string + "=" + string4;
                nSMutableArray = new NSMutableArray();
                nSMutableArray.addObject((Object)string5);
            }
        }
        return nSMutableArray;
    }

    private static NSMutableArray _encodeAsCGIFormValues(NSDictionary nSDictionary, String string, String string2) {
        Enumeration enumeration = nSDictionary.keyEnumerator();
        NSMutableArray nSMutableArray = new NSMutableArray(nSDictionary.count());
        while (enumeration.hasMoreElements()) {
            String string3 = (String)enumeration.nextElement();
            Object object = nSDictionary.objectForKey((Object)string3);
            String string4 = WOURLEncoder.encode(string3, string2);
            String string5 = string != null ? string + "." + string4 : string4;
            NSMutableArray nSMutableArray2 = WOURLEncoder._encodeAsCGIFormValues(object, string5, string2);
            nSMutableArray.addObjectsFromArray((NSArray)nSMutableArray2);
        }
        return nSMutableArray;
    }

    private static NSMutableArray _encodeAsCGIFormValues(NSArray nSArray, String string, String string2) {
        int n = nSArray.count();
        NSMutableArray nSMutableArray = new NSMutableArray(n);
        for (int i = 0; i < n; ++i) {
            Object object = nSArray.objectAtIndex(i);
            NSMutableArray nSMutableArray2 = WOURLEncoder._encodeAsCGIFormValues(object, string, string2);
            nSMutableArray.addObjectsFromArray((NSArray)nSMutableArray2);
        }
        return nSMutableArray;
    }

    static {
        char[] cArray = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        QUERY_URIC_256 = new char[256][];
        for (char c = '\u0000'; c < '\u0100'; c = (char)((char)(c + 1))) {
            WOURLEncoder.QUERY_URIC_256[c] = c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '-' || c == '_' || c == '.' || c == '*' ? new char[]{c} : (c == ' ' ? new char[]{'+'} : new char[]{'%', cArray[c >> 4], cArray[c & 0xF]});
        }
    }
}

