/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.appserver._private;

import com.webobjects.appserver.WOApplication;
import com.webobjects.foundation.NSLog;
import com.webobjects.foundation._NSCollectionPrimitives;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Random;

public class WOUniqueIDGenerator {
    private long counter = 0L;
    private Random random;
    private MessageDigest digester;
    private int woAppHash;
    private int woPort;
    private boolean doDigest = true;
    private byte[] basicSeedCache;
    private static final int BasicSeedBufferSize = 24;
    private static final int RandomBufferSize = 8;
    private static final int IPAddressBufferSize = 4;
    private static final String PRNGName = "SHA1PRNG";
    private static WOUniqueIDGenerator _SharedInstance;
    private static final char[] _Chars;

    public static WOUniqueIDGenerator sharedInstance() {
        return _SharedInstance;
    }

    private WOUniqueIDGenerator() {
        WOApplication wOApplication = WOApplication.application();
        this.woAppHash = System.identityHashCode(wOApplication);
        Number number = wOApplication.port();
        this.woPort = number != null ? number.intValue() : 42;
        this.random = new Random();
        byte[] byArray = wOApplication.hostAddress().getAddress();
        if (byArray == null) {
            try {
                byArray = InetAddress.getLocalHost().getAddress();
            }
            catch (UnknownHostException unknownHostException) {
                NSLog._conditionallyLogPrivateException((Throwable)unknownHostException);
                byArray = new byte[4];
                for (int i = 0; i < 4; ++i) {
                    byArray[i] = 42;
                }
            }
        }
        long l = System.currentTimeMillis();
        this.basicSeedCache = new byte[12];
        System.arraycopy(byArray, 0, this.basicSeedCache, 0, 4);
        int n = 4;
        _NSCollectionPrimitives.copyIntoBuffer((byte[])this.basicSeedCache, (int)n, (int)this.woAppHash);
        _NSCollectionPrimitives.copyIntoBuffer((byte[])this.basicSeedCache, (int)(n += 4), (int)this.woPort);
        n += 4;
        if (this.random instanceof SecureRandom) {
            byte[] byArray2 = new byte[24];
            this.basicSeedInformation(byArray2, l);
            ((SecureRandom)this.random).setSeed(byArray2);
        } else {
            long l2 = (long)this.woPort & 0xFFFFL;
            int n2 = byArray[2] & 0xFFFF;
            int n3 = byArray[3] & 0xFFFF;
            long l3 = (long)(n2 << 16 | n3) & 0xFFFFFFFFL;
            this.random.setSeed(l ^ (l3 << 32 | l2));
        }
        try {
            this.digester = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            if (NSLog.debugLoggingAllowedForLevel((int)1)) {
                NSLog.debug.appendln((Object)(this.getClass().getName() + ": Unable to find \"MD5\" MessageDigest class.  No secure hashing performed on WOSession IDs!!!"));
                NSLog.debug.appendln((Throwable)noSuchAlgorithmException);
            }
            this.doDigest = false;
        }
    }

    private void basicSeedInformation(byte[] byArray, long l) {
        int n = this.basicSeedCache.length;
        System.arraycopy(this.basicSeedCache, 0, byArray, 0, n);
        int n2 = n;
        _NSCollectionPrimitives.copyIntoBuffer((byte[])byArray, (int)n2, (long)l);
        int n3 = System.identityHashCode(Thread.currentThread());
        _NSCollectionPrimitives.copyIntoBuffer((byte[])byArray, (int)(n2 += 8), (int)n3);
    }

    public String longUniqueID() {
        return this.longUniqueID(System.currentTimeMillis());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String longUniqueID(long l) {
        byte[] byArray;
        byte[] byArray2 = new byte[8];
        byte[] byArray3 = new byte[40];
        this.basicSeedInformation(byArray3, l);
        int n = 32;
        WOUniqueIDGenerator wOUniqueIDGenerator = _SharedInstance;
        synchronized (wOUniqueIDGenerator) {
            long l2 = ++this.counter;
            _NSCollectionPrimitives.copyIntoBuffer((byte[])byArray3, (int)n, (long)l2);
            this.random.nextBytes(byArray2);
            System.arraycopy(byArray2, 0, byArray3, 24, 8);
            if (this.doDigest) {
                this.digester.update(byArray3);
                byArray = this.digester.digest();
            } else {
                byArray = byArray3;
            }
        }
        return this.encodeAsSixBitASCII(byArray);
    }

    private String encodeAsSixBitASCII(byte[] byArray) {
        int n;
        int n2;
        int n3 = byArray.length;
        char[] cArray = new char[(n3 << 2) / 3 + 1];
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = n3 / 3 * 3;
        while (n4 < n7) {
            n2 = byArray[n4++] & 0xFF;
            n = n2 >> 2;
            n6 = n2 & 3;
            cArray[n5++] = _Chars[n];
            n2 = byArray[n4++] & 0xFF;
            n = n6 << 4 | n2 >> 4;
            n6 = n2 & 0xF;
            cArray[n5++] = _Chars[n];
            n2 = byArray[n4++] & 0xFF;
            n = n6 << 2 | n2 >> 6;
            n6 = n2 & 0x3F;
            cArray[n5++] = _Chars[n];
            cArray[n5++] = _Chars[n6];
        }
        int n8 = n3 % 3;
        if (n8 != 0) {
            n2 = byArray[n4++] & 0xFF;
            n = n2 >> 2;
            n6 = n2 & 3;
            cArray[n5++] = _Chars[n];
            if (n8 == 1) {
                n = n6 << 4;
                cArray[n5++] = _Chars[n];
            } else {
                n2 = byArray[n4++] & 0xFF;
                n = n6 << 4 | n2 >> 4;
                n6 = n2 & 0xF;
                cArray[n5++] = _Chars[n];
                n = n6 << 2;
                cArray[n5++] = _Chars[n];
            }
        }
        return new String(cArray, 0, n5);
    }

    static {
        block2: {
            _Chars = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'b', 't'};
            try {
                _SharedInstance = new WOUniqueIDGenerator();
            }
            catch (Exception exception) {
                NSLog.err.appendln((Object)("<WOUniqueIDGenerator> Exception during static initialization: " + exception.toString()));
                if (!NSLog.debugLoggingAllowedForLevel((int)1)) break block2;
                NSLog.debug.appendln((Throwable)exception);
            }
        }
    }
}

