/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.appserver._private;

import com.webobjects.appserver.WOAction;
import com.webobjects.appserver.WOActionResults;
import com.webobjects.appserver.WOApplication;
import com.webobjects.appserver.WOContext;
import com.webobjects.appserver.WORequest;
import com.webobjects.appserver.WOResponse;
import com.webobjects.appserver.WOWebServiceRegistrar;
import com.webobjects.appserver.WOWebServiceUtilities;
import com.webobjects.appserver._private.WOProperties;
import com.webobjects.appserver._private.WOWebServiceRequestHandler;
import com.webobjects.foundation.NSBundle;
import com.webobjects.foundation.NSData;
import com.webobjects.foundation.NSForwardException;
import com.webobjects.foundation.NSLog;
import com.webobjects.foundation.NSMutableDictionary;
import com.webobjects.foundation._NSReadReentrantReaderWriterLock;
import com.webobjects.webservices.support.WOXMLProvider;
import com.webobjects.webservices.support._private.WOSecurityHandler;
import com.webobjects.webservices.support._private.WOWSSupport;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.reflect.Method;
import java.util.Properties;
import javax.xml.namespace.QName;
import javax.xml.rpc.encoding.DeserializerFactory;
import javax.xml.rpc.encoding.SerializerFactory;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.URIResolver;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.axis.AxisEngine;
import org.apache.axis.AxisFault;
import org.apache.axis.ConfigurationException;
import org.apache.axis.EngineConfiguration;
import org.apache.axis.Handler;
import org.apache.axis.Message;
import org.apache.axis.MessageContext;
import org.apache.axis.SimpleChain;
import org.apache.axis.deployment.wsdd.WSDDDeployment;
import org.apache.axis.deployment.wsdd.WSDDException;
import org.apache.axis.deployment.wsdd.WSDDService;
import org.apache.axis.encoding.TypeMappingRegistry;
import org.apache.axis.handlers.soap.SOAPService;
import org.apache.axis.message.SOAPBodyElement;
import org.apache.axis.message.SOAPFault;
import org.apache.axis.server.AxisServer;
import org.apache.axis.transport.http.HTTPConstants;
import org.apache.axis.utils.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class WOWebService
extends WOAction {
    private static String TransformerFactoryPropertyName = "javax.xml.transform.TransformerFactory";
    private static String DefaultTransformerClassName = "org.apache.xalan.processor.TransformerFactoryImpl";
    static WOXMLProvider provider = null;
    static AxisServer engine = null;
    static _NSReadReentrantReaderWriterLock engineLock = new _NSReadReentrantReaderWriterLock();
    static boolean showWSDL = Boolean.getBoolean(WOProperties._GenerateWSDLKey);
    static TransformerFactory transformerFactory = null;
    static NSMutableDictionary transformerDict = new NSMutableDictionary(4);
    static Transformer nullTransformer = new NullTransformer();
    protected static Class D2WSClass = null;
    protected static Method D2WSWSDLMethod = null;

    static Document getDeploymentDocument() {
        Document document;
        InputStream inputStream;
        block7: {
            inputStream = null;
            document = null;
            try {
                inputStream = new FileInputStream(NSBundle.mainBundle().bundlePath() + "/Contents/Resources/server.wsdd");
            }
            catch (FileNotFoundException fileNotFoundException) {
                inputStream = WOWebServiceRequestHandler.class.getResourceAsStream(NSBundle.mainBundle().bundlePath() + "/Contents/Resources/server.wsdd");
            }
            if (inputStream != null) {
                try {
                    document = XMLUtils.newDocument((InputStream)inputStream);
                }
                catch (Exception exception) {
                    if (!NSLog.debugLoggingAllowedForLevelAndGroups((int)3, (long)0x10000000L)) break block7;
                    NSLog.debug.appendln((Object)"Couldn't parse .wsdd file");
                    NSLog.debug.appendln((Throwable)exception);
                }
            }
        }
        if (document == null) {
            if (NSLog.debugLoggingAllowedForLevelAndGroups((int)3, (long)0x10000000L)) {
                NSLog.debug.appendln((Object)("Couldn't " + (inputStream == null ? "find" : "parse") + " .wsdd file. Using empty default."));
            }
            document = WOWebServiceRegistrar._getEmptyDeployment();
        }
        return document;
    }

    static void initServer() {
        try {
            if (engine == null) {
                Document document = WOWebService.getDeploymentDocument();
                provider = new WOXMLProvider(document);
                engine = new AxisServer((EngineConfiguration)provider);
                TypeMappingRegistry typeMappingRegistry = engine.getTypeMappingRegistry();
                WOWSSupport._registerSerializersForAllMappingsInRegistry((TypeMappingRegistry)typeMappingRegistry);
            }
            WOWebServiceUtilities._setEngine((AxisEngine)engine);
        }
        catch (Exception exception) {
            NSLog.err.appendln((Object)("Error trying to deploy Axis engine " + exception));
            if (NSLog.debugLoggingAllowedForLevelAndGroups((int)1, (long)0x10000004L)) {
                NSLog.err.appendln((Throwable)exception);
            }
            System.exit(1);
        }
    }

    static void initD2WSWSDLStuff() {
        if (D2WSClass == null) {
            try {
                D2WSClass = Class.forName("com.webobjects.webservices.generation._WSRuleUtilities");
                Class[] classArray = new Class[]{String.class, WOContext.class};
                D2WSWSDLMethod = D2WSClass.getMethod("generateWSDLForService", classArray);
            }
            catch (Exception exception) {
                NSLog.err.appendln((Object)"Failed to get methods for Direct2WebServices. This application must link against the D2WebServices framework to run.");
                if (NSLog.debugLoggingAllowedForLevelAndGroups((int)1, (long)0x10000004L)) {
                    NSLog.err.appendln((Throwable)exception);
                }
                System.exit(1);
            }
        }
    }

    public static void registerService(Element element) {
        block3: {
            if (engine == null) {
                WOWebService.initServer();
            }
            WSDDDeployment wSDDDeployment = provider.getDeployment();
            try {
                WSDDService wSDDService = new WSDDService(element);
                wSDDDeployment.deployService(wSDDService);
                String string = element.getAttribute("name");
                WOWebServiceRegistrar._registeredServiceNames.add(string);
            }
            catch (WSDDException wSDDException) {
                NSLog.err.appendln((Object)("Error dynamically deploying service " + element.getAttribute("name")));
                if (!NSLog.debugLoggingAllowedForLevelAndGroups((int)2, (long)0x10000000L)) break block3;
                NSLog.err.appendln((Throwable)wSDDException);
            }
        }
    }

    public static void deregisterServiceWithName(String string) {
        if (engine == null) {
            WOWebService.initServer();
        }
        WSDDDeployment wSDDDeployment = provider.getDeployment();
        wSDDDeployment.undeployService(new QName("", string));
        WOWebServiceRegistrar._registeredServiceNames.remove(string);
    }

    public static void registerSerializerAndDeserializerFactoriesForClassWithQName(SerializerFactory serializerFactory, DeserializerFactory deserializerFactory, Class clazz, QName qName) {
        if (engine == null) {
            WOWebService.initServer();
        }
        TypeMappingRegistry typeMappingRegistry = engine.getTypeMappingRegistry();
        WOWSSupport._registerSerializersAndDeserializersForAllMappingsInRegistry((SerializerFactory)serializerFactory, (DeserializerFactory)deserializerFactory, (Class)clazz, (QName)qName, (TypeMappingRegistry)typeMappingRegistry);
    }

    public static void setSecurityDelegate(Object object) {
        if (engine == null) {
            WOWebService.initServer();
        }
        try {
            Handler handler;
            int n;
            SimpleChain simpleChain = (SimpleChain)engine.getGlobalRequest();
            Handler[] handlerArray = simpleChain.getHandlers();
            for (n = 0; n < handlerArray.length; ++n) {
                handler = handlerArray[n];
                if (!(handler instanceof WOSecurityHandler)) continue;
                ((WOSecurityHandler)handler).setDelegate(object);
                break;
            }
            simpleChain = (SimpleChain)engine.getGlobalResponse();
            handlerArray = simpleChain.getHandlers();
            for (n = 0; n < handlerArray.length; ++n) {
                handler = handlerArray[n];
                if (!(handler instanceof WOSecurityHandler)) continue;
                ((WOSecurityHandler)handler).setDelegate(object);
                break;
            }
        }
        catch (ConfigurationException configurationException) {
            NSLog.out.appendln((Object)"Exception accessing handlers");
            NSLog.err.appendln((Throwable)configurationException);
        }
    }

    public boolean isServiceD2WebService(String string) throws ConfigurationException {
        WSDDDeployment wSDDDeployment;
        if (engine == null) {
            WOWebService.initServer();
        }
        if ((wSDDDeployment = provider.getDeployment()) == null) {
            return false;
        }
        SOAPService sOAPService = wSDDDeployment.getService(new QName("", string));
        if (sOAPService == null) {
            return false;
        }
        String string2 = (String)sOAPService.getOption("className");
        return "com.webobjects.appserver._private.WODWSServiceObject".equals(string2);
    }

    public WOWebService(WORequest wORequest) {
        super(wORequest);
        WOWebService.initServer();
    }

    protected String defaultActionClassName() {
        return "WOWebService";
    }

    public String getSessionIDForRequest(WORequest wORequest) {
        return wORequest != null ? wORequest.cookieValueForKey("wosid") : null;
    }

    public WOActionResults performActionNamed(String string) {
        if (NSLog.debugLoggingAllowedForLevelAndGroups((int)2, (long)0x10000000L)) {
            NSLog.debug.appendln((Object)("WOWebService.performActionNamed " + string + " - Enter"));
        }
        WORequest wORequest = this.request();
        WOContext wOContext = this.context();
        WOResponse wOResponse = WOApplication.application().createResponseInContext(wOContext);
        wOContext._setResponse(wOResponse);
        wOResponse.setContentEncoding("UTF-8");
        MessageContext messageContext = new MessageContext((AxisEngine)engine);
        Message message = null;
        Message message2 = null;
        boolean bl = false;
        try {
            String string2;
            Object object;
            Object object2;
            String string3;
            try {
                messageContext.setTargetService(null);
                messageContext.setResponseMessage(null);
                messageContext.reset();
                string3 = System.getProperty("WOWebServiceTransportName", "http");
                messageContext.setTransportName(string3);
                messageContext.setProperty("com.webobjects.appserver.WOContext", (Object)wOContext);
                object2 = new StringBuffer();
                wORequest._completeURLPrefix((StringBuffer)object2, "https".equals(string3), 0);
                object = wORequest.uri();
                string2 = ((StringBuffer)object2).append((String)object).toString();
                if (wORequest.queryString() != null) {
                    string2 = string2.substring(0, string2.indexOf(wORequest.queryString()) - 1);
                }
                messageContext.setProperty("transport.url", (Object)string2);
                String string4 = wORequest.headerForKey("SOAPAction");
                if (string4 == null) {
                    string4 = "";
                }
                messageContext.setSOAPActionURI(string4);
                messageContext.setProperty(HTTPConstants.MC_HTTP_SERVLETPATHINFO, (Object)("/" + wORequest.requestHandlerPath()));
                messageContext.setProperty("Authorization", (Object)wORequest.headerForKey("Authorization"));
                messageContext.setProperty("remoteaddr", (Object)wORequest._remoteAddress());
                message = new Message((Object)wORequest.content().stream(), false, wORequest.headerForKey("content-type"), null);
                messageContext.setRequestMessage(message);
                String string5 = wORequest.queryString();
                if (string5 != null) {
                    if (string5.equalsIgnoreCase("wsdl")) {
                        if (showWSDL) {
                            if (this.isServiceD2WebService(string)) {
                                WOWebService.initD2WSWSDLStuff();
                                Object[] objectArray = new Object[]{string, wOContext};
                                wOResponse = (WOResponse)D2WSWSDLMethod.invoke((Object)D2WSClass, objectArray);
                                if (NSLog.debugLoggingAllowedForLevelAndGroups((int)3, (long)0x10000000L)) {
                                    NSLog.debug.appendln((Object)"Generated WSDL: ");
                                    NSLog.debug.appendln((Object)wOResponse.contentString());
                                }
                                if (NSLog.debugLoggingAllowedForLevelAndGroups((int)2, (long)0x10000000L)) {
                                    NSLog.debug.appendln((Object)"WOWebService.performActionNamed - Exit after WSDL generation");
                                }
                                wOResponse.setHeader("text/xml; charset=utf-8", "content-type");
                            } else {
                                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                                PrintWriter printWriter = new PrintWriter(byteArrayOutputStream);
                                engine.generateWSDL(messageContext);
                                Document document = (Document)messageContext.getProperty("WSDL");
                                if (document != null) {
                                    wOResponse.setHeader("text/xml; charset=utf-8", "content-type");
                                    XMLUtils.DocumentToWriter((Document)document, (Writer)printWriter);
                                    ((Writer)printWriter).close();
                                    wOResponse.setContent(new NSData(byteArrayOutputStream.toByteArray()));
                                    if (NSLog.debugLoggingAllowedForLevelAndGroups((int)3, (long)0x10000000L)) {
                                        NSLog.debug.appendln((Object)"Generated WSDL: ");
                                        NSLog.debug.appendln(byteArrayOutputStream.toByteArray());
                                    }
                                    if (NSLog.debugLoggingAllowedForLevelAndGroups((int)2, (long)0x10000000L)) {
                                        NSLog.debug.appendln((Object)"WOWebService.performActionNamed - Exit after WSDL generation");
                                    }
                                }
                            }
                        } else {
                            throw new AxisFault("Server error.");
                        }
                    }
                    return wOResponse;
                }
                engine.invoke(messageContext);
                message2 = messageContext.getResponseMessage();
                if (message2 == null) {
                    throw new AxisFault("No response received");
                }
            }
            catch (Exception exception) {
                object2 = exception instanceof AxisFault ? (AxisFault)((Object)exception) : AxisFault.makeFault((Exception)exception);
                NSLog.err.appendln((Throwable)object2);
                message2 = messageContext.getResponseMessage();
                if (message2 == null) {
                    message2 = new Message(object2);
                } else {
                    try {
                        object = message2.getSOAPEnvelope();
                        object.clearBody();
                        object.addBodyElement((SOAPBodyElement)new SOAPFault((AxisFault)((Object)exception)));
                    }
                    catch (AxisFault axisFault) {
                        // empty catch block
                    }
                }
                wOResponse.setStatus(500);
            }
            string3 = message2.getSOAPPartAsString();
            if (wOResponse.status() != 500) {
                object2 = messageContext.getService().getServiceDescription();
                object = messageContext.getOperation();
                string2 = null;
                string2 = object != null ? object.getName() : (String)messageContext.getProperty("com.webobjects.d2ws.operationName");
                if (object2 != null && string2 != null) {
                    string3 = WOWebService.performXSLTTransformOnResponseForServiceAndOperation(string3, object2.getName(), string2);
                }
            }
            wOResponse.setHeader("text/xml; charset=utf-8", "content-type");
            wOResponse.setContent(string3);
        }
        catch (Exception exception) {
            NSLog.err.appendln((Object)("Exception in WOWebService.performActionName: " + exception));
            if (NSLog.debugLoggingAllowedForLevelAndGroups((int)2, (long)0x10000000L)) {
                NSLog.err.appendln((Throwable)exception);
            }
            throw NSForwardException._runtimeExceptionForThrowable((Throwable)exception);
        }
        if (NSLog.debugLoggingAllowedForLevelAndGroups((int)2, (long)0x10000000L)) {
            NSLog.debug.appendln((Object)"WOWebService.performActionNamed - Exit");
        }
        return wOResponse;
    }

    private static Transformer getRegisteredTransformerForServiceAndOperation(String string, String string2) {
        NSMutableDictionary nSMutableDictionary = (NSMutableDictionary)transformerDict.objectForKey((Object)string);
        if (nSMutableDictionary != null) {
            return (Transformer)nSMutableDictionary.objectForKey((Object)string2);
        }
        return null;
    }

    private static void registerTransformerForServiceAndOperation(String string, String string2, Transformer transformer) {
        NSMutableDictionary nSMutableDictionary = (NSMutableDictionary)transformerDict.objectForKey((Object)string);
        if (nSMutableDictionary == null) {
            nSMutableDictionary = new NSMutableDictionary(8);
            transformerDict.setObjectForKey((Object)nSMutableDictionary, (Object)string);
        }
        nSMutableDictionary.setObjectForKey((Object)transformer, (Object)string2);
    }

    public static void registerTransformerForSourceServiceAndOperation(Source source, String string, String string2) {
        Transformer transformer = WOWebService.getTransformerForSourceServiceAndOperation(source, string, string2);
        NSMutableDictionary nSMutableDictionary = (NSMutableDictionary)transformerDict.objectForKey((Object)string);
        if (nSMutableDictionary == null) {
            nSMutableDictionary = new NSMutableDictionary(8);
            transformerDict.setObjectForKey((Object)nSMutableDictionary, (Object)string);
        }
        nSMutableDictionary.setObjectForKey((Object)transformer, (Object)string2);
    }

    private static Source getSourceForServiceAndOperation(String string, String string2) {
        InputStream inputStream = null;
        try {
            inputStream = new FileInputStream(NSBundle.mainBundle().bundlePath() + "/Contents/Resources/" + string + "_" + string2 + ".xslt");
        }
        catch (FileNotFoundException fileNotFoundException) {
            inputStream = WOWebServiceRequestHandler.class.getResourceAsStream(NSBundle.mainBundle().bundlePath() + "/Contents/Resources" + string + "_" + string2 + ".xslt");
        }
        if (inputStream == null) {
            return null;
        }
        return new StreamSource(inputStream);
    }

    private static Transformer getTransformerForSourceServiceAndOperation(Source source, String string, String string2) {
        Transformer transformer;
        block4: {
            transformer = null;
            if (source == null) {
                WOWebService.registerTransformerForServiceAndOperation(string, string2, nullTransformer);
            } else {
                try {
                    transformer = transformerFactory.newTransformer(source);
                    WOWebService.registerTransformerForServiceAndOperation(string, string2, transformer);
                }
                catch (TransformerConfigurationException transformerConfigurationException) {
                    transformer = null;
                    WOWebService.registerTransformerForServiceAndOperation(string, string2, nullTransformer);
                    NSLog.err.appendln((Object)("TransformerConfigurationException for: " + string + "_" + string2));
                    if (!NSLog.debugLoggingAllowedForLevelAndGroups((int)2, (long)0x10000000L)) break block4;
                    NSLog.err.appendln((Throwable)transformerConfigurationException);
                }
            }
        }
        return transformer;
    }

    private static Transformer getTransformerForServiceAndOperation(String string, String string2) {
        Transformer transformer = WOWebService.getRegisteredTransformerForServiceAndOperation(string, string2);
        if (transformer == nullTransformer) {
            return null;
        }
        if (transformer == null) {
            Source source = WOWebService.getSourceForServiceAndOperation(string, string2);
            transformer = WOWebService.getTransformerForSourceServiceAndOperation(source, string, string2);
        }
        return transformer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String performXSLTTransformOnResponseForServiceAndOperation(String string, String string2, String string3) {
        String string4;
        block9: {
            if (NSLog.debugLoggingAllowedForLevelAndGroups((int)3, (long)0x10000000L)) {
                NSLog.debug.appendln((Object)"Trying to transform: ");
                NSLog.debug.appendln((Object)string);
            }
            string4 = "";
            Transformer transformer = WOWebService.getTransformerForServiceAndOperation(string2, string3);
            if (transformer != null) {
                StreamSource streamSource = new StreamSource(new ByteArrayInputStream(string.getBytes()));
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(string.length());
                StreamResult streamResult = new StreamResult(byteArrayOutputStream);
                try {
                    Transformer transformer2 = transformer;
                    synchronized (transformer2) {
                        transformer.transform(streamSource, streamResult);
                    }
                    string4 = new String(byteArrayOutputStream.toByteArray());
                }
                catch (TransformerException transformerException) {
                    NSLog.err.appendln((Object)("TransformerException for: " + string2 + "_" + string3));
                    if (NSLog.debugLoggingAllowedForLevelAndGroups((int)2, (long)0x10000000L)) {
                        NSLog.err.appendln((Throwable)transformerException);
                    }
                    break block9;
                }
            }
            string4 = string;
        }
        if (NSLog.debugLoggingAllowedForLevelAndGroups((int)3, (long)0x10000000L)) {
            NSLog.debug.appendln((Object)"Done transformation. Got: ");
            NSLog.debug.appendln((Object)string4);
        }
        return string4;
    }

    static {
        if (System.getProperty(TransformerFactoryPropertyName) == null) {
            System.setProperty(TransformerFactoryPropertyName, DefaultTransformerClassName);
        }
        transformerFactory = TransformerFactory.newInstance();
    }

    private static class NullTransformer
    extends Transformer {
        public void clearParameters() {
        }

        public ErrorListener getErrorListener() {
            return null;
        }

        public Properties getOutputProperties() {
            return null;
        }

        public String getOutputProperty(String string) {
            return null;
        }

        public Object getParameter(String string) {
            return null;
        }

        public URIResolver getURIResolver() {
            return null;
        }

        public void setErrorListener(ErrorListener errorListener) {
        }

        public void setOutputProperties(Properties properties) {
        }

        public void setOutputProperty(String string, String string2) {
        }

        public void setParameter(String string, Object object) {
        }

        public void setURIResolver(URIResolver uRIResolver) {
        }

        public void transform(Source source, Result result) {
        }
    }
}

