/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.appserver.xml;

import [Ljava.lang.Object;;
import com.webobjects.appserver.xml.WOXMLCoding;
import com.webobjects.appserver.xml.WOXMLException;
import com.webobjects.appserver.xml._private._DecodingHandler;
import com.webobjects.appserver.xml._private._DecodingNode;
import com.webobjects.appserver.xml._private._WOXMLMappingDecoder;
import com.webobjects.eocontrol.EOClassDescription;
import com.webobjects.eocontrol.EOEnterpriseObject;
import com.webobjects.eocontrol._EOCheapCopyMutableArray;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSData;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSKeyValueCoding;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSMutableData;
import com.webobjects.foundation.NSMutableDictionary;
import com.webobjects.foundation.NSTimestamp;
import com.webobjects.foundation.NSTimestampFormatter;
import com.webobjects.foundation._NSUtilities;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Stack;
import org.apache.xerces.impl.dv.util.Base64;
import org.xml.sax.InputSource;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;

public class WOXMLDecoder
implements NSKeyValueCoding {
    private Stack _decodingStack;
    private boolean _useTopOfStack;
    private NSMutableDictionary _decodedObjectCache = new NSMutableDictionary();
    private _DecodingHandler _handler;
    private String _parserClassName = "org.apache.xerces.parsers.SAXParser";
    private Parser _parser = null;
    private String _encoding;

    public String toString() {
        return "<" + this.getClass().getName() + " decodingStack=" + (this._decodingStack == null ? "null" : this._decodingStack.toString()) + " useTopOfStack=" + this._useTopOfStack + " decodedObjectCache=" + this._decodedObjectCache + " decodingHandler=" + (this._handler == null ? "null" : this._handler.toString()) + " _parser=" + (this._parser == null ? "null" : this._parser.toString()) + ">";
    }

    public void _setDecodingStack(Stack stack) {
        this._decodingStack = stack;
    }

    public void _setUseTopOfStack(boolean bl) {
        this._useTopOfStack = bl;
    }

    private _DecodingNode _elementForKey(String string) {
        _DecodingNode _DecodingNode2 = (_DecodingNode)this._decodingStack.peek();
        NSArray nSArray = _DecodingNode2.getChildren();
        int n = nSArray.count();
        NSMutableArray nSMutableArray = new NSMutableArray(n);
        for (int i = 0; i < n; ++i) {
            _DecodingNode _DecodingNode3 = (_DecodingNode)nSArray.objectAtIndex(i);
            if (!_DecodingNode3.getTagName().equals(string)) continue;
            nSMutableArray.addObject((Object)_DecodingNode3);
        }
        return (_DecodingNode)nSMutableArray.objectAtIndex(0);
    }

    private Object objectFromCache(_DecodingNode _DecodingNode2) {
        Object object = null;
        String string = _DecodingNode2.getObjectIDRef();
        if (string != null) {
            object = this._decodedObjectCache.objectForKey((Object)string);
        }
        return object;
    }

    protected void addObjectToCache(_DecodingNode _DecodingNode2, Object object) {
        String string = _DecodingNode2.getObjectID();
        if (string == null) {
            throw new WOXMLException("Missing objectID");
        }
        this._decodedObjectCache.setObjectForKey(object, (Object)string);
    }

    private Object constructObject(_DecodingNode _DecodingNode2, Class clazz, Class[] classArray, Object[] objectArray) {
        Object var5_5 = null;
        try {
            Constructor constructor = clazz.getConstructor(classArray);
            var5_5 = constructor.newInstance(objectArray);
            this.addObjectToCache(_DecodingNode2, var5_5);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            String string = "";
            for (int i = 0; i < classArray.length; ++i) {
                string = string + ", " + classArray[i];
            }
            throw new WOXMLException(noSuchMethodException, ": Missing constructor " + clazz.getName() + "(" + string + ").");
        }
        catch (Exception exception) {
            throw new WOXMLException(exception.getMessage() + ":Unable to decode " + clazz.getName());
        }
        return var5_5;
    }

    private Object constructFromNodeContent(_DecodingNode _DecodingNode2, Class clazz) {
        Object object = this.objectFromCache(_DecodingNode2);
        if (object == null) {
            object = this.constructObject(_DecodingNode2, clazz, new Class[]{String.class}, new Object[]{_DecodingNode2.getContent()});
        }
        return object;
    }

    private Object _decodeNumber(_DecodingNode _DecodingNode2, Class clazz) {
        return this.constructFromNodeContent(_DecodingNode2, clazz);
    }

    private Object _decodeData(_DecodingNode _DecodingNode2, Class clazz) {
        Object var3_3 = null;
        Object object = null;
        String string = _DecodingNode2.getContent();
        String string2 = _DecodingNode2.getObjectIDRef();
        if (string2 != null) {
            Object object2;
            object = NSMutableData.class.isAssignableFrom((object2 = this._decodedObjectCache.objectForKey((Object)string2)).getClass()) ? (NSMutableData.class.isAssignableFrom(clazz) ? object2 : new NSData((NSData)object2)) : (NSMutableData.class.isAssignableFrom(clazz) ? new NSMutableData((NSData)object2) : object2);
        } else {
            byte[] byArray = string.getBytes();
            NSData nSData = new NSData(Base64.decode((byte[])byArray));
            object = NSMutableData.class.isAssignableFrom(clazz) ? new NSMutableData(nSData) : nSData;
            String string3 = _DecodingNode2.getObjectID();
            this._decodedObjectCache.setObjectForKey(object, (Object)string3);
        }
        return object;
    }

    protected Object _decodeString(_DecodingNode _DecodingNode2, Class clazz) {
        return this.constructFromNodeContent(_DecodingNode2, clazz);
    }

    private Object _decodeBoolean(_DecodingNode _DecodingNode2, Class clazz) {
        return this.constructFromNodeContent(_DecodingNode2, clazz);
    }

    private Object _decodeDate(_DecodingNode _DecodingNode2, Class clazz) {
        Object object = this.objectFromCache(_DecodingNode2);
        if (object == null) {
            Object var4_4 = null;
            String string = _DecodingNode2.getContent();
            NSTimestampFormatter nSTimestampFormatter = new NSTimestampFormatter("%Y/%m/%d %H:%M:%S");
            try {
                object = nSTimestampFormatter.parseObject(string);
                this.addObjectToCache(_DecodingNode2, object);
            }
            catch (Exception exception) {
                throw new WOXMLException(exception, ":Unable to decode Date");
            }
        }
        return object;
    }

    private Object _decodeArray(_DecodingNode _DecodingNode2, Class clazz) {
        Object var3_3 = null;
        Object object = null;
        String string = _DecodingNode2.getObjectIDRef();
        if (string != null) {
            Object object2;
            object = NSMutableArray.class.isAssignableFrom((object2 = this._decodedObjectCache.objectForKey((Object)string)).getClass()) ? (NSMutableArray.class.isAssignableFrom(clazz) ? object2 : new NSArray((NSArray)object2)) : (NSMutableArray.class.isAssignableFrom(clazz) ? new NSMutableArray((NSArray)object2) : object2);
        } else {
            try {
                NSArray nSArray = _DecodingNode2.getChildren();
                int n = nSArray.count();
                Object[] objectArray = new Object[n];
                Object[] objectArray2 = new Object[]{objectArray};
                for (int i = 0; i < n; ++i) {
                    _DecodingNode _DecodingNode3 = (_DecodingNode)nSArray.objectAtIndex(i);
                    this._decodingStack.push(_DecodingNode3);
                    this._useTopOfStack = true;
                    Object object3 = this.decodeObjectForKey("element");
                    this._useTopOfStack = false;
                    objectArray[i] = object3;
                    this._decodingStack.pop();
                }
                object = this.constructObject(_DecodingNode2, clazz, new Class[]{Object;.class}, objectArray2);
            }
            catch (Exception exception) {
                throw new WOXMLException(exception, ":Unable to decode Array");
            }
        }
        return object;
    }

    private Object _decodeDictionary(_DecodingNode _DecodingNode2, Class clazz) {
        Object var3_3 = null;
        Object object = null;
        String string = _DecodingNode2.getObjectIDRef();
        if (string != null) {
            Object object2;
            object = NSMutableDictionary.class.isAssignableFrom((object2 = this._decodedObjectCache.objectForKey((Object)string)).getClass()) ? (NSMutableDictionary.class.isAssignableFrom(clazz) ? object2 : new NSDictionary((NSDictionary)object2)) : (NSMutableDictionary.class.isAssignableFrom(clazz) ? new NSMutableDictionary((NSDictionary)object2) : object2);
        } else {
            String string2 = _DecodingNode2.getObjectID();
            try {
                Object[] objectArray;
                NSArray nSArray = _DecodingNode2.getChildren();
                int n = nSArray.count();
                Object[] objectArray2 = new Object[2];
                Object[] objectArray3 = new Object[n];
                objectArray2[0] = objectArray = new Object[n];
                objectArray2[1] = objectArray3;
                for (int i = 0; i < n; ++i) {
                    _DecodingNode _DecodingNode3 = (_DecodingNode)nSArray.objectAtIndex(i);
                    this._decodingStack.push(_DecodingNode3);
                    this._useTopOfStack = true;
                    String string3 = _DecodingNode3.getTagName();
                    Object object3 = this.decodeObjectForKey(string3);
                    this._useTopOfStack = false;
                    objectArray3[i] = string3;
                    objectArray[i] = object3;
                    this._decodingStack.pop();
                }
                object = this.constructObject(_DecodingNode2, clazz, new Class[]{Object;.class, Object;.class}, objectArray2);
            }
            catch (Exception exception) {
                throw new WOXMLException(exception, ":Unable to decode Dictionary");
            }
        }
        return object;
    }

    private Object _decodeEO(_DecodingNode _DecodingNode2, Class clazz) {
        Object var3_3 = null;
        Object object = null;
        try {
            String string = _DecodingNode2.getTagName();
            String string2 = _DecodingNode2.getObjectIDRef();
            if (string2 != null) {
                object = this._decodedObjectCache.objectForKey((Object)string2);
            } else {
                EOClassDescription eOClassDescription = EOClassDescription.classDescriptionForEntityName((String)string);
                object = eOClassDescription.createInstanceWithEditingContext(null, null);
                String string3 = _DecodingNode2.getObjectID();
                this._decodedObjectCache.setObjectForKey(object, (Object)string3);
                NSArray nSArray = _DecodingNode2.getChildren();
                int n = nSArray.count();
                for (int i = 0; i < n; ++i) {
                    Object object2;
                    String string4;
                    _DecodingNode _DecodingNode3 = (_DecodingNode)nSArray.objectAtIndex(i);
                    if (_DecodingNode3.getChildren().count() > 0) {
                        this._decodingStack.push(_DecodingNode3);
                        this._useTopOfStack = true;
                        string4 = _DecodingNode3.getTagName();
                        object2 = this.decodeObjectForKey(string4);
                        ((EOEnterpriseObject)object).validateTakeValueForKeyPath(object2, string4);
                        this._decodingStack.pop();
                        continue;
                    }
                    if (_DecodingNode3.getContent() == null) {
                        object2 = NSKeyValueCoding.NullValue;
                        continue;
                    }
                    this._decodingStack.push(_DecodingNode3);
                    this._useTopOfStack = true;
                    string4 = _DecodingNode3.getTagName();
                    object2 = this.decodeObjectForKey(string4);
                    ((EOEnterpriseObject)object).validateTakeValueForKeyPath(object2, string4);
                    this._decodingStack.pop();
                }
            }
        }
        catch (Exception exception) {
            throw new WOXMLException(exception, ":Unable to create EO.");
        }
        return object;
    }

    protected WOXMLDecoder() {
    }

    public String parserClassName() {
        return this._parserClassName;
    }

    public void setParserClassName(String string) {
        this._parserClassName = string;
    }

    public static WOXMLDecoder decoder() {
        return new WOXMLDecoder();
    }

    public static WOXMLDecoder decoderWithMapping(String string) {
        return new _WOXMLMappingDecoder(string);
    }

    protected _DecodingHandler handler() {
        return new _DecodingHandler(this);
    }

    public Parser parser() {
        if (this._parser == null) {
            Class clazz = _NSUtilities.classWithName((String)this._parserClassName);
            if (clazz == null) {
                throw new WOXMLException("Could not find parser class named " + this._parserClassName);
            }
            try {
                this._parser = (Parser)clazz.newInstance();
            }
            catch (InstantiationException instantiationException) {
                throw new WOXMLException(instantiationException, "Could not create parser of class:" + this._parserClassName);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new WOXMLException(illegalAccessException, "Could not create parser of class:" + this._parserClassName);
            }
            this._handler = this.handler();
            this._parser.setDocumentHandler(this._handler);
        }
        return this._parser;
    }

    public synchronized void setEncoding(String string) {
        this._encoding = string;
    }

    public synchronized String encoding() {
        return this._encoding;
    }

    public synchronized Object decodeRootObject(String string) {
        InputSource inputSource = new InputSource(string);
        return this.decodeRootObject(inputSource);
    }

    public synchronized Object decodeRootObject(NSData nSData) {
        Object object = null;
        if (nSData != null) {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(nSData.bytes());
            InputSource inputSource = new InputSource(byteArrayInputStream);
            object = this.decodeRootObject(inputSource);
        }
        return object;
    }

    public synchronized Object decodeRootObject(InputSource inputSource) {
        Object object = null;
        try {
            if (this._encoding != null) {
                inputSource.setEncoding(this._encoding);
            }
            this.parser().parse(inputSource);
        }
        catch (SAXException sAXException) {
            throw new WOXMLException(sAXException.getException() != null ? sAXException.getException() : sAXException);
        }
        catch (IOException iOException) {
            throw new WOXMLException(iOException);
        }
        object = this._handler.root();
        this._handler.reset();
        return object;
    }

    protected String getChildNodeType(_DecodingNode _DecodingNode2) {
        return _DecodingNode2.getType();
    }

    public Object decodeObjectForKey(String string) {
        Object object;
        String string2;
        Object object2 = null;
        Class clazz = null;
        Constructor constructor = null;
        Object object3 = this._useTopOfStack ? (_DecodingNode)this._decodingStack.peek() : this._elementForKey(string);
        String string3 = this.getChildNodeType((_DecodingNode)object3);
        if (string3.equals("?")) {
            return null;
        }
        if (string3.equals("relationship") && (string2 = ((_DecodingNode)object3).getRelationshipType()).equals("to-one")) {
            object = (_DecodingNode)((_DecodingNode)object3).getChildren().objectAtIndex(0);
            this._decodingStack.pop();
            this._decodingStack.push(object);
            string3 = ((_DecodingNode)object).getType();
            object3 = object;
        }
        if ((clazz = _NSUtilities.classWithName((String)string3)) == null) {
            throw new WOXMLException("Objects must be non-null and implement the WOXMLCoding interface.");
        }
        if (WOXMLCoding.class.isAssignableFrom(clazz)) {
            string2 = ((_DecodingNode)object3).getObjectIDRef();
            if (string2 != null) {
                object2 = this._decodedObjectCache.objectForKey((Object)string2);
            } else {
                object = ((_DecodingNode)object3).getObjectID();
                Class[] classArray = new Class[]{WOXMLDecoder.class};
                try {
                    constructor = clazz.getConstructor(classArray);
                    Object[] objectArray = new Object[]{this};
                    this._useTopOfStack = false;
                    this._decodingStack.push(object3);
                    object2 = constructor.newInstance(objectArray);
                    if (object != null) {
                        this._decodedObjectCache.setObjectForKey(object2, object);
                    }
                    this._decodingStack.pop();
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    throw new WOXMLException(noSuchMethodException, ": Missing constructor " + clazz.getName() + "(com.webobjects.appserver.xml.WOXMLDecoder).");
                }
                catch (SecurityException securityException) {
                    throw new WOXMLException(securityException);
                }
                catch (InvocationTargetException invocationTargetException) {
                    throw new WOXMLException(invocationTargetException.getTargetException());
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new WOXMLException(illegalAccessException);
                }
                catch (InstantiationException instantiationException) {
                    throw new WOXMLException(instantiationException);
                }
            }
        } else if (String.class.isAssignableFrom(clazz)) {
            object2 = this._decodeString((_DecodingNode)object3, clazz);
        } else if (NSTimestamp._CLASS.isAssignableFrom(clazz)) {
            object2 = this._decodeDate((_DecodingNode)object3, clazz);
        } else if (_EOCheapCopyMutableArray.class.isAssignableFrom(clazz)) {
            object2 = new _EOCheapCopyMutableArray((NSArray)this._decodeArray((_DecodingNode)object3, NSMutableArray.class));
        } else if (NSArray.class.isAssignableFrom(clazz)) {
            object2 = this._decodeArray((_DecodingNode)object3, clazz);
        } else if (NSDictionary.class.isAssignableFrom(clazz)) {
            object2 = this._decodeDictionary((_DecodingNode)object3, clazz);
        } else if (NSData.class.isAssignableFrom(clazz)) {
            object2 = this._decodeData((_DecodingNode)object3, clazz);
        } else if (EOEnterpriseObject.class.isAssignableFrom(clazz)) {
            object2 = this._decodeEO((_DecodingNode)object3, clazz);
        } else if (Number.class.isAssignableFrom(clazz)) {
            object2 = this._decodeNumber((_DecodingNode)object3, clazz);
        } else if (Boolean.class.isAssignableFrom(clazz)) {
            object2 = this._decodeBoolean((_DecodingNode)object3, clazz);
        }
        return object2;
    }

    public boolean decodeBooleanForKey(String string) {
        _DecodingNode _DecodingNode2 = this._elementForKey(string);
        return _DecodingNode2.getContent().equals("True");
    }

    public int decodeIntForKey(String string) {
        _DecodingNode _DecodingNode2 = this._elementForKey(string);
        String string2 = _DecodingNode2.getContent();
        int n = Integer.parseInt(string2);
        return n;
    }

    public float decodeFloatForKey(String string) {
        _DecodingNode _DecodingNode2 = this._elementForKey(string);
        String string2 = _DecodingNode2.getContent();
        float f = Float.valueOf(string2).floatValue();
        return f;
    }

    public double decodeDoubleForKey(String string) {
        _DecodingNode _DecodingNode2 = this._elementForKey(string);
        String string2 = _DecodingNode2.getContent();
        double d = Double.valueOf(string2);
        return d;
    }

    public Object valueForKey(String string) {
        return NSKeyValueCoding.DefaultImplementation.valueForKey((Object)this, (String)string);
    }

    public void takeValueForKey(Object object, String string) {
        NSKeyValueCoding.DefaultImplementation.takeValueForKey((Object)this, (Object)object, (String)string);
    }
}

