/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.ashwood.dbutil;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import org.objectstyle.ashwood.dbutil.ForeignKey;
import org.objectstyle.ashwood.dbutil.Table;
import org.objectstyle.ashwood.graph.Digraph;

public class DbUtils {
    private DbUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void getAllTables(String string, String string2, Collection collection, DatabaseMetaData databaseMetaData) throws SQLException {
        String[] stringArray = new String[]{"TABLE"};
        ResultSet resultSet = null;
        try {
            resultSet = databaseMetaData.getTables(string, string2, null, stringArray);
            while (resultSet.next()) {
                Table table = new Table(string, string2, resultSet.getString("TABLE_NAME"));
                collection.add(table);
            }
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            try {
                resultSet.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            resultSet.close();
        }
        catch (Exception exception) {}
    }

    public static void refreshTables(Collection collection, DatabaseMetaData databaseMetaData) throws SQLException {
        DbUtils.refreshTables(collection, databaseMetaData, true, true, true);
    }

    public static void refreshTables(Collection collection, DatabaseMetaData databaseMetaData, boolean bl, boolean bl2, boolean bl3) throws SQLException {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Table table = (Table)iterator.next();
            if (bl) {
                table.refreshColumns(databaseMetaData);
            }
            if (bl2) {
                table.refreshPrimaryKeys(databaseMetaData);
            }
            if (!bl3) continue;
            table.refreshForeignKeys(databaseMetaData);
        }
    }

    public static Digraph buildReferentialDigraph(Digraph digraph, Collection collection) {
        Object object;
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            object = (Table)iterator.next();
            hashMap.put(((Table)object).getFullName(), object);
            digraph.addVertex(object);
        }
        object = collection.iterator();
        while (object.hasNext()) {
            Table table = (Table)object.next();
            Iterator iterator2 = table.getForeignKeys().iterator();
            while (iterator2.hasNext()) {
                ForeignKey foreignKey = (ForeignKey)iterator2.next();
                String string = Table.composeFullName(foreignKey.getPkTableCatalog(), foreignKey.getPkTableSchema(), foreignKey.getPkTableName());
                Table table2 = (Table)hashMap.get(string);
                if (table2 == null) continue;
                ArrayList<ForeignKey> arrayList = (ArrayList<ForeignKey>)digraph.getArc(table2, table);
                if (arrayList == null) {
                    arrayList = new ArrayList<ForeignKey>();
                    digraph.putArc(table2, table, arrayList);
                }
                arrayList.add(foreignKey);
            }
        }
        return digraph;
    }
}

