/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.cayenne.access;

import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Level;
import org.objectstyle.cayenne.CayenneException;
import org.objectstyle.cayenne.CayenneRuntimeException;
import org.objectstyle.cayenne.DataRow;
import org.objectstyle.cayenne.ObjectId;
import org.objectstyle.cayenne.access.OperationObserver;
import org.objectstyle.cayenne.access.ResultIterator;
import org.objectstyle.cayenne.dba.TypesMapping;
import org.objectstyle.cayenne.map.DbAttribute;
import org.objectstyle.cayenne.query.BatchQuery;
import org.objectstyle.cayenne.query.InsertBatchQuery;
import org.objectstyle.cayenne.query.Query;
import org.objectstyle.cayenne.util.Util;

class DataDomainFlushObserver
implements OperationObserver {
    DataDomainFlushObserver() {
    }

    public void nextQueryException(Query query, Exception ex) {
        throw new CayenneRuntimeException("Raising from query exception.", Util.unwindException(ex));
    }

    public void nextGlobalException(Exception ex) {
        throw new CayenneRuntimeException("Raising from underlyingQueryEngine exception.", Util.unwindException(ex));
    }

    public void nextGeneratedDataRows(Query query, ResultIterator keysIterator) {
        List keys;
        try {
            keys = keysIterator.dataRows(true);
        }
        catch (CayenneException ex) {
            throw new CayenneRuntimeException("Error reading primary key", Util.unwindException(ex));
        }
        if (!(query instanceof InsertBatchQuery)) {
            throw new CayenneRuntimeException("Generated keys only supported for InsertBatchQuery, instead got " + query);
        }
        BatchQuery batch = (BatchQuery)query;
        ObjectId id = batch.getObjectId();
        if (id == null || !id.isTemporary()) {
            return;
        }
        if (keys.size() != 1) {
            throw new CayenneRuntimeException("One and only one PK row is expected, instead got " + keys.size());
        }
        DataRow key = (DataRow)keys.get(0);
        if (key.size() == 0) {
            throw new CayenneRuntimeException("Empty key generated.");
        }
        if (key.size() > 1) {
            throw new CayenneRuntimeException("Only a single column autogenerated PK is supported. Generated key: " + key);
        }
        Iterator it = batch.getDbEntity().getGeneratedAttributes().iterator();
        while (it.hasNext()) {
            DbAttribute attribute = (DbAttribute)it.next();
            if (!attribute.isPrimaryKey()) continue;
            Object value = key.values().iterator().next();
            if (TypesMapping.isNumeric(attribute.getType())) {
                String expectedType = TypesMapping.getJavaBySqlType(attribute.getType());
                if (value instanceof Number && !value.getClass().getName().equals(expectedType)) {
                    value = new Integer(((Number)value).intValue());
                }
            }
            id.getReplacementIdMap().put(attribute.getName(), value);
            break;
        }
    }

    public void nextBatchCount(Query query, int[] resultCount) {
    }

    public void nextCount(Query query, int resultCount) {
    }

    public void nextDataRows(Query query, List dataRows) {
    }

    public void nextDataRows(Query q, ResultIterator it) {
        throw new UnsupportedOperationException("'nextDataRows(Query,ResultIterator)' is unsupported (and unexpected) on commit.");
    }

    public Level getLoggingLevel() {
        return Level.INFO;
    }

    public boolean isIteratedResult() {
        return false;
    }
}

